/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.util.core.threads;

import com.indeed.util.core.threads.LogOnUncaughtExceptionHandler;
import java.util.concurrent.ThreadFactory;
import org.apache.log4j.Logger;

public class NamedThreadFactory
implements ThreadFactory {
    private final String threadNamePrefix;
    private final String threadName;
    private final boolean isDaemon;
    private int threadCount = 0;
    private final Logger logger;

    public NamedThreadFactory(String threadName) {
        this(threadName, false);
    }

    public NamedThreadFactory(String threadName, boolean isDaemon) {
        this(threadName, isDaemon, null);
    }

    public NamedThreadFactory(String threadName, String loggerName) {
        this(threadName, false, Logger.getLogger((String)loggerName));
    }

    public NamedThreadFactory(String threadName, Logger logger) {
        this(threadName, false, logger);
    }

    public NamedThreadFactory(String threadName, boolean isDaemon, Logger logger) {
        this.threadName = threadName;
        this.threadNamePrefix = threadName + "-Thread-";
        this.isDaemon = isDaemon;
        this.logger = logger;
    }

    public String getThreadName() {
        return this.threadName;
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread t = new Thread(r, this.threadNamePrefix + this.threadCount++);
        if (this.isDaemon) {
            t.setDaemon(true);
        }
        t.setUncaughtExceptionHandler(new LogOnUncaughtExceptionHandler(this.getLogger(r)));
        return t;
    }

    private Logger getLogger(Runnable r) {
        if (this.logger != null) {
            return this.logger;
        }
        Class<?> runnableClass = r.getClass();
        if (runnableClass.getPackage().getName().startsWith("com.indeed.")) {
            return Logger.getLogger(runnableClass);
        }
        return Logger.getLogger(NamedThreadFactory.class);
    }
}

