/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.util.core.io;

import com.google.common.base.Function;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;

public class Closeables2 {
    public static void closeQuietly(@Nullable Closeable closeable, @Nonnull Logger log) {
        try {
            if (null != closeable) {
                closeable.close();
            }
        }
        catch (Exception e) {
            log.error((Object)"Exception during cleanup of a Closeable, ignoring", (Throwable)e);
        }
    }

    public static void closeAll(@Nonnull Iterable<? extends Closeable> closeables, @Nonnull Logger log) {
        Throwable throwable = null;
        for (Closeable closeable : closeables) {
            try {
                Closeables2.closeQuietly(closeable, log);
            }
            catch (Throwable e) {
                if (throwable == null) {
                    throwable = e;
                    continue;
                }
                log.error((Object)("Suppressing throwable thrown when closing " + closeable), e);
            }
        }
        if (throwable != null) {
            throw Throwables.propagate(throwable);
        }
    }

    public static void closeAll(@Nonnull Logger log, Closeable ... closeables) {
        Closeables2.closeAll(Arrays.asList(closeables), log);
    }

    public static void closeAll(@Nonnull Logger log, @Nonnull Iterable<? extends Closeable> closeables) {
        Closeables2.closeAll(closeables, log);
    }

    public static <C extends Closeable> Closeable forIterable(final @Nonnull Logger log, final @Nonnull Iterable<C> closeables) {
        return new Closeable(){

            @Override
            public void close() throws IOException {
                Closeables2.closeAll(log, closeables);
            }
        };
    }

    public static <C extends Closeable, T extends Iterable<C>> Closeable forIterable2(final @Nonnull Logger log, final @Nonnull Iterable<T> closeables) {
        return new Closeable(){

            @Override
            public void close() throws IOException {
                Closeables2.closeAll(log, Iterables.transform((Iterable)closeables, (Function)new Function<T, Closeable>(){

                    public Closeable apply(@Nullable T input) {
                        if (input == null) {
                            return new Closeable(){

                                @Override
                                public void close() throws IOException {
                                }
                            };
                        }
                        return Closeables2.forIterable(log, input);
                    }
                }));
            }
        };
    }

    public static Closeable forArray(final @Nonnull Logger log, final Closeable ... closeables) {
        return new Closeable(){

            @Override
            public void close() throws IOException {
                Closeables2.closeAll(log, closeables);
            }
        };
    }
}

