/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.util.core.threads;

import java.io.Serializable;
import java.util.Arrays;
import javax.annotation.Nullable;

public class ThreadSafeBitSet
implements Serializable {
    private static final long serialVersionUID = -7685178028568216346L;
    private final int[] bits;
    private final int size;

    public ThreadSafeBitSet(int size) {
        this.size = size;
        this.bits = new int[size + 31 >>> 5];
    }

    public final void set(int index, boolean value) {
        if (value) {
            this.set(index);
        } else {
            this.clear(index);
        }
    }

    public final boolean get(int index) {
        int t = 1 << (index & 0x1F);
        return (this.bits[index >> 5] & t) != 0;
    }

    public final int size() {
        return this.size;
    }

    public final void set(int index) {
        int n = index >>> 5;
        this.bits[n] = this.bits[n] | 1 << (index & 0x1F);
    }

    public final void clear(int index) {
        int n = index >>> 5;
        this.bits[n] = this.bits[n] & ~(1 << (index & 0x1F));
    }

    public final void clearAll() {
        Arrays.fill(this.bits, 0);
    }

    public final void setAll() {
        Arrays.fill(this.bits, -1);
    }

    public final void invertAll() {
        for (int i = 0; i < this.bits.length; ++i) {
            this.bits[i] = ~this.bits[i];
        }
    }

    public final void and(ThreadSafeBitSet other) {
        if (other.size != this.size) {
            throw new IllegalArgumentException("BitSets must be of equal size");
        }
        for (int i = 0; i < this.bits.length; ++i) {
            int n = i;
            this.bits[n] = this.bits[n] & other.bits[i];
        }
    }

    public final void or(ThreadSafeBitSet other) {
        if (other.size != this.size) {
            throw new IllegalArgumentException("BitSets must be of equal size");
        }
        for (int i = 0; i < this.bits.length; ++i) {
            int n = i;
            this.bits[n] = this.bits[n] | other.bits[i];
        }
    }

    public final void xor(ThreadSafeBitSet other) {
        if (other.size != this.size) {
            throw new IllegalArgumentException("BitSets must be of equal size");
        }
        for (int i = 0; i < this.bits.length; ++i) {
            int n = i;
            this.bits[n] = this.bits[n] ^ other.bits[i];
        }
    }

    public final void copyFrom(ThreadSafeBitSet other) {
        System.arraycopy(other.bits, 0, this.bits, 0, other.bits.length);
    }

    public final int cardinality() {
        int sum = 0;
        for (int x : this.bits) {
            sum += Integer.bitCount(x);
        }
        return sum;
    }

    public static ThreadSafeBitSet expand(@Nullable ThreadSafeBitSet oldBitSet, int newSize) {
        if (oldBitSet != null && newSize <= oldBitSet.size) {
            return oldBitSet;
        }
        ThreadSafeBitSet ret = new ThreadSafeBitSet(newSize);
        if (oldBitSet != null) {
            ret.copyFrom(oldBitSet);
        }
        return ret;
    }

    public static boolean equals(ThreadSafeBitSet bitset1, ThreadSafeBitSet bitset2) {
        if (bitset1 == bitset2) {
            return true;
        }
        if (bitset1 == null || bitset2 == null) {
            return false;
        }
        return Arrays.equals(bitset1.bits, bitset2.bits);
    }

    public static ThreadSafeBitSet or(ThreadSafeBitSet a, ThreadSafeBitSet b) {
        int i;
        int size = Math.max(a.size(), b.size());
        ThreadSafeBitSet ret = new ThreadSafeBitSet(size);
        for (i = 0; i < a.bits.length; ++i) {
            int n = i;
            ret.bits[n] = ret.bits[n] | a.bits[i];
        }
        for (i = 0; i < b.bits.length; ++i) {
            int n = i;
            ret.bits[n] = ret.bits[n] | b.bits[i];
        }
        return ret;
    }
}

