/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.util.core.reference;

import java.io.Closeable;
import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;

public final class SharedReference<T>
implements Closeable {
    private static final Logger log = Logger.getLogger(SharedReference.class);
    private static final boolean debug = Boolean.getBoolean("com.indeed.common.util.reference.SharedReference.debug");
    private final T t;
    private final SharedReference<T> original;
    private boolean closed = false;
    private final Closeable closeable;
    private int refCount;
    private final ReferenceLeakDebugger referenceLeakDebugger;

    public static <T extends Closeable> SharedReference<T> create(T t) {
        return new SharedReference<T>(t, t);
    }

    public static <T> SharedReference<T> create(T t, Closeable closeable) {
        return new SharedReference<T>(t, closeable);
    }

    private SharedReference(T t, Closeable closeable) {
        this.t = t;
        this.closeable = closeable;
        this.original = this;
        this.refCount = 1;
        this.referenceLeakDebugger = debug ? new ReferenceLeakDebugger() : null;
    }

    private SharedReference(SharedReference<T> ref) {
        this.t = ref.t;
        this.original = ref.original;
        this.closeable = null;
        this.refCount = 0;
        this.referenceLeakDebugger = debug ? new ReferenceLeakDebugger() : null;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        super.decRef();
    }

    public synchronized SharedReference<T> copy() {
        if (this.closed) {
            throw new IllegalStateException("cannot copy closed ref");
        }
        if (!super.incRef()) {
            throw new IllegalStateException("resource has been freed");
        }
        return new SharedReference<T>(this);
    }

    @Nullable
    public synchronized SharedReference<T> tryCopy() {
        if (!super.incRef()) {
            return null;
        }
        return new SharedReference<T>(this);
    }

    public T get() {
        return this.t;
    }

    public synchronized int getRefCount() {
        if (this.closed) {
            return 0;
        }
        return this.original.refCount;
    }

    private synchronized boolean incRef() {
        if (this.refCount <= 0) {
            return false;
        }
        ++this.refCount;
        return true;
    }

    private synchronized void decRef() throws IOException {
        if (this.refCount <= 0) {
            throw new IllegalStateException("resource has been freed");
        }
        --this.refCount;
        if (this.refCount == 0) {
            this.closeable.close();
        }
    }

    private final class ReferenceLeakDebugger {
        private ReferenceLeakDebugger() {
        }

        protected void finalize() throws Throwable {
            if (!SharedReference.this.closed) {
                log.error((Object)("SharedReference to " + SharedReference.this.t.getClass() + " " + SharedReference.this.t + " was not closed! Closing in finalizer :("));
            }
        }
    }
}

