/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.util.core;

import java.util.Arrays;
import javax.annotation.Nullable;

public class ReleaseVersion
implements Comparable<ReleaseVersion> {
    private static final char WILDCARD = 'x';
    private final long version;
    private final MatchPrecision matchPrecision;
    public static final int MAX_MAJOR_VERSION = Short.MAX_VALUE;
    public static final int MAX_MINOR_VERSION = 65535;
    public static final int MAX_PATCH_VERSION = 65535;
    public static final int MAX_BUILD_NUMBER = 65535;

    private static boolean isWildcard(@Nullable String versionComponent) {
        return versionComponent != null && versionComponent.length() == 1 && 'x' == versionComponent.charAt(0);
    }

    private ReleaseVersion(short majorVersion, int minorVersion, int patchVersion, int buildNumber, MatchPrecision matchPrecision) {
        this.version = (long)majorVersion << 48 | (long)minorVersion << 32 | (long)patchVersion << 16 | (long)buildNumber;
        this.matchPrecision = matchPrecision;
    }

    public MatchPrecision getMatchPrecision() {
        return this.matchPrecision;
    }

    public String toString() {
        short majorVersion = (short)(this.version >> 48 & 0x7FFFL);
        int minorVersion = (int)(this.version >> 32) & 0xFFFF;
        int patchVersion = (int)(this.version >> 16) & 0xFFFF;
        int buildNumber = (int)(this.version & 0xFFFFL);
        StringBuilder b = new StringBuilder();
        b.append(Short.toString(majorVersion)).append('.');
        if (this.matchPrecision == MatchPrecision.MAJOR) {
            b.append('x');
        } else {
            b.append(Integer.toString(minorVersion)).append('.');
            if (this.matchPrecision == MatchPrecision.MINOR) {
                b.append('x');
            } else {
                b.append(Integer.toString(patchVersion)).append('.');
                if (this.matchPrecision == MatchPrecision.PATCH) {
                    b.append('x');
                } else {
                    b.append(Integer.toString(buildNumber));
                }
            }
        }
        return b.toString();
    }

    @Override
    public int compareTo(ReleaseVersion other) {
        MatchPrecision minPrecision = MatchPrecision.forLength(Math.min(this.matchPrecision.length, other.matchPrecision.length));
        long lhs = this.version & minPrecision.mask;
        long rhs = other.version & minPrecision.mask;
        return lhs < rhs ? -1 : (lhs == rhs ? 0 : 1);
    }

    public boolean equals(Object o) {
        if (o instanceof ReleaseVersion) {
            return this.compareTo((ReleaseVersion)o) == 0;
        }
        return false;
    }

    public static ReleaseVersion fromString(String versionString) {
        return new Builder().fromString(versionString, false).build();
    }

    public static ReleaseVersion fromStringSafely(String versionString, ReleaseVersion defaultVersion) {
        try {
            return new Builder().fromString(versionString, true).build();
        }
        catch (Exception e) {
            return defaultVersion;
        }
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private short majorVersion;
        private int minorVersion;
        private int patchVersion;
        private int buildNumber;
        private MatchPrecision matchPrecision = MatchPrecision.BUILD;

        public Builder setMatchPrecision(MatchPrecision matchPrecision) {
            this.matchPrecision = matchPrecision;
            return this;
        }

        public Builder setMajorVersion(int majorVersion) {
            if (majorVersion > Short.MAX_VALUE || majorVersion < 0) {
                throw new IllegalArgumentException("invalid major version " + majorVersion);
            }
            this.majorVersion = (short)majorVersion;
            return this;
        }

        public Builder setMinorVersion(int minorVersion) {
            if (minorVersion > 65535 || minorVersion < 0) {
                throw new IllegalArgumentException("invalid minor version " + minorVersion);
            }
            this.minorVersion = minorVersion;
            return this;
        }

        public Builder setPatchVersion(int patchVersion) {
            if (patchVersion > 65535 || patchVersion < 0) {
                throw new IllegalArgumentException("invalid patch version " + patchVersion);
            }
            this.patchVersion = patchVersion;
            return this;
        }

        public Builder setBuildNumber(int buildNumber) {
            if (buildNumber > 65535 || buildNumber < 0) {
                throw new IllegalArgumentException("invalid build number " + buildNumber);
            }
            this.buildNumber = buildNumber;
            return this;
        }

        public Builder fromString(String versionString, boolean lenient) {
            String[] parts;
            block8: {
                parts = versionString.split("\\.");
                if (parts.length > 0 && ReleaseVersion.isWildcard(parts[parts.length - 1])) {
                    parts = Arrays.copyOfRange(parts, 0, parts.length - 1);
                    if (!lenient && parts.length == 0) {
                        throw new IllegalArgumentException("Invalid version string: " + versionString);
                    }
                } else if (!lenient && parts.length < 4) {
                    throw new IllegalArgumentException("ReleaseVersion string must have 4 numbers or end in x: " + versionString);
                }
                this.setMajorVersion(parts.length > 0 ? Integer.parseInt(parts[0]) : 0);
                try {
                    this.setMinorVersion(parts.length > 1 ? Integer.parseInt(parts[1]) : 0);
                    this.setPatchVersion(parts.length > 2 ? Integer.parseInt(parts[2]) : 0);
                    this.setBuildNumber(parts.length > 3 ? Integer.parseInt(parts[3]) : 0);
                }
                catch (IllegalArgumentException e) {
                    if (lenient) break block8;
                    throw e;
                }
            }
            if (lenient) {
                this.setMatchPrecision(MatchPrecision.BUILD);
            } else {
                this.setMatchPrecision(MatchPrecision.forLength(Math.min(parts.length, 4)));
            }
            return this;
        }

        public ReleaseVersion build() {
            return new ReleaseVersion(this.majorVersion, this.minorVersion, this.patchVersion, this.buildNumber, this.matchPrecision);
        }
    }

    public static enum MatchPrecision {
        MAJOR(1, 0x7FFF000000000000L),
        MINOR(2, 0x7FFFFFFF00000000L),
        PATCH(3, 0x7FFFFFFFFFFF0000L),
        BUILD(4, Long.MAX_VALUE);

        int length;
        long mask;

        private MatchPrecision(int length, long mask) {
            this.length = length;
            this.mask = mask;
        }

        static MatchPrecision forLength(int length) {
            switch (length) {
                case 0: 
                case 1: {
                    return MAJOR;
                }
                case 2: {
                    return MINOR;
                }
                case 3: {
                    return PATCH;
                }
                case 4: {
                    return BUILD;
                }
            }
            return null;
        }
    }
}

