/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.common.model;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.indeed.proctor.common.model.Allocation;
import com.indeed.proctor.common.model.TestBucket;
import com.indeed.proctor.common.model.TestDependency;
import com.indeed.proctor.common.model.TestType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TestDefinition {
    private String version;
    @Nonnull
    private Map<String, Object> constants = Collections.emptyMap();
    @Nonnull
    private Map<String, Object> specialConstants = Collections.emptyMap();
    @Nonnull
    private String salt;
    @Nullable
    private String rule;
    @Nonnull
    private List<TestBucket> buckets = Collections.emptyList();
    @Nonnull
    private List<Allocation> allocations = Collections.emptyList();
    private boolean silent;
    @Nonnull
    private List<String> metaTags = Collections.emptyList();
    @Nonnull
    private TestType testType;
    @Nullable
    private String description;
    @Nullable
    private TestDependency dependsOn;
    private boolean evaluateForIncognitoUsers;
    private boolean enableUnitlessAllocations;

    public TestDefinition() {
    }

    @Deprecated
    public TestDefinition(String version, @Nullable String rule, @Nonnull TestType testType, @Nonnull String salt, @Nonnull List<TestBucket> buckets, @Nonnull List<Allocation> allocations, @Nonnull Map<String, Object> constants, @Nonnull Map<String, Object> specialConstants, @Nullable String description) {
        this(version, rule, testType, salt, buckets, allocations, false, constants, specialConstants, description, Collections.emptyList());
    }

    @Deprecated
    public TestDefinition(String version, @Nullable String rule, @Nonnull TestType testType, @Nonnull String salt, @Nonnull List<TestBucket> buckets, @Nonnull List<Allocation> allocations, boolean silent, @Nonnull Map<String, Object> constants, @Nonnull Map<String, Object> specialConstants, @Nullable String description) {
        this(version, rule, testType, salt, buckets, allocations, silent, constants, specialConstants, description, Collections.emptyList());
    }

    @Deprecated
    public TestDefinition(String version, @Nullable String rule, @Nonnull TestType testType, @Nonnull String salt, @Nonnull List<TestBucket> buckets, @Nonnull List<Allocation> allocations, boolean silent, @Nonnull Map<String, Object> constants, @Nonnull Map<String, Object> specialConstants, @Nullable String description, @Nonnull List<String> metaTags) {
        this.version = version;
        this.constants = constants;
        this.specialConstants = specialConstants;
        this.salt = salt;
        this.rule = rule;
        this.buckets = buckets;
        this.allocations = allocations;
        this.silent = silent;
        this.testType = testType;
        this.description = description;
        this.metaTags = metaTags;
        this.evaluateForIncognitoUsers = false;
    }

    public TestDefinition(@Nonnull TestDefinition other) {
        this(TestDefinition.builder().from(other));
    }

    private TestDefinition(@Nonnull Builder builder) {
        this.version = builder.version;
        this.rule = builder.rule;
        this.testType = Objects.requireNonNull(builder.testType, "testType must be set");
        this.salt = Objects.requireNonNull(builder.salt, "salt must be set");
        this.buckets = builder.buckets.build();
        this.allocations = builder.allocations.build();
        this.silent = builder.silent;
        this.constants = builder.constants.build();
        this.specialConstants = builder.specialConstants.build();
        this.description = builder.description;
        this.metaTags = builder.metaTags.build();
        this.dependsOn = builder.dependsOn;
        this.evaluateForIncognitoUsers = builder.evaluateForIncognitoUsers;
        this.enableUnitlessAllocations = builder.enableUnitlessAllocations;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getVersion() {
        return this.version;
    }

    @Deprecated
    public void setVersion(String version) {
        this.version = version;
    }

    @Nonnull
    public Map<String, Object> getConstants() {
        return this.constants;
    }

    @Deprecated
    public void setConstants(@Nonnull Map<String, Object> constants) {
        this.constants = constants;
    }

    @Nonnull
    public Map<String, Object> getSpecialConstants() {
        return this.specialConstants;
    }

    @Deprecated
    public void setSpecialConstants(@Nonnull Map<String, Object> specialConstants) {
        this.specialConstants = specialConstants;
    }

    @Nullable
    public String getRule() {
        return this.rule;
    }

    @Deprecated
    public void setSubrule(@Nullable String subrule) {
        this.setRule(subrule);
    }

    @Deprecated
    public void setRule(@Nullable String rule) {
        this.rule = rule;
    }

    @Nonnull
    public String getSalt() {
        return this.salt;
    }

    @Deprecated
    public void setSalt(@Nonnull String salt) {
        this.salt = salt;
    }

    @Nonnull
    public List<TestBucket> getBuckets() {
        return this.buckets;
    }

    @Deprecated
    public void setBuckets(@Nonnull List<TestBucket> buckets) {
        this.buckets = buckets;
    }

    @Nonnull
    public List<Allocation> getAllocations() {
        return this.allocations;
    }

    @Deprecated
    public void setAllocations(@Nonnull List<Allocation> allocations) {
        this.allocations = allocations;
    }

    @Deprecated
    public void setSilent(boolean silent) {
        this.silent = silent;
    }

    public boolean getSilent() {
        return this.silent;
    }

    @Nonnull
    public TestType getTestType() {
        return this.testType;
    }

    @Deprecated
    public void setTestType(TestType testType) {
        this.testType = testType;
    }

    @Deprecated
    public void setDescription(String description) {
        this.description = description;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Nonnull
    public List<String> getMetaTags() {
        return this.metaTags;
    }

    @Deprecated
    public void setMetaTags(List<String> metaTags) {
        this.metaTags = metaTags;
    }

    @Nullable
    public TestDependency getDependsOn() {
        return this.dependsOn;
    }

    @Deprecated
    public void setDependsOn(@Nullable TestDependency dependsOn) {
        this.dependsOn = dependsOn;
    }

    public boolean getEvaluateForIncognitoUsers() {
        return this.evaluateForIncognitoUsers;
    }

    public boolean getEnableUnitlessAllocations() {
        return this.enableUnitlessAllocations;
    }

    public String toString() {
        return "TestDefinition{version='" + this.version + '\'' + ", constants=" + this.constants + ", specialConstants=" + this.specialConstants + ", salt='" + this.salt + '\'' + ", rule='" + this.rule + '\'' + ", buckets=" + this.buckets + ", allocations=" + this.allocations + ", silent=" + this.silent + ", testType=" + this.testType + ", description='" + this.description + '\'' + ", metaTags=" + this.metaTags + ", dependsOn=" + this.dependsOn + ", evaluteForIncognitoUsers=" + this.evaluateForIncognitoUsers + ", enableUnitlessAllocations=" + this.enableUnitlessAllocations + '}';
    }

    public int hashCode() {
        ArrayList<1> bucketWrappers = new ArrayList<1>();
        if (this.buckets != null) {
            for (final TestBucket bucket : this.buckets) {
                bucketWrappers.add(new Object(){

                    public int hashCode() {
                        return bucket.fullHashCode();
                    }
                });
            }
        }
        return Objects.hash(this.version, this.constants, this.specialConstants, this.salt, this.rule, bucketWrappers, this.allocations, this.silent, this.testType, this.description, this.metaTags, this.dependsOn, this.evaluateForIncognitoUsers, this.enableUnitlessAllocations);
    }

    public boolean equals(Object otherDefinition) {
        if (this == otherDefinition) {
            return true;
        }
        if (otherDefinition == null || this.getClass() != otherDefinition.getClass()) {
            return false;
        }
        TestDefinition that = (TestDefinition)otherDefinition;
        return this.silent == that.silent && Objects.equals(this.version, that.version) && Objects.equals(this.constants, that.constants) && Objects.equals(this.specialConstants, that.specialConstants) && Objects.equals(this.salt, that.salt) && Objects.equals(this.rule, that.rule) && TestDefinition.bucketListEqual(this.buckets, that.buckets) && Objects.equals(this.allocations, that.allocations) && Objects.equals(this.testType, that.testType) && Objects.equals(this.description, that.description) && Objects.equals(this.metaTags, that.metaTags) && Objects.equals(this.dependsOn, that.dependsOn) && Objects.equals(this.evaluateForIncognitoUsers, that.evaluateForIncognitoUsers) && Objects.equals(this.enableUnitlessAllocations, that.enableUnitlessAllocations);
    }

    @VisibleForTesting
    static boolean bucketListEqual(List<TestBucket> bucketsA, List<TestBucket> bucketsB) {
        if (bucketsA == bucketsB) {
            return true;
        }
        if (!Objects.equals(bucketsA, bucketsB)) {
            return false;
        }
        Iterator<TestBucket> itA = bucketsA.iterator();
        Iterator<TestBucket> itB = bucketsB.iterator();
        while (itA.hasNext() && itB.hasNext()) {
            TestBucket bucketA = itA.next();
            TestBucket bucketB = itB.next();
            if (bucketA == null || bucketA.fullEquals(bucketB)) continue;
            return false;
        }
        return true;
    }

    public static class Builder {
        private String version;
        private String rule;
        private TestType testType;
        private String salt;
        private ImmutableList.Builder<TestBucket> buckets = ImmutableList.builder();
        private ImmutableList.Builder<Allocation> allocations = ImmutableList.builder();
        private boolean silent;
        private ImmutableMap.Builder<String, Object> constants = ImmutableMap.builder();
        private ImmutableMap.Builder<String, Object> specialConstants = ImmutableMap.builder();
        private String description;
        private ImmutableList.Builder<String> metaTags = ImmutableList.builder();
        private TestDependency dependsOn;
        private boolean evaluateForIncognitoUsers;
        private boolean enableUnitlessAllocations;

        public Builder from(@Nonnull TestDefinition other) {
            this.setVersion(other.version);
            this.setRule(other.rule);
            this.setTestType(other.testType);
            this.setSalt(other.salt);
            this.setBuckets(other.buckets);
            this.setAllocations(other.allocations);
            this.setSilent(other.silent);
            this.setConstants(other.constants);
            this.setSpecialConstants(other.specialConstants);
            this.setDescription(other.description);
            this.setMetaTags(other.metaTags);
            this.setDependsOn(other.dependsOn);
            this.setEvaluateForIncognitoUsers(other.evaluateForIncognitoUsers);
            this.setEnableUnitlessAllocations(other.enableUnitlessAllocations);
            return this;
        }

        public Builder setVersion(@Nullable String version) {
            this.version = version;
            return this;
        }

        public Builder setRule(@Nullable String rule) {
            this.rule = rule;
            return this;
        }

        public Builder setTestType(@Nonnull TestType testType) {
            this.testType = Objects.requireNonNull(testType);
            return this;
        }

        public Builder setSalt(@Nonnull String salt) {
            this.salt = Objects.requireNonNull(salt);
            return this;
        }

        public Builder setBuckets(@Nonnull Iterable<TestBucket> buckets) {
            this.buckets = ImmutableList.builder();
            return this.addAllBuckets(buckets);
        }

        public Builder addBuckets(TestBucket ... buckets) {
            this.buckets.add((Object[])buckets);
            return this;
        }

        public Builder addAllBuckets(@Nonnull Iterable<TestBucket> buckets) {
            this.buckets.addAll(buckets);
            return this;
        }

        public Builder setAllocations(@Nonnull Iterable<Allocation> allocations) {
            this.allocations = ImmutableList.builder();
            return this.addAllAllocations(allocations);
        }

        public Builder addAllocations(Allocation ... allocations) {
            this.allocations.add((Object[])allocations);
            return this;
        }

        public Builder addAllAllocations(@Nonnull Iterable<Allocation> allocations) {
            this.allocations.addAll(allocations);
            return this;
        }

        public Builder setSilent(boolean silent) {
            this.silent = silent;
            return this;
        }

        public Builder setConstants(@Nonnull Map<String, Object> constants) {
            this.constants = ImmutableMap.builder();
            return this.putAllConstants(constants);
        }

        public Builder putAllConstants(@Nonnull Map<String, Object> constants) {
            this.constants.putAll(constants);
            return this;
        }

        public Builder setSpecialConstants(@Nonnull Map<String, Object> specialConstants) {
            this.specialConstants = ImmutableMap.builder();
            return this.putAllSpecialConstants(specialConstants);
        }

        public Builder putAllSpecialConstants(@Nonnull Map<String, Object> specialConstants) {
            this.specialConstants.putAll(specialConstants);
            return this;
        }

        public Builder setDescription(@Nullable String description) {
            this.description = description;
            return this;
        }

        public Builder setMetaTags(@Nonnull Iterable<String> metaTags) {
            this.metaTags = ImmutableList.builder();
            return this.addAllMetaTags(metaTags);
        }

        public Builder addAllMetaTags(@Nonnull Iterable<String> metaTags) {
            this.metaTags.addAll(metaTags);
            return this;
        }

        public Builder setDependsOn(@Nullable TestDependency dependsOn) {
            this.dependsOn = dependsOn;
            return this;
        }

        public Builder setEvaluateForIncognitoUsers(boolean evaluateForIncognitoUsers) {
            this.evaluateForIncognitoUsers = evaluateForIncognitoUsers;
            return this;
        }

        public Builder setEnableUnitlessAllocations(boolean enableUnitlessAllocations) {
            this.enableUnitlessAllocations = enableUnitlessAllocations;
            return this;
        }

        public TestDefinition build() {
            return new TestDefinition(this);
        }
    }
}

