/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.common.el;

import com.indeed.proctor.common.el.NodeHunter;
import com.indeed.shaded.javax.el7.ELContext;
import com.indeed.shaded.javax.el7.ELException;
import com.indeed.shaded.javax.el7.FunctionMapper;
import com.indeed.shaded.javax.el7.ValueExpression;
import com.indeed.shaded.javax.el7.VariableMapper;
import com.indeed.shaded.org.apache.el7.ValueExpressionImpl;
import com.indeed.shaded.org.apache.el7.lang.FunctionMapperFactory;
import com.indeed.shaded.org.apache.el7.lang.VariableMapperFactory;
import com.indeed.shaded.org.apache.el7.parser.AstDeferredExpression;
import com.indeed.shaded.org.apache.el7.parser.AstDynamicExpression;
import com.indeed.shaded.org.apache.el7.parser.AstFunction;
import com.indeed.shaded.org.apache.el7.parser.AstIdentifier;
import com.indeed.shaded.org.apache.el7.parser.AstLiteralExpression;
import com.indeed.shaded.org.apache.el7.parser.ELParser;
import com.indeed.shaded.org.apache.el7.parser.Node;
import com.indeed.shaded.org.apache.el7.parser.NodeVisitor;
import com.indeed.shaded.org.apache.el7.parser.ParseException;
import com.indeed.shaded.org.apache.el7.util.MessageFactory;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.util.Set;

public final class PartialExpressionBuilder
implements NodeVisitor {
    private FunctionMapper fnMapper;
    private VariableMapper varMapper;
    private ELContext ctx;
    private String expression;
    private final Set<String> variablesDefined;

    public PartialExpressionBuilder(String expression, ELContext ctx, Set<String> variablesDefined) throws ELException {
        this.expression = expression;
        FunctionMapper ctxFn = ctx.getFunctionMapper();
        VariableMapper ctxVar = ctx.getVariableMapper();
        this.ctx = ctx;
        if (ctxFn != null) {
            this.fnMapper = new FunctionMapperFactory(ctxFn);
        }
        if (ctxVar != null) {
            this.varMapper = new VariableMapperFactory(ctxVar);
        }
        this.variablesDefined = variablesDefined;
    }

    private static Node createNodeInternal(String expr) throws ELException {
        Node node;
        if (expr == null) {
            throw new ELException(MessageFactory.get("error.null"));
        }
        try {
            node = new ELParser(new StringReader(expr)).CompositeExpression();
            int numChildren = node.jjtGetNumChildren();
            if (numChildren == 1) {
                node = node.jjtGetChild(0);
            } else {
                Class<?> type = null;
                Node child = null;
                for (int i = 0; i < numChildren; ++i) {
                    child = node.jjtGetChild(i);
                    if (child instanceof AstLiteralExpression) continue;
                    if (type == null) {
                        type = child.getClass();
                        continue;
                    }
                    if (type.equals(child.getClass())) continue;
                    throw new ELException(MessageFactory.get("error.mixed", expr));
                }
            }
            if (node instanceof AstDeferredExpression || node instanceof AstDynamicExpression) {
                node = node.jjtGetChild(0);
            }
        }
        catch (ParseException pe) {
            throw new ELException("Error Parsing: " + expr, pe);
        }
        return node;
    }

    private void prepare(Node node) throws ELException {
        try {
            node.accept(this);
        }
        catch (Exception e) {
            if (e instanceof ELException) {
                throw (ELException)e;
            }
            throw new ELException(e);
        }
        if (this.fnMapper instanceof FunctionMapperFactory) {
            this.fnMapper = ((FunctionMapperFactory)this.fnMapper).create();
        }
        if (this.varMapper instanceof VariableMapperFactory) {
            this.varMapper = ((VariableMapperFactory)this.varMapper).create();
        }
    }

    private Node build() throws ELException {
        Node node = PartialExpressionBuilder.createNodeInternal(this.expression);
        try {
            node = NodeHunter.destroyUnknowns(node, this.variablesDefined);
        }
        catch (Exception e) {
            throw new ELException(e);
        }
        this.prepare(node);
        if (node instanceof AstDeferredExpression || node instanceof AstDynamicExpression) {
            node = node.jjtGetChild(0);
        }
        return node;
    }

    @Override
    public void visit(Node node) throws ELException {
        if (node instanceof AstFunction) {
            AstFunction funcNode = (AstFunction)node;
            if (this.fnMapper == null) {
                throw new ELException(MessageFactory.get("error.fnMapper.null"));
            }
            Method function = this.fnMapper.resolveFunction(funcNode.getPrefix(), funcNode.getLocalName());
            if (function == null) {
                throw new ELException(MessageFactory.get("error.fnMapper.method", funcNode.getOutputName()));
            }
            int pcnt = function.getParameterTypes().length;
            if (node.jjtGetNumChildren() != pcnt) {
                throw new ELException(MessageFactory.get("error.fnMapper.paramcount", funcNode.getOutputName(), "" + pcnt, "" + node.jjtGetNumChildren()));
            }
        } else if (node instanceof AstIdentifier && this.varMapper != null) {
            String variable = node.getImage();
            this.varMapper.resolveVariable(variable);
        }
    }

    public ValueExpression createValueExpression(Class<?> expectedType) throws ELException {
        Node node = this.build();
        return new ValueExpressionImpl(this.expression, node, this.fnMapper, this.varMapper, expectedType);
    }
}

