/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.common.el;

import com.google.common.collect.ImmutableList;
import com.indeed.proctor.common.ProctorRuleFunctions;
import com.indeed.shaded.org.apache.el7.parser.AstAnd;
import com.indeed.shaded.org.apache.el7.parser.AstFunction;
import com.indeed.shaded.org.apache.el7.parser.AstIdentifier;
import com.indeed.shaded.org.apache.el7.parser.AstLiteralExpression;
import com.indeed.shaded.org.apache.el7.parser.AstNot;
import com.indeed.shaded.org.apache.el7.parser.AstNotEqual;
import com.indeed.shaded.org.apache.el7.parser.AstOr;
import com.indeed.shaded.org.apache.el7.parser.ELParserTreeConstants;
import com.indeed.shaded.org.apache.el7.parser.Node;
import com.indeed.shaded.org.apache.el7.parser.NodeVisitor;
import com.indeed.shaded.org.apache.el7.parser.SimpleNode;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;

public class NodeHunter
implements NodeVisitor {
    private static final List<String> NODE_TYPES = ImmutableList.copyOf((Object[])ELParserTreeConstants.jjtNodeName).stream().map(nodeName -> "Ast" + nodeName).collect(Collectors.toList());
    private static final Map<String, Integer> NODE_TYPE_IDS = NODE_TYPES.stream().collect(Collectors.toMap(nodeType -> nodeType, NODE_TYPES::indexOf));
    private static final int AST_FUNCTION_TYPE = 27;
    private static final int AST_NOT_EQUAL_TYPE = 9;
    private final Set<Node> initialUnknowns = Collections.newSetFromMap(new IdentityHashMap());
    private final Map<Node, Node> replacements = new IdentityHashMap<Node, Node>();
    private final Set<String> variablesDefined;

    NodeHunter(Set<String> variablesDefined) {
        this.variablesDefined = variablesDefined;
    }

    public static Node destroyUnknowns(Node node, Set<String> variablesDefined) throws Exception {
        NodeHunter nodeHunter = new NodeHunter(variablesDefined);
        node.accept(nodeHunter);
        if (nodeHunter.initialUnknowns.isEmpty()) {
            return node;
        }
        nodeHunter.calculateReplacements();
        Node result = nodeHunter.replaceNodes(node);
        Node resultIsNotFalse = nodeHunter.wrapIsNotFalse(result);
        return resultIsNotFalse;
    }

    private void calculateReplacements() {
        Stack<Node> nodesToDestroy = new Stack<Node>();
        this.initialUnknowns.forEach(nodesToDestroy::push);
        while (!nodesToDestroy.isEmpty()) {
            Node nodeToDestroy = (Node)nodesToDestroy.pop();
            if (nodeToDestroy instanceof AstAnd) {
                this.replaceWithFunction(nodeToDestroy, "maybeAnd");
            } else if (nodeToDestroy instanceof AstOr) {
                this.replaceWithFunction(nodeToDestroy, "maybeOr");
            } else if (nodeToDestroy instanceof AstNot) {
                this.replaceWithFunction(nodeToDestroy, "maybeNot");
            } else if (!this.replacements.containsKey(nodeToDestroy)) {
                AstLiteralExpression replacement = new AstLiteralExpression(1);
                replacement.setImage(ProctorRuleFunctions.MaybeBool.UNKNOWN.name());
                this.replacements.put(nodeToDestroy, replacement);
            }
            if (nodeToDestroy.jjtGetParent() == null) continue;
            nodesToDestroy.push(nodeToDestroy.jjtGetParent());
        }
    }

    private AstFunction createFunctionReplacement(Node node, String function) {
        AstFunction replacement = new AstFunction(27);
        replacement.setPrefix("proctor");
        replacement.setLocalName(function);
        replacement.setImage("proctor:" + function);
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            Node child = node.jjtGetChild(i);
            if (this.replacements.containsKey(child)) {
                replacement.jjtAddChild(this.replacements.get(child), i);
                continue;
            }
            AstFunction replacementChild = new AstFunction(27);
            replacementChild.setPrefix("proctor");
            replacementChild.setLocalName("toMaybeBool");
            replacementChild.setImage("proctor:toMaybeBool");
            replacementChild.jjtAddChild(child, 0);
            replacement.jjtAddChild(replacementChild, i);
        }
        return replacement;
    }

    private void replaceWithFunction(Node node, String function) {
        AstFunction replacement = this.createFunctionReplacement(node, function);
        this.replacements.put(node, replacement);
    }

    private Node replaceNodes(Node node) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException, InstantiationException {
        if (this.replacements.containsKey(node)) {
            Node newNode = node;
            while (this.replacements.containsKey(newNode)) {
                newNode = this.replacements.get(newNode);
            }
            return newNode;
        }
        Class<?> nodeClass = node.getClass();
        Constructor<?> constructor = nodeClass.getConstructor(Integer.TYPE);
        SimpleNode newNode = (SimpleNode)constructor.newInstance(NODE_TYPE_IDS.get(nodeClass.getSimpleName()));
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            Node newChild = this.replaceNodes(node.jjtGetChild(i));
            newChild.jjtSetParent(newNode);
            newNode.jjtAddChild(newChild, i);
        }
        newNode.jjtSetParent(node.jjtGetParent());
        newNode.setImage(node.getImage());
        if (newNode instanceof AstFunction) {
            ((AstFunction)newNode).setPrefix(((AstFunction)node).getPrefix());
            ((AstFunction)newNode).setLocalName(((AstFunction)node).getLocalName());
        }
        return newNode;
    }

    @Override
    public void visit(Node node) throws Exception {
        String variable;
        if (node instanceof AstIdentifier && !this.variablesDefined.contains(variable = node.getImage())) {
            this.initialUnknowns.add(node);
        }
    }

    private Node wrapIsNotFalse(Node node) {
        AstNotEqual resultIsNotFalse = new AstNotEqual(9);
        AstLiteralExpression literalFalse = new AstLiteralExpression(1);
        literalFalse.setImage(ProctorRuleFunctions.MaybeBool.FALSE.name());
        literalFalse.jjtSetParent(resultIsNotFalse);
        resultIsNotFalse.jjtSetParent(node.jjtGetParent());
        node.jjtSetParent(resultIsNotFalse);
        resultIsNotFalse.jjtAddChild(node, 0);
        resultIsNotFalse.jjtAddChild(literalFalse, 1);
        return resultIsNotFalse;
    }
}

