/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.consumer.gen;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.indeed.proctor.common.PayloadType;
import com.indeed.proctor.common.ProctorSpecification;
import com.indeed.proctor.common.ProctorUtils;
import com.indeed.proctor.common.Serializers;
import com.indeed.proctor.common.TestSpecification;
import com.indeed.proctor.consumer.gen.CodeGenException;
import com.indeed.proctor.consumer.gen.FreeMarkerCodeGenerator;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.lang.StringEscapeUtils;

public abstract class TestGroupsGenerator
extends FreeMarkerCodeGenerator {
    private static final ObjectMapper OBJECT_MAPPER = Serializers.lenient();

    public static File makeTotalSpecification(File dir, String targetDir) throws CodeGenException {
        return TestGroupsGenerator.makeTotalSpecification(dir, targetDir, dir.getPath().substring(dir.getPath().lastIndexOf(File.separator) + 1) + "Groups.json");
    }

    public static File makeTotalSpecification(File dir, String targetDir, String name) throws CodeGenException {
        File[] dirFiles = dir.listFiles();
        return TestGroupsGenerator.makeTotalSpecification(Arrays.asList(dirFiles), targetDir, name);
    }

    public static File makeTotalSpecification(List<File> files, String targetDir, String name) throws CodeGenException {
        LinkedHashMap<String, TestSpecification> testSpec = new LinkedHashMap<String, TestSpecification>();
        Map providedContext = new LinkedHashMap();
        for (File file : files) {
            TestSpecification spec;
            String fileName = file.getName();
            if (fileName.equals("providedcontext.json")) {
                try {
                    providedContext = (Map)OBJECT_MAPPER.readValue(file, Map.class);
                    continue;
                }
                catch (IOException e) {
                    throw new CodeGenException("Could not read json correctly " + file.getAbsolutePath(), e);
                }
            }
            if (!fileName.endsWith(".json")) continue;
            try {
                spec = (TestSpecification)OBJECT_MAPPER.readValue(file, TestSpecification.class);
            }
            catch (IOException e) {
                throw new CodeGenException("Could not read json correctly " + file.getAbsolutePath(), e);
            }
            String specName = fileName.substring(0, fileName.indexOf(".json"));
            if (testSpec.containsKey(specName)) {
                throw new CodeGenException("Multiple " + fileName + " found, each test should only have 1 spec file");
            }
            testSpec.put(specName, spec);
        }
        ProctorSpecification proctorSpecification = new ProctorSpecification();
        proctorSpecification.setTests(testSpec);
        proctorSpecification.setProvidedContext(providedContext);
        File output = new File(targetDir, name);
        try {
            OBJECT_MAPPER.writerWithDefaultPrettyPrinter().writeValue(output, (Object)proctorSpecification);
        }
        catch (IOException e) {
            throw new CodeGenException("Could not write to temp file " + output.getAbsolutePath(), e);
        }
        return output;
    }

    @Override
    protected Map<String, Object> populateRootMap(String input, Map<String, Object> baseContext, String packageName, String className) {
        File inputFile = new File(input);
        ProctorSpecification spec = ProctorUtils.readSpecification((File)inputFile);
        return this.populateRootMap(spec, baseContext, packageName, className);
    }

    @VisibleForTesting
    Map<String, Object> populateRootMap(ProctorSpecification spec, Map<String, Object> baseContext, String packageName, String className) {
        HashMap rootMap = Maps.newHashMap(baseContext);
        Map tests = spec.getTests();
        ArrayList testDefs = Lists.newArrayListWithCapacity((int)tests.size());
        TreeSet sortedTestNames = new TreeSet(tests.keySet());
        for (String testName : sortedTestNames) {
            LinkedHashSet buckets = Sets.newLinkedHashSet();
            TestSpecification testSpecification = (TestSpecification)tests.get(testName);
            Object[] sortedBuckets = testSpecification.getBuckets().entrySet().toArray(new Map.Entry[testSpecification.getBuckets().size()]);
            Arrays.sort(sortedBuckets, new Comparator<Map.Entry<String, Integer>>(){

                @Override
                public int compare(Map.Entry<String, Integer> e0, Map.Entry<String, Integer> e1) {
                    if (e0.getValue() < e1.getValue()) {
                        return -1;
                    }
                    return e0.getValue() == e1.getValue() ? 0 : 1;
                }
            });
            boolean foundFallbackValue = false;
            for (Map.Entry entry : sortedBuckets) {
                String bucketName = (String)entry.getKey();
                String enumName = TestGroupsGenerator.toEnumName(bucketName);
                HashMap bucketDef = Maps.newHashMap();
                String normalizedBucketName = TestGroupsGenerator.toJavaIdentifier(bucketName);
                bucketDef.put("value", entry.getValue());
                bucketDef.put("name", bucketName);
                bucketDef.put("normalizedName", normalizedBucketName);
                bucketDef.put("enumName", enumName);
                bucketDef.put("javaClassName", TestGroupsGenerator.uppercaseFirstChar(normalizedBucketName));
                buckets.add(bucketDef);
                foundFallbackValue = foundFallbackValue || ((Integer)entry.getValue()).intValue() == testSpecification.getFallbackValue();
            }
            if (!buckets.isEmpty() && !foundFallbackValue) {
                throw new IllegalArgumentException("Specified fallback value " + testSpecification.getFallbackValue() + " for test " + testName + " is not in the list of standard values: " + Arrays.toString(sortedBuckets));
            }
            String name = TestGroupsGenerator.toJavaIdentifier(testName);
            String enumName = TestGroupsGenerator.toEnumName(name);
            HashMap testDef = Maps.newHashMap();
            testDef.put("name", testName);
            testDef.put("normalizedName", name);
            testDef.put("enumName", enumName);
            testDef.put("javaClassName", TestGroupsGenerator.uppercaseFirstChar(name));
            testDef.put("buckets", buckets);
            testDef.put("defaultValue", testSpecification.getFallbackValue());
            ArrayList<HashMap> arrayList = new ArrayList<HashMap>();
            if (testSpecification.getPayload() != null) {
                String specifiedPayloadTypeName = testSpecification.getPayload().getType();
                PayloadType specifiedPayloadType = PayloadType.payloadTypeForName((String)specifiedPayloadTypeName);
                if (specifiedPayloadType == PayloadType.MAP) {
                    testDef.put("isMap", "true");
                    for (Map.Entry entry : testSpecification.getPayload().getSchema().entrySet()) {
                        HashMap nestedPayloadsMap = Maps.newHashMap();
                        nestedPayloadsMap.put("key", entry.getKey());
                        PayloadType payloadTypeForValue = PayloadType.payloadTypeForName((String)((String)entry.getValue()));
                        if (payloadTypeForValue != PayloadType.MAP) {
                            nestedPayloadsMap.put("value", payloadTypeForValue.javaClassName);
                            nestedPayloadsMap.put("valueWithoutArray", payloadTypeForValue.javaClassName.substring(0, payloadTypeForValue.javaClassName.length() - 2));
                            if (PayloadType.STRING_ARRAY == payloadTypeForValue) {
                                nestedPayloadsMap.put("notANumber", "true");
                            }
                            nestedPayloadsMap.put("payloadTypeName", payloadTypeForValue.payloadTypeName);
                            arrayList.add(nestedPayloadsMap);
                            continue;
                        }
                        throw new IllegalArgumentException("Nested Map Payloads are not allowed");
                    }
                }
                this.addPayloadToTestDef(testDef, specifiedPayloadType);
            }
            if (testSpecification.getDescription() != null) {
                testDef.put("description", StringEscapeUtils.escapeJava((String)testSpecification.getDescription()));
            }
            testDef.put("nestedPayloadsList", arrayList);
            testDefs.add(testDef);
        }
        rootMap.put("contextArguments", spec.getProvidedContext());
        rootMap.put("mainClassName", className);
        rootMap.put("packageName", packageName);
        rootMap.put("testEnumName", "Test");
        rootMap.put("testDefs", testDefs);
        return rootMap;
    }

    abstract void addPayloadToTestDef(Map<String, Object> var1, PayloadType var2);
}

