/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.consumer.gen;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.indeed.proctor.common.PayloadType;
import com.indeed.proctor.common.ProctorSpecification;
import com.indeed.proctor.common.ProctorUtils;
import com.indeed.proctor.common.TestSpecification;
import com.indeed.proctor.consumer.gen.CodeGenException;
import com.indeed.proctor.consumer.gen.FreeMarkerCodeGenerator;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.TreeSet;

public class TestGroupsGenerator
extends FreeMarkerCodeGenerator {
    public void generate(String input, String target, String packageName, String groupsClass, String groupsManagerClass) throws CodeGenException {
        String templatePath = "/com/indeed/proctor/consumer/ant/";
        String groupsTemplateName = "groups.ftl";
        String groupsManagerTemplateName = "groups-manager.ftl";
        HashMap baseContext = Maps.newHashMap();
        baseContext.put("groupsClassName", groupsClass);
        baseContext.put("groupsManagerClassName", groupsManagerClass);
        if (groupsClass != null) {
            this.generate(input, target, baseContext, packageName, groupsClass, "/com/indeed/proctor/consumer/ant/", "groups.ftl");
        }
        if (groupsManagerClass != null) {
            this.generate(input, target, baseContext, packageName, groupsManagerClass, "/com/indeed/proctor/consumer/ant/", "groups-manager.ftl");
        }
    }

    @Override
    protected Map<String, Object> populateRootMap(String input, Map<String, Object> baseContext, String packageName, String className) {
        File inputFile = new File(input);
        ProctorSpecification spec = ProctorUtils.readSpecification((File)inputFile);
        HashMap rootMap = Maps.newHashMap(baseContext);
        Map tests = spec.getTests();
        ArrayList testDefs = Lists.newArrayListWithCapacity((int)tests.size());
        TreeSet sortedTestNames = new TreeSet(tests.keySet());
        for (String testName : sortedTestNames) {
            LinkedHashSet buckets = Sets.newLinkedHashSet();
            TestSpecification testSpecification = (TestSpecification)tests.get(testName);
            Object[] sortedBuckets = testSpecification.getBuckets().entrySet().toArray(new Map.Entry[testSpecification.getBuckets().size()]);
            Arrays.sort(sortedBuckets, new Comparator<Map.Entry<String, Integer>>(){

                @Override
                public int compare(Map.Entry<String, Integer> e0, Map.Entry<String, Integer> e1) {
                    if (e0.getValue() < e1.getValue()) {
                        return -1;
                    }
                    return e0.getValue() == e1.getValue() ? 0 : 1;
                }
            });
            boolean foundFallbackValue = false;
            for (Map.Entry entry : sortedBuckets) {
                String bucketName = (String)entry.getKey();
                String enumName = TestGroupsGenerator.toEnumName(bucketName);
                HashMap bucketDef = Maps.newHashMap();
                String normalizedBucketName = TestGroupsGenerator.toJavaIdentifier(bucketName);
                bucketDef.put("value", entry.getValue());
                bucketDef.put("name", bucketName);
                bucketDef.put("normalizedName", normalizedBucketName);
                bucketDef.put("enumName", enumName);
                bucketDef.put("javaClassName", TestGroupsGenerator.uppercaseFirstChar(normalizedBucketName));
                buckets.add(bucketDef);
                foundFallbackValue = foundFallbackValue || ((Integer)entry.getValue()).intValue() == testSpecification.getFallbackValue();
            }
            if (!foundFallbackValue) {
                throw new IllegalArgumentException("Specified fallback value " + testSpecification.getFallbackValue() + " for test " + testName + " is not in the list of standard values: " + Arrays.toString(sortedBuckets));
            }
            String name = TestGroupsGenerator.toJavaIdentifier(testName);
            String enumName = TestGroupsGenerator.toEnumName(name);
            HashMap testDef = Maps.newHashMap();
            testDef.put("name", testName);
            testDef.put("normalizedName", name);
            testDef.put("enumName", enumName);
            testDef.put("javaClassName", TestGroupsGenerator.uppercaseFirstChar(name));
            testDef.put("buckets", buckets);
            testDef.put("defaultValue", testSpecification.getFallbackValue());
            if (testSpecification.getPayload() != null) {
                String string = testSpecification.getPayload().getType();
                PayloadType specifiedPayloadType = PayloadType.payloadTypeForName((String)string);
                testDef.put("payloadJavaClass", specifiedPayloadType.javaClassName);
                testDef.put("payloadAccessorName", specifiedPayloadType.javaAccessorName);
            }
            testDefs.add(testDef);
        }
        rootMap.put("contextArguments", spec.getProvidedContext());
        rootMap.put("mainClassName", className);
        rootMap.put("packageName", packageName);
        rootMap.put("testEnumName", "Test");
        rootMap.put("testDefs", testDefs);
        return rootMap;
    }

    public static void main(String[] args) throws CodeGenException {
        if (args.length != 5) {
            System.err.println("java " + TestGroupsGenerator.class.getCanonicalName() + " input.json outputDirectory packageName groupsClassName");
            System.exit(-4);
        }
        TestGroupsGenerator generator = new TestGroupsGenerator();
        String input = args[0];
        String target = args[1];
        String packageName = args[2];
        String groupsClass = args[3];
        String groupsManagerClass = args[4];
        generator.generate(input, target, packageName, groupsClass, groupsManagerClass);
    }
}

