/*
 * Decompiled with CFR 0.152.
 */
package com.ig.orchestrations.fixp;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum FlowType {
    RECOVERABLE("Recoverable"),
    UNSEQUENCED("Unsequenced"),
    IDEMPOTENT("Idempotent"),
    NONE("None");

    private final String value;
    private static final Map<String, FlowType> CONSTANTS;

    private FlowType(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static FlowType fromValue(String value) {
        FlowType constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, FlowType>();
        for (FlowType c : FlowType.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

