/*
 * Decompiled with CFR 0.152.
 */
package com.ideabus.ideabuslibrary.bluetooth;

import android.app.Activity;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCallback;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattService;
import android.bluetooth.BluetoothManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.os.Message;
import com.ideabus.ideabuslibrary.bluetooth.BluetoothLEClass;
import com.ideabus.ideabuslibrary.bluetooth.BluetoothLEHandler;
import com.ideabus.ideabuslibrary.bluetooth.ClsUtils;
import com.ideabus.ideabuslibrary.bluetooth.ConnectionThread;
import com.ideabus.ideabuslibrary.util.BaseUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public abstract class BluetoothLEUtils
extends BluetoothLEClass {
    private static final String TAG = BluetoothLEUtils.class.getSimpleName();
    private Context context;
    private List<String> mScanList;
    public boolean isScanning = false;
    private BluetoothAdapter mBluetoothAdapter;
    private BluetoothAdapter.LeScanCallback mLeOldScanCallback;
    private BluetoothGattCallback mLeGattCallback;
    private ConnectionThread mConnectionThread;
    public BluetoothLEHandler mHandler;
    private static boolean isRegisterBtReceiver = false;
    private boolean isRestartingBT;
    private BroadcastReceiver mReceiver = new BroadcastReceiver(){
        String pin = "0000";

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            BluetoothDevice btDevice = null;
            btDevice = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
            if ("android.bluetooth.device.action.FOUND".equals(action)) {
                if (btDevice.getBondState() == 10) {
                    try {
                        ClsUtils.createBond(btDevice.getClass(), btDevice);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    try {
                        int state = intent.getIntExtra("android.bluetooth.adapter.extra.STATE", -1);
                        switch (state) {
                            case 11: {
                                break;
                            }
                            case 12: {
                                BaseUtils.printLog("d", TAG, "Bluetooth enable!");
                                BluetoothLEClass.mOnIMBluetoothLEListener.onBtStateChanged(true);
                                BluetoothLEUtils.this.unregisterBtReceiver();
                                break;
                            }
                            case 13: {
                                break;
                            }
                            case 10: {
                                BaseUtils.printLog("d", TAG, "Bluetooth disable!");
                                BluetoothLEClass.mOnIMBluetoothLEListener.onBtStateChanged(false);
                                BluetoothLEUtils.this.unregisterBtReceiver();
                            }
                        }
                    }
                    catch (Exception state) {}
                }
            } else if (action.equals("android.bluetooth.device.action.PAIRING_REQUEST")) {
                try {
                    ClsUtils.setPairingConfirmation(btDevice.getClass(), btDevice, true);
                    this.abortBroadcast();
                    boolean state = ClsUtils.setPin(btDevice.getClass(), btDevice, this.pin);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    };

    public abstract void onWriteThreadStart(BluetoothLEHandler var1);

    public abstract String onRead(BluetoothGattCharacteristic var1);

    public abstract String onChanged(BluetoothGattCharacteristic var1);

    public abstract void searchGattServices(int var1, List<BluetoothGattService> var2);

    public abstract boolean writeToBLE(String var1, boolean var2);

    public BluetoothLEUtils(Context c, boolean isPrintLog) {
        this.context = c;
        BaseUtils.setIsPrintLog(isPrintLog);
        if (c.getPackageManager().hasSystemFeature("android.hardware.bluetooth_le")) {
            BluetoothManager bluetoothManager = (BluetoothManager)this.context.getSystemService("bluetooth");
            if (bluetoothManager != null) {
                BluetoothLEUtils bluetoothLEUtils = this;
                this.mBluetoothAdapter = bluetoothLEUtils.mBluetoothAdapter.getDefaultAdapter();
            }
            this.initCommArray();
        }
        this.mScanList = new ArrayList<String>();
        this.mHandler = new BluetoothLEHandler(this, this.mBluetoothAdapter);
    }

    public Context getContext() {
        return this.context;
    }

    public boolean isBTEnabled() {
        return this.mBluetoothAdapter != null && this.mBluetoothAdapter.isEnabled();
    }

    private void restartBT() {
        if (this.mBluetoothAdapter != null) {
            this.stopLEScan();
            if (this.isBTEnabled()) {
                this.mBluetoothAdapter.disable();
            } else {
                this.mBluetoothAdapter.enable();
            }
        }
    }

    public boolean isScanning() {
        return this.isScanning;
    }

    public boolean isConnected() {
        return this.mCurrentStatus == 17;
    }

    public boolean isSupportBluetooth(Activity activity) {
        if (!this.context.getPackageManager().hasSystemFeature("android.hardware.bluetooth_le")) {
            return false;
        }
        if (!this.mBluetoothAdapter.isEnabled()) {
            this.registerBtReceiver();
            Intent enableBtIntent = new Intent("android.bluetooth.adapter.action.REQUEST_ENABLE");
            activity.startActivityForResult(enableBtIntent, 100);
        }
        return true;
    }

    public void registerBtReceiver() {
        if (isRegisterBtReceiver) {
            this.unregisterBtReceiver();
        }
        try {
            this.context.registerReceiver(this.mReceiver, new IntentFilter("android.bluetooth.adapter.action.STATE_CHANGED"));
            isRegisterBtReceiver = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void unregisterBtReceiver() {
        try {
            this.context.unregisterReceiver(this.mReceiver);
            isRegisterBtReceiver = false;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void startLEScan(int timeout, boolean isLoop) {
        BaseUtils.printLog("d", TAG, "startLEScan");
        if (this.mBluetoothAdapter == null || !this.mBluetoothAdapter.isEnabled()) {
            BaseUtils.printLog("d", TAG, "\u672a\u958b\u555f\u85cd\u7259\u6216\u4e0d\u652f\u63f4BLE");
            return;
        }
        if (this.isScanning) {
            BaseUtils.printLog("d", TAG, "\u5df2\u5728\u6383\u63cf\u4e2d,\u505c\u6b62\u6383\u63cf");
            this.stopLEScan();
        }
        try {
            this.mScanList.clear();
            if (isLoop) {
                this.mHandler.removeMessages(6);
                Message msg = new Message();
                msg.what = 6;
                msg.arg1 = timeout;
                this.mHandler.sendMessageDelayed(msg, timeout * 1000);
            } else {
                this.mHandler.removeMessages(4);
                this.mHandler.sendEmptyMessageDelayed(4, timeout * 1000);
            }
            if (this.mBluetoothAdapter != null) {
                this.isScanning = true;
                this.mBluetoothAdapter.startLeScan(this.setLeScanCallback());
            }
        }
        catch (NoClassDefFoundError e) {
            e.printStackTrace();
        }
    }

    public void stopLEScan() {
        BaseUtils.printLog("d", TAG, "stopLEScan");
        this.mHandler.removeMessages(4);
        this.isScanning = false;
        if (this.mBluetoothAdapter != null) {
            this.mBluetoothAdapter.stopLeScan(this.setLeScanCallback());
        }
    }

    public BluetoothAdapter.LeScanCallback setLeScanCallback() {
        if (this.mLeOldScanCallback == null) {
            this.mLeOldScanCallback = new BluetoothAdapter.LeScanCallback(){

                public void onLeScan(BluetoothDevice device, int rssi, byte[] scanRecord) {
                    if (!BluetoothLEUtils.this.isScanning) {
                        BluetoothLEUtils.this.stopLEScan();
                    } else if (device != null && device.getAddress() != null && device.getAddress().length() > 0) {
                        BluetoothLEUtils.this.checkIsExist(device, rssi, scanRecord);
                    }
                }
            };
        }
        return this.mLeOldScanCallback;
    }

    private synchronized void checkIsExist(BluetoothDevice device, int rssi, byte[] scanRecord) {
        for (String mac : this.mScanList) {
            if (!device.getAddress().equals(mac)) continue;
            return;
        }
        this.mScanList.add(device.getAddress());
        Message msg = new Message();
        msg.what = 3;
        String name = device.getName() != null && device.getName().length() > 0 ? device.getName() : "n/a";
        Bundle bd = new Bundle();
        bd.putString("name", name);
        bd.putString("address", device.getAddress());
        bd.putInt("rssi", rssi);
        bd.putByteArray("scanRecord", scanRecord);
        msg.setData(bd);
        this.mHandler.sendMessage(msg);
    }

    public void connect(List<String> address) {
        BaseUtils.printLog("d", TAG, "connect->" + address);
        this.mHandler.removeMessages(4);
        if (this.isScanning()) {
            this.stopLEScan();
        }
        if (this.mBluetoothAdapter == null || address == null || address.size() == 0) {
            BaseUtils.printLog("d", TAG, "mBluetoothAdapter == null \u6216 \u7121\u6548\u5730\u5740");
            this.mCurrentStatus = 19;
            this.mHandler.sendEmptyMessage(1);
            return;
        }
        this.mCurrentStatus = 16;
        this.initBluetoothGattsArray();
        this.initParams();
        this.charWriteList = new ArrayList();
        this.connGattCount = address.size();
        this.connectBLEs(address);
    }

    private void connectBLEs(List<String> address) {
        this.mConnectionThread = new ConnectionThread(this, this.mBluetoothAdapter, this.mHandler, address);
        this.mConnectionThread.start();
    }

    public boolean writeMessage(String str, boolean clearAllComm) {
        return this.writeToBLE(str, clearAllComm);
    }

    public void readRSSI() {
        if (this.getBluetoothGatt(0) != null) {
            boolean isWriteOk = this.getBluetoothGatt(0).readRemoteRssi();
            BaseUtils.printLog("d", TAG, "\u6210\u529f\u8b80\u53d6RSSI = " + isWriteOk);
        }
    }

    protected void sendTest(String commStr) {
        if (this.getBluetoothGatt(0) != null) {
            boolean isWriteOk = this.getBluetoothGatt(0).writeCharacteristic((BluetoothGattCharacteristic)this.charWriteList.get(0));
            ((BluetoothGattCharacteristic)this.charWriteList.get(0)).setValue(BaseUtils.convertHexToByteArray(commStr));
            BaseUtils.printLog("d", TAG, "\u6210\u529f\u5beb\u51fa = " + isWriteOk);
        }
    }

    public BluetoothGattCallback setLeGattCallback() {
        if (this.mLeGattCallback == null) {
            this.mLeGattCallback = new BluetoothGattCallback(){

                public void onConnectionStateChange(BluetoothGatt gatt, int status, int newState) {
                    if (newState == 2) {
                        BaseUtils.printLog("d", TAG, "\u6210\u529f\u9023\u7dda\u5230 BLE GATT \u8a2d\u5099.");
                        try {
                            Thread.sleep(2000L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        for (int i = 0; i < BluetoothLEUtils.this.connGattCount; ++i) {
                            if (!gatt.equals(BluetoothLEUtils.this.getBluetoothGatt(i))) continue;
                            BaseUtils.printLog("d", TAG, "\u6b63\u5728\u641c\u5c0b \u7b2c" + i + " \u9846\u85cd\u7259 Service   NAME = " + BluetoothLEUtils.this.getBluetoothGatt(i).getDevice().getName());
                            BluetoothLEUtils.this.getBluetoothGatt(i).discoverServices();
                            break;
                        }
                    } else if (newState == 0) {
                        BaseUtils.printLog("e", TAG, "Device \u65b7\u7dda from GATT server. status = " + status);
                        BluetoothLEUtils.this.disconnect(18);
                    }
                }

                public void onServicesDiscovered(BluetoothGatt gatt, int status) {
                    if (status == 0) {
                        BaseUtils.printLog("d", TAG, "onServicesDiscovered  \u641c\u5c0b\u85cd\u7259 Service\u6210\u529f status = " + status);
                        for (int i = 0; i < BluetoothLEUtils.this.connGattCount; ++i) {
                            if (!gatt.equals(BluetoothLEUtils.this.getBluetoothGatt(i))) continue;
                            BaseUtils.printLog("d", TAG, "\u641c\u5c0b\u5230 \u7b2c" + i + " \u9846\u85cd\u7259 Service   NAME = " + BluetoothLEUtils.this.getBluetoothGatt(i).getDevice().getName());
                            BluetoothLEUtils.this.displayGattServices(i, BluetoothLEUtils.this.getSupportedGattServices(i));
                            break;
                        }
                    } else {
                        BaseUtils.printLog("e", TAG, "\u65b7\u7dda  onServicesDiscovered received: " + status);
                        BluetoothLEUtils.this.disconnect(18);
                    }
                }

                public void onCharacteristicWrite(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
                    BaseUtils.printLog("d", TAG, "\u6210\u529f\u767c\u9001\u81f3\u8a2d\u5099    getDevice.getName = " + gatt.getDevice().getName() + " , status = " + status);
                }

                public void onCharacteristicRead(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
                    BaseUtils.printLog("d", TAG, "\u6210\u529f\u8b80\u53d6\u8a2d\u5099\u8a0a\u606f   getDevice.getName = " + gatt.getDevice().getName() + " , status = " + status);
                    Message msg = new Message();
                    msg.what = 2;
                    msg.obj = BluetoothLEUtils.this.onRead(characteristic);
                    BluetoothLEUtils.this.mHandler.sendMessage(msg);
                }

                public void onCharacteristicChanged(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic) {
                    String deviceName = gatt.getDevice().getName().trim();
                    BaseUtils.printLog("d", TAG, "\u63a5\u6536\u8cc7\u6599 deviceName = " + deviceName);
                    Message msg = new Message();
                    msg.what = 2;
                    msg.obj = deviceName + "==" + BluetoothLEUtils.this.onChanged(characteristic);
                    BluetoothLEUtils.this.mHandler.sendMessage(msg);
                }
            };
        }
        return this.mLeGattCallback;
    }

    private List<BluetoothGattService> getSupportedGattServices(int item) {
        if (this.getBluetoothGatt(item) != null) {
            return this.getBluetoothGatt(item).getServices();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void displayGattServices(int item, List<BluetoothGattService> gattServices) {
        this.searchGattServices(item, gattServices);
        if (this.charWriteList.size() == this.connGattCount && this.charNotifyCount == this.connGattCount) {
            if (item != 0 && item == this.connGattCount - 1) {
                this.connectSuccess();
            } else if (item == 0 && item + 1 == this.connGattCount) {
                this.connectSuccess();
            }
        }
        if (this.mConnectionThread == null) {
            return;
        }
        ConnectionThread connectionThread = this.mConnectionThread;
        synchronized (connectionThread) {
            this.mConnectionThread.notify();
        }
    }

    private void connectSuccess() {
        BaseUtils.printLog("d", TAG, "connectSuccess CONNECTED------");
        this.mCurrentStatus = 17;
        this.mHandler.sendEmptyMessage(1);
        if (this.mConnectionThread != null && !this.mConnectionThread.isInterrupted()) {
            this.mConnectionThread.interrupt();
            this.mConnectionThread = null;
        }
        this.charNotifyCount = 0;
    }

    private void initParams() {
        if (this.mConnectionThread != null && !this.mConnectionThread.isInterrupted()) {
            this.mConnectionThread.interrupt();
            this.mConnectionThread = null;
        }
        this.mHandler.removeMessages(4);
        this.mHandler.removeMessages(20);
        this.charNotifyCount = 0;
        this.isWriteRunning = false;
        this.removeAllComm();
    }

    public synchronized void disconnect(int status) {
        BaseUtils.printLog("d", TAG, "disconnect code : " + status);
        this.stopLEScan();
        this.initParams();
        this.mCurrentStatus = status;
        this.unregisterBtReceiver();
        if (this.getBluetoothGatts() != null && this.getBluetoothGatts().size() > 0) {
            for (int i = 0; i < this.getBluetoothGatts().size(); ++i) {
                try {
                    if (this.getBluetoothGatt(i) != null) {
                        this.getBluetoothGatt(i).disconnect();
                        this.getBluetoothGatt(i).close();
                        BaseUtils.printLog("e", TAG, "disconnect : " + i);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return;
                }
                this.mHandler.sendEmptyMessage(1);
            }
        }
        this.initBluetoothGattsArray();
    }

    public boolean refreshDeviceCache(BluetoothGatt gatt) {
        try {
            BluetoothGatt localBluetoothGatt = gatt;
            Method localMethod = localBluetoothGatt.getClass().getMethod("refresh", new Class[0]);
            if (localMethod != null) {
                boolean bool = (Boolean)localMethod.invoke((Object)localBluetoothGatt, new Object[0]);
                return bool;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }
}

