package com.ideabus.ideabuslibrary.bluetooth;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.os.Message;
import android.util.Log;

import java.util.List;

public class ConnectionThread extends Thread {

	private static final String TAG = ConnectionThread.class.getSimpleName();
	private BluetoothLEUtils myBluetooth;
	private BluetoothAdapter mBluetoothAdapter;
	private BluetoothLEHandler mHandler;
	private List<String> address;
	
	public ConnectionThread(BluetoothLEUtils bt, BluetoothAdapter adapter, BluetoothLEHandler handler, List<String> addr){
		myBluetooth = bt;
		mBluetoothAdapter = adapter;
		mHandler = handler;
		address = addr;
	}
	
	@Override
	public void run(){
		BluetoothDevice device;
		mHandler.removeMessages(BluetoothLEClass.CONNECT_TIMEOUT);
		mHandler.sendEmptyMessageDelayed(BluetoothLEClass.CONNECT_TIMEOUT, BluetoothLEClass.CONNECT_PERIOD);
		
		synchronized(this){
			for(int i = 0 ; i < myBluetooth.connGattCount ; i++){
				try{
//					初始設備發現後，保存設備的MAC地址。見BluetoothDevice.getAddress（）。
//					然後，下一次用戶要連接，使用該地址來構造BluetoothDevice類對象。見BluetoothAdapter.getRemoteDevice（）。
//					這將繞過設備發現它可以創造一個流暢的用戶體驗。
                	device = mBluetoothAdapter.getRemoteDevice(address.get(i));
                }catch(IllegalArgumentException e){
                	Log.e(TAG, "連接 第 " + i + " 顆藍牙出現錯誤  " + e.toString());
                	myBluetooth.disconnect(BluetoothLEClass.DISCONNECTED);
                	return;
                }
                
                if (device == null) {
                	Log.e(TAG, "第 " + i + " 顆藍牙未找到");
                	myBluetooth.disconnect(BluetoothLEClass.DISCONNECTED);
                	return;
                }else {
                	Message msg = new Message();
                	msg.what = BluetoothLEClass.CONNECTING;
                	msg.arg1 = i;
                	msg.obj = device;
                	mHandler.sendMessage(msg);
				}
                //如果是最後一組不用wait
                if(i < myBluetooth.connGattCount - 1){
                	try {
        				this.wait();
        				//快速連續連多個,前一個可能會斷線
        				Thread.sleep(2000);
					} catch (InterruptedException e) {
						e.printStackTrace();
						myBluetooth.disconnect(BluetoothLEClass.DISCONNECTED);
						return;
					}
                }
			}
		}
	}
	
	
}
