package com.ideabus.ideabuslibrary.bluetooth;

import android.app.Activity;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCallback;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattService;
import android.bluetooth.BluetoothManager;
import android.bluetooth.BluetoothProfile;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.Message;


import com.ideabus.ideabuslibrary.util.BaseUtils;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public abstract class BluetoothLEUtils extends BluetoothLEClass{
	
	private static final String TAG = BluetoothLEUtils.class.getSimpleName();
	
	private Context context;
	private List<String> mScanList;
	/**
	 * 是否掃描中
	 */
	public boolean isScanning = false;
	/**
	 * 藍芽操作adapter
	 */
	private BluetoothAdapter mBluetoothAdapter;
	
	/**
	 * old api
	 * scan callback
	 */
	private BluetoothAdapter.LeScanCallback mLeOldScanCallback;
	
	/**
	 * callback
	 */
	private BluetoothGattCallback mLeGattCallback;
	
	/**
	 * 連線Thread
	 */
	private ConnectionThread mConnectionThread;
	
	public BluetoothLEHandler mHandler;
	
	private static boolean isRegisterBtReceiver = false;
	
//	private boolean isManuallyDisconnect;
	private boolean isRestartingBT;
	
	public abstract void onWriteThreadStart(BluetoothLEHandler mHandler);
	public abstract String onRead(BluetoothGattCharacteristic characteristic);
    public abstract String onChanged(BluetoothGattCharacteristic characteristic);
    public abstract void searchGattServices(int item, List<BluetoothGattService> gattServices);
    public abstract boolean writeToBLE(String str, boolean clearAllComm);

	public BluetoothLEUtils(Context c, boolean isPrintLog){
		context = c;

		BaseUtils.setIsPrintLog(isPrintLog);

		// 使用此檢查，以確定是否BLE支持的設備上。然後你可以有選擇地禁用BLE相關的功能。
		if (c.getPackageManager().hasSystemFeature(PackageManager.FEATURE_BLUETOOTH_LE)) {
			final BluetoothManager bluetoothManager =
			        (BluetoothManager) context.getSystemService(Context.BLUETOOTH_SERVICE);
			if(bluetoothManager != null){
				mBluetoothAdapter = bluetoothManager.getAdapter();
				
			}
			initCommArray();
		}
		mScanList = new ArrayList<String>();
		mHandler = new BluetoothLEHandler(this, mBluetoothAdapter);
	}
	
	public Context getContext(){
		return context;
	}
	
	/**
	 * 藍芽是否開啟
	 *
	 */
	public boolean isBTEnabled(){
		return mBluetoothAdapter != null &&  mBluetoothAdapter.isEnabled();
	}
	
	private void restartBT(){
		if(mBluetoothAdapter != null){
			stopLEScan();
//			registerBtReceiver();
			if(isBTEnabled())
				mBluetoothAdapter.disable();
			else
				mBluetoothAdapter.enable();
		}
	}
	

	//藍芽是否再掃描中
	public boolean isScanning(){
		return isScanning;
	}
	
	public boolean isConnected(){
		return mCurrentStatus == CONNECTED;
	}
	

	// 在每次onStart時判斷是否支援BLE，如果是，判斷BLE是否開啟，如果未開啟，自動開啟BLE
	public boolean isSupportBluetooth(Activity activity){
		// 是否有支援藍牙裝置
		if (!context.getPackageManager().hasSystemFeature(PackageManager.FEATURE_BLUETOOTH_LE)) {
			return false;
		} else {
			// 查看藍牙是否開啟，若無則提醒使用者
			if (!mBluetoothAdapter.isEnabled()) {
				registerBtReceiver();
				Intent enableBtIntent = new Intent(BluetoothAdapter.ACTION_REQUEST_ENABLE);
				activity.startActivityForResult(enableBtIntent, ACTION_REQUEST_ENABLE);
			}
			return true;
		}
	}
	
	public void registerBtReceiver(){
		if(isRegisterBtReceiver)
			unregisterBtReceiver();
		
		try {
			context.registerReceiver(mReceiver, 
					new IntentFilter(BluetoothAdapter.ACTION_STATE_CHANGED));
			isRegisterBtReceiver = true;
		} catch (Exception e) { }
	}
	
	public void unregisterBtReceiver(){
		try {
    		context.unregisterReceiver(mReceiver);
    		isRegisterBtReceiver = false;
		} catch (Exception e) { }
	}
	
	//開啓掃描BLE
	public void startLEScan(int timeout, boolean isLoop) {

		BaseUtils.printLog("d", TAG, "startLEScan");

		if (mBluetoothAdapter == null || !mBluetoothAdapter.isEnabled()) {
			BaseUtils.printLog("d", TAG, "未開啟藍牙或不支援BLE");
			return;
		}

		if (isScanning) {
			BaseUtils.printLog("d", TAG, "已在掃描中,停止掃描");
			stopLEScan();
		}

		try {
			mScanList.clear();
			//自動循環掃描
			if (isLoop) {
				mHandler.removeMessages(SCAN_LOOP);
				Message msg = new Message();
				msg.what = SCAN_LOOP;
				msg.arg1 = timeout;
				mHandler.sendMessageDelayed(msg, timeout * 1000);
			} else {
				//掃描Timeout秒，停止掃描
				mHandler.removeMessages(SCAN_FINISH);
				mHandler.sendEmptyMessageDelayed(SCAN_FINISH, timeout * 1000);
			}

			// 開始搜索藍牙設備,搜索到的藍牙設備通過廣播返回
			if (mBluetoothAdapter != null) {
				//是否掃描中
				isScanning = true;
				mBluetoothAdapter.startLeScan(setLeScanCallback());
			}
		} catch (NoClassDefFoundError e) {
			e.printStackTrace();
		}
	}

	
	
	/**
	 * 取消掃描BLE
	 */
	public void stopLEScan() {

		BaseUtils.printLog("d", TAG, "stopLEScan");
		
		mHandler.removeMessages(SCAN_FINISH);
		isScanning = false;
		
    	if (mBluetoothAdapter != null)
    		mBluetoothAdapter.stopLeScan(setLeScanCallback());
    	
//		mHandler.sendEmptyMessage(SCAN_STOP);
	}
	
	private BroadcastReceiver mReceiver = new BroadcastReceiver() {
		public void onReceive(Context context, Intent intent) {
			String action = intent.getAction();
			
			if (BluetoothAdapter.ACTION_STATE_CHANGED.equals(action)) {
				try{
					int state = intent.getIntExtra(BluetoothAdapter.EXTRA_STATE, -1);

					switch(state){
					case BluetoothAdapter.STATE_TURNING_ON:
						break;
					case BluetoothAdapter.STATE_ON:

						BaseUtils.printLog("d", TAG, "Bluetooth enable!");

//						startLEScan();
						mOnIMBluetoothLEListener.onBtStateChanged(true);

						unregisterBtReceiver();
						break;
					case BluetoothAdapter.STATE_TURNING_OFF:
						break;
					case BluetoothAdapter.STATE_OFF:

						BaseUtils.printLog("d", TAG, "Bluetooth disable!");

//						mBluetoothAdapter.enable();
						mOnIMBluetoothLEListener.onBtStateChanged(false);

						unregisterBtReceiver();
						break;
					}
				}catch(Exception e){}
			}
		}
	};
    
	public BluetoothAdapter.LeScanCallback setLeScanCallback(){
		if(mLeOldScanCallback == null){
			mLeOldScanCallback = new BluetoothAdapter.LeScanCallback() {
			    @Override
			    public void onLeScan(BluetoothDevice device, int rssi, byte[] scanRecord) {
			    	if(!isScanning){
			    		stopLEScan();
			    	}else {
			    		//返回掃描結果
				    	if(device != null && 
								/*device.getName() != null && device.getName().length() > 0 &&*/
								device.getAddress() != null && device.getAddress().length() > 0){
				    		
				    		checkIsExist(device, rssi, scanRecord);
				    	}
					}
			    }
			};
		}
		return mLeOldScanCallback;
	}
	
	private synchronized void checkIsExist(BluetoothDevice device, int rssi, byte[] scanRecord){
		for(String mac : mScanList){
			if(device.getAddress().equals(mac)){
				return;
			}
		}
		mScanList.add(device.getAddress());
		
		
		Message msg = new Message();
		msg.what = SCAN_RESULT;
		
		String name = device.getName() != null && device.getName().length() > 0 ? device.getName() : "n/a";
		Bundle bd = new Bundle();
		bd.putString("name", name);
		bd.putString("address", device.getAddress());
		bd.putInt("rssi", rssi);
		bd.putByteArray("scanRecord", scanRecord);
		
		msg.setData(bd);
		mHandler.sendMessage(msg);
	}
	
	/**
     * 連接到 BLE device
     * @param address 要連線的BLE address List<br>
     *                如果成功啟動連接。連接結果通過異步方式BluetoothGattCallback.onConnectionStateChange
     */
    public void connect(List<String> address) {

		BaseUtils.printLog("d", TAG, "connect->" + address);

    	
		mHandler.removeMessages(SCAN_FINISH);
    	if(isScanning()){
        	stopLEScan();
    	}
    	
        if (mBluetoothAdapter == null || address == null || address.size() == 0) {

			BaseUtils.printLog("d", TAG, "mBluetoothAdapter == null 或 無效地址");
            mCurrentStatus = UNSPECIFIED_ADDRESS;
            mHandler.sendEmptyMessage(CALLBACK_STATE);
            return;
        }
//        isManuallyDisconnect = false;
        mCurrentStatus = NONE;
        initBluetoothGattsArray();
        initParams();
        
        charWriteList = new ArrayList<BluetoothGattCharacteristic>();
        connGattCount = address.size();
        
        connectBLEs(address);
    }
    
    /**
     * 連線
     */
    private void connectBLEs(List<String> address){
    	mConnectionThread = new ConnectionThread(this, mBluetoothAdapter, mHandler, address);
    	mConnectionThread.start();
    }
    

	//發送訊息至BLE
    public boolean writeMessage(String str, boolean clearAllComm){
    	return writeToBLE(str, clearAllComm);
    }
    
    public void readRSSI(){
		if(getBluetoothGatt(0) != null){
    		boolean isWriteOk = getBluetoothGatt(0).readRemoteRssi();
			BaseUtils.printLog("d", TAG, "成功讀取RSSI = " + isWriteOk);
		}
	}
    
    protected void sendTest(String commStr){
		if(getBluetoothGatt(0) != null){

    		boolean isWriteOk = getBluetoothGatt(0).writeCharacteristic(charWriteList.get(0));


			charWriteList.get(0).setValue(BaseUtils.convertHexToByteArray(commStr));
			BaseUtils.printLog("d", TAG, "成功寫出 = " + isWriteOk);
		}
	}
    

	 // 連線後的變化和Service的發現。

    public BluetoothGattCallback setLeGattCallback(){
		if(mLeGattCallback == null){
			mLeGattCallback = new BluetoothGattCallback() {
		        @Override
		        public void onConnectionStateChange(BluetoothGatt gatt, int status, int newState) {
		        	
		            if (newState == BluetoothProfile.STATE_CONNECTED) {

						BaseUtils.printLog("d", TAG, "成功連線到 BLE GATT 設備.");

		            	
		            	try {
							Thread.sleep(600);
						} catch (InterruptedException e) {
							e.printStackTrace();
						}
		            	//這是一個異步操作。一旦discover services完成時，BluetoothGattCallback.onServicesDiscovered回調被觸發。
		                //如果成功的，該遠程服務可以使用getServices函數進行檢索。
		            	for(int i = 0 ; i < connGattCount ; i++){
		            		if(gatt.equals(getBluetoothGatt(i))){

								BaseUtils.printLog("d", TAG, "正在搜尋 第" + i + " 顆藍牙 Service   NAME = " +
										getBluetoothGatt(i).getDevice().getName());
		                		getBluetoothGatt(i).discoverServices();
//		            			displayGattServices(i, null);
		                		break;
		            		}
		            	}
		            } else if (newState == BluetoothProfile.STATE_DISCONNECTED) {
		       
//		            	if(status != 0){
//		            		mCurrentStatus = ERROR133_RESTART_BT;
//		            		mHandler.sendEmptyMessage(BluetoothLEClass.CALLBACK_STATE);
//		            	}
		            	
//		            	if(!isManuallyDisconnect){

						BaseUtils.printLog("e", TAG, "Device 斷線 from GATT server. status = " + status);
//			            	mCurrentStatus = ERROR133_RESTART_BT;
//		            		mHandler.sendEmptyMessage(BluetoothLEClass.CALLBACK_STATE);
		            		disconnect(DISCONNECTED);
//		            	}else{
//			            	Log.e(TAG, "App 斷線 status = " + status);
//		            	}
//		            	isManuallyDisconnect = false;
//		            	if((status == 62 || status == 133) && currentAddress != null && reconnectCount < 3){
//		            		connect(currentAddress);
//		            		reconnectCount++;
//		            	}
		            }
		        }

		        @Override
		        public void onServicesDiscovered(BluetoothGatt gatt, int status) {
		            if (status == BluetoothGatt.GATT_SUCCESS) {
						BaseUtils.printLog("d", TAG, "onServicesDiscovered  搜尋藍牙 Service成功 status = " + status);
		            	
		            	for(int i = 0 ; i < connGattCount ; i++){
		            		if(gatt.equals(getBluetoothGatt(i))){


								BaseUtils.printLog("d", TAG, "搜尋到 第" + i + " 顆藍牙 Service   NAME = " +
										getBluetoothGatt(i).getDevice().getName());
		                		displayGattServices(i, getSupportedGattServices(i));
		                		
		                		break;
		            		}
		            	}
		            	
		            } else {

						BaseUtils.printLog("e", TAG, "斷線  onServicesDiscovered received: " + status);
//		            	if(status != 0){
//		            		mCurrentStatus = ERROR133_RESTART_BT;
//		            		mHandler.sendEmptyMessage(BluetoothLEClass.CALLBACK_STATE);
//		            	}
		            	disconnect(DISCONNECTED);
		            }
		        }
		        
		        @Override
		        public void onCharacteristicWrite(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {

					BaseUtils.printLog("d", TAG, "成功發送至設備    getDevice.getName = " + gatt.getDevice().getName() +
							" , status = " + status);

		        }
		        
		        @Override
		        public void onCharacteristicRead(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {

					BaseUtils.printLog("d", TAG, "成功讀取設備訊息   getDevice.getName = " + gatt.getDevice().getName() +
							" , status = " + status);
		        	Message msg = new Message();
					msg.what = CALLBACK_RESULT;
					msg.obj = onRead(characteristic);
		    		mHandler.sendMessage(msg);
		        }

		        @Override
		        public void onCharacteristicChanged(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic) {
		        	String deviceName = gatt.getDevice().getName().trim();
					BaseUtils.printLog("d", TAG, "接收資料 deviceName = " + deviceName);
		        	
//		        	Message msg = Message.obtain(mHandler);
		        	Message msg = new Message();
        			msg.what = CALLBACK_RESULT;
        			msg.obj = deviceName + "==" + onChanged(characteristic);
        			mHandler.sendMessage(msg);
        			
//		        	notifyCound++;
//	        		if(notifyCound == connGattCount){
//	        			removeComm(0);
//	            		sendCount = 0;
//	            		notifyCound = 0;
//	        		}
		        }
			};
		}
		return mLeGattCallback;
    }
    
    /**
     * 獲取支持GATT服務的連接設備上的列表。
     * 這應該是在BluetoothGatt.discoverServices()完成之後
     *
     * @return A {@code List} of supported services.
     */
    private List<BluetoothGattService> getSupportedGattServices(int item) {
    	if(getBluetoothGatt(item) != null)
        	return getBluetoothGatt(item).getServices();
    	
        return null;
    }
    
    /**
     * 搜尋藍牙services
     * @param item 第幾個藍牙
     * @param gattServices
     */
    private void displayGattServices(int item, List<BluetoothGattService> gattServices) {
    	searchGattServices(item, gattServices);
		
    	if(charWriteList.size() == connGattCount && charNotifyCount == connGattCount){
    		if(item != 0 && item == connGattCount - 1){	//Connect 1個藍牙以上
    			connectSuccess();
    		}else if(item == 0 && item + 1 == connGattCount){	//1顆藍牙
    			connectSuccess();
    		}
    	}
    	if(mConnectionThread == null)
    		return;
		synchronized(mConnectionThread){
			mConnectionThread.notify();
		}
    }
    
    private void connectSuccess(){

		BaseUtils.printLog("d", TAG, "connectSuccess CONNECTED------");
    	mCurrentStatus = CONNECTED;
		mHandler.sendEmptyMessage(CALLBACK_STATE);
		if(mConnectionThread != null && !mConnectionThread.isInterrupted()){
    		mConnectionThread.interrupt();
        	mConnectionThread = null;
    	}
		charNotifyCount = 0;
    }
    
    private void initParams(){
    	if(mConnectionThread != null && !mConnectionThread.isInterrupted()){
    		mConnectionThread.interrupt();
        	mConnectionThread = null;
    	}
    	//清除connect timeout callback
		mHandler.removeMessages(SCAN_FINISH);
    	mHandler.removeMessages(CONNECT_TIMEOUT);
//    	mHandler.removeMessages(CALLBACK_STATE);
    	
    	//釋放資源
//    	initBluetoothGattsArray();
//    	notifyCound = 0;
        charNotifyCount = 0;
		isWriteRunning = false;
//    	sendCount = 0;
    	removeAllComm();
    }
    

     // 斷開或取消現有連線
     // 使用給定的BLE設備之後，結束時必須調用該方法，以確保資源正確釋放。

    public synchronized void disconnect(int status){

		BaseUtils.printLog("d", TAG, "disconnect code : " + status);
    	
    	stopLEScan();
    	initParams();
    	
//    	if(mCurrentStatus == DISCONNECTED)
//    		return;
    	
    	mCurrentStatus = status;
    	
    	unregisterBtReceiver();
    	
    	if (getBluetoothGatts() != null){
    		
    		if(getBluetoothGatts().size() > 0){
    			
    			for(int i = 0 ; i < getBluetoothGatts().size() ; i ++){
        			try{
        				if (getBluetoothGatt(i) != null) {
        					
//        	    	    	isManuallyDisconnect = true;
        	    	    	
        					getBluetoothGatt(i).disconnect();
        					getBluetoothGatt(i).close();

							BaseUtils.printLog("e", TAG, "disconnect : " + i);
                        }
        			}catch(Exception e){
        				e.printStackTrace();
        				return;
        			}
        			mHandler.sendEmptyMessage(BluetoothLEUtils.CALLBACK_STATE);
        			//防止NullPointer Unhandled exception in callback.結果還是會出現....
//        			Message msg = new Message();
//        			msg.what = status;
//        			msg.arg1 = i;
//        			mHandler.sendMessageDelayed(msg, 50 * (i + 1));
    			}
    		
        	}
    	}
//    	restartBT();
    	initBluetoothGattsArray();
//		mHandler.sendEmptyMessage(BluetoothLEUtils.CALLBACK_STATE);
    }
    
    public boolean refreshDeviceCache(BluetoothGatt gatt){
        try {
            BluetoothGatt localBluetoothGatt = gatt;
            Method localMethod = localBluetoothGatt.getClass().getMethod("refresh", new Class[0]);
            if (localMethod != null) {
               boolean bool = ((Boolean) localMethod.invoke(localBluetoothGatt, new Object[0])).booleanValue();
                return bool;
             }
        }catch (Exception e) {
			e.printStackTrace();
        }
        return false;
    }
    
}
