package com.ideabus.ideabuslibrary.util;

import android.app.Activity;
import android.content.Context;
import android.graphics.Rect;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;

/**
 * Created by GuanYu on 2016/8/14.
 */
public class KeyboardUtils {

    /**
     * 隱藏EditText鍵盤
     * @param mContext
     * @param editText
     */
    public static void hideSoftInput(Context mContext, EditText editText) {
        editText.setFocusable(false);
        editText.setFocusableInTouchMode(false);
        InputMethodManager inputMethodManager = (InputMethodManager) mContext.getSystemService(Context.INPUT_METHOD_SERVICE);
        inputMethodManager.hideSoftInputFromWindow(editText.getWindowToken(), InputMethodManager.HIDE_NOT_ALWAYS);
    }

    /**
     * 顯示鍵盤
     * @param mContext
     * @param editText
     */
    public static void showSoftInput(Context mContext, EditText editText) {
        editText.setFocusableInTouchMode(true);
        editText.requestFocus();

        InputMethodManager imm = (InputMethodManager) mContext.getSystemService(Context.INPUT_METHOD_SERVICE);
        imm.showSoftInput(editText, InputMethodManager.SHOW_IMPLICIT);
    }

    /**
     * 按下返回鍵，EditText指標消失
     * @param activity
     * @param editText
     */
    public static void setBackHideSoft(Activity activity, final EditText editText) {
        final View rootView = activity.getWindow().getDecorView().findViewById(android.R.id.content);
        rootView.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener() {
            @Override
            public void onGlobalLayout() {
                Rect r = new Rect();
                rootView.getWindowVisibleDisplayFrame(r);
                int screenHeight = rootView.getRootView().getHeight();

                int keypadHeight = screenHeight - r.bottom;

                if (keypadHeight > screenHeight * 0.20) { // 0.20 ratio is perhaps enough to determine keypad height.
                    editText.setFocusableInTouchMode(true);
                    editText.requestFocus();
                } else {
                    editText.setFocusable(false);
                }
            }
        });
    }
}
