/*
 * Decompiled with CFR 0.152.
 */
package com.ideabus.ideabuslibrary.cloud;

import android.support.annotation.NonNull;
import com.ideabus.ideabuslibrary.BaseGlobal;
import com.ideabus.ideabuslibrary.cloud.BaseHttpModule;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;

public abstract class BaseHttpPost
extends BaseHttpModule {
    private static final String TAG = BaseHttpPost.class.getSimpleName();

    @Override
    protected void apiGetSucceeded(String apiUrl, String result) {
    }

    @Override
    protected void apiGetFailed(String apiUrl, int errorCode, String errorMessage) {
    }

    protected void postArchives(String url, String archivesUrl, String key, byte[] data, @NonNull ArrayList<NameValuePair> body) {
        final String api = archivesUrl;
        final String postUrl = url + api;
        final String postKey = key;
        final byte[] rawData = data;
        final ArrayList<NameValuePair> textBody = body;
        new Thread(){

            @Override
            public void run() {
                try {
                    DefaultHttpClient client = new DefaultHttpClient();
                    HttpPost httpPost = new HttpPost(postUrl);
                    MultipartEntityBuilder builder = MultipartEntityBuilder.create();
                    builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
                    ContentType encode = ContentType.create((String)"application/json", (Charset)Consts.UTF_8);
                    if (rawData != null) {
                        builder.addBinaryBody(postKey, rawData, ContentType.MULTIPART_FORM_DATA, "image");
                    }
                    for (NameValuePair values : textBody) {
                        String name = values.getName();
                        String value = values.getValue();
                        if (name == null || value == null || name.length() == 0 || value.length() == 0) continue;
                        builder.addTextBody(name, value, encode);
                    }
                    httpPost.setEntity(builder.build());
                    HttpResponse response = client.execute((HttpUriRequest)httpPost);
                    final String result = EntityUtils.toString((HttpEntity)response.getEntity());
                    BaseHttpPost.this.handler.post(new Runnable(){

                        @Override
                        public void run() {
                            BaseHttpPost.this.apiPostArchivesSucceeded(api, result);
                        }
                    });
                }
                catch (UnknownHostException e) {
                    BaseHttpPost.this.handler.post(new Runnable(){

                        @Override
                        public void run() {
                            BaseHttpPost.this.apiPostArchivesFailed(api, 1, "No internet");
                        }
                    });
                    e.printStackTrace();
                }
                catch (Exception e) {
                    BaseHttpPost.this.handler.post(new Runnable(){

                        @Override
                        public void run() {
                            BaseHttpPost.this.apiPostArchivesFailed(api, 3, e.toString());
                        }
                    });
                    e.printStackTrace();
                }
            }
        }.start();
    }

    protected void postText(String url, String apiUrl, ArrayList<NameValuePair> params) {
        final String api = apiUrl;
        final String postUrl = url + api;
        final ArrayList<NameValuePair> postParams = params;
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                HttpURLConnection urlConnection = null;
                OutputStream outputStream = null;
                ByteArrayOutputStream byteArrayOutputStream = null;
                try {
                    byte[] data = BaseHttpPost.this.getRequestData(postParams, "UTF-8").toString().getBytes();
                    urlConnection = (HttpURLConnection)new URL(postUrl).openConnection();
                    urlConnection.setRequestMethod("POST");
                    urlConnection.setConnectTimeout(10000);
                    urlConnection.setDoInput(true);
                    urlConnection.setDoOutput(true);
                    urlConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                    urlConnection.setRequestProperty("Content-Length", String.valueOf(data.length));
                    outputStream = urlConnection.getOutputStream();
                    outputStream.write(data);
                    outputStream.flush();
                    final int statusCode = urlConnection.getResponseCode();
                    BaseGlobal.printLog("d", TAG, "postText --- statusCode = " + statusCode);
                    if (statusCode == 200) {
                        int len;
                        InputStream inputStream = urlConnection.getInputStream();
                        byteArrayOutputStream = new ByteArrayOutputStream();
                        byte[] bytes = new byte[1024];
                        while ((len = inputStream.read(bytes)) != -1) {
                            byteArrayOutputStream.write(bytes, 0, len);
                        }
                        final String result = new String(byteArrayOutputStream.toByteArray());
                        BaseHttpPost.this.handler.post(new Runnable(){

                            @Override
                            public void run() {
                                BaseHttpPost.this.apiPostSucceeded(api, result);
                            }
                        });
                    } else {
                        BaseHttpPost.this.handler.post(new Runnable(){

                            @Override
                            public void run() {
                                BaseHttpPost.this.apiPostFailed(api, 2, "status code:" + statusCode);
                            }
                        });
                    }
                }
                catch (UnknownHostException e) {
                    e.printStackTrace();
                    BaseHttpPost.this.handler.post(new Runnable(){

                        @Override
                        public void run() {
                            BaseHttpPost.this.apiPostFailed(api, 1, "No internet");
                        }
                    });
                }
                catch (Exception e) {
                    e.printStackTrace();
                    BaseHttpPost.this.handler.post(new Runnable(){

                        @Override
                        public void run() {
                            BaseHttpPost.this.apiPostFailed(api, 3, e.toString());
                        }
                    });
                }
                finally {
                    if (urlConnection != null) {
                        urlConnection.disconnect();
                    }
                    if (outputStream != null) {
                        try {
                            outputStream.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    if (byteArrayOutputStream != null) {
                        try {
                            byteArrayOutputStream.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }.start();
    }
}

