/*
 * Decompiled with CFR 0.152.
 */
package com.ideabus.ideabuslibrary.cloud;

import android.os.Handler;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.ideabus.ideabuslibrary.BaseValuePair;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.http.NameValuePair;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class BaseHttpModule {
    private static final String TAG = BaseHttpModule.class.getSimpleName();
    protected Handler handler = new Handler();
    public static final int ERROR_CODE_NO_INTERNET = 1;
    public static final int ERROR_CODE_SERVER_ERROR = 2;
    public static final int ERROR_CODE_UNKNOWN_ERROR = 3;

    protected abstract void apiPostArchivesSucceeded(String var1, String var2);

    protected abstract void apiPostArchivesFailed(String var1, int var2, String var3);

    protected abstract void apiPostSucceeded(String var1, String var2);

    protected abstract void apiPostFailed(String var1, int var2, String var3);

    protected abstract void apiGetSucceeded(String var1, String var2);

    protected abstract void apiGetFailed(String var1, int var2, String var3);

    public static String encodeJson(ArrayList<BaseValuePair> params, String fieldName) throws JSONException {
        ArrayList<ArrayList<BaseValuePair>> multiParams = new ArrayList<ArrayList<BaseValuePair>>();
        multiParams.add(params);
        return BaseHttpModule.encodeJsonMulti(multiParams, fieldName);
    }

    public static String encodeIntArrayToJson(int[] params, String fieldName) throws JSONException {
        String[] strs = new String[params.length];
        for (int i = 0; i < params.length; ++i) {
            strs[i] = String.valueOf(params[i]);
        }
        return BaseHttpModule.encodeIntArrayToJson(strs, fieldName);
    }

    public static String encodeIntArrayToJson(String[] params, String fieldName) throws JSONException {
        JSONObject resultJson = new JSONObject();
        JSONArray jsonArray = new JSONArray();
        if (fieldName != null && fieldName.length() > 0) {
            for (String values : params) {
                jsonArray.put((Object)values);
            }
            resultJson.put(fieldName, (Object)jsonArray);
            return resultJson.toString();
        }
        for (String values : params) {
            jsonArray.put((Object)values);
        }
        return jsonArray.toString();
    }

    public static String encodeJsonMulti(ArrayList<ArrayList<BaseValuePair>> params, String fieldName) throws JSONException {
        JSONObject resultJson = new JSONObject();
        if (fieldName != null && fieldName.length() > 0) {
            JSONArray jsonArray = new JSONArray();
            for (ArrayList<BaseValuePair> valuesArray : params) {
                JSONObject jsonObject = new JSONObject();
                for (BaseValuePair values : valuesArray) {
                    String valueStr = values.getStringValue();
                    if (valueStr != null) {
                        jsonObject.put(values.getName(), (Object)valueStr);
                        continue;
                    }
                    jsonObject.put(values.getName(), values.getIntValue());
                }
                jsonArray.put((Object)jsonObject);
            }
            resultJson.put(fieldName, (Object)jsonArray);
        } else {
            for (ArrayList<BaseValuePair> valuesArray : params) {
                for (BaseValuePair values : valuesArray) {
                    String valueStr = values.getStringValue();
                    if (valueStr != null) {
                        resultJson.put(values.getName(), (Object)valueStr);
                        continue;
                    }
                    resultJson.put(values.getName(), values.getIntValue());
                }
            }
        }
        return resultJson.toString();
    }

    public static ArrayList<String> parseJsonArrayNoContainKey(@NonNull String jsonString) {
        ArrayList<String> dataList = new ArrayList<String>();
        try {
            JSONArray jsonList = new JSONArray(jsonString);
            for (int i = 0; i < jsonList.length(); ++i) {
                dataList.add(jsonList.getString(i));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dataList.size() == 0 ? null : dataList;
    }

    public static ArrayList<Map<String, String>> parseJsonArrayContainKey(@NonNull String jsonString) {
        ArrayList<Map<String, String>> dataList = new ArrayList<Map<String, String>>();
        try {
            JSONArray jsonList = new JSONArray(jsonString);
            for (int i = 0; i < jsonList.length(); ++i) {
                JSONObject jsonObject = new JSONObject(jsonList.getString(i));
                Map<String, String> map = BaseHttpModule.addDecodingJson(null, jsonObject);
                dataList.add(map);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dataList.size() == 0 ? null : dataList;
    }

    @Nullable
    public static ArrayList<Map<String, String>> parseJson(@NonNull String jsonString, String ... fieldNames) {
        JSONObject jsonObject;
        try {
            jsonObject = new JSONObject(jsonString);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        ArrayList<Map<String, String>> dataList = new ArrayList<Map<String, String>>();
        if (fieldNames != null && fieldNames.length > 0) {
            for (String fieldName : fieldNames) {
                JSONArray jsonList = null;
                HashMap<String, String> outsideMap = new HashMap();
                if (fieldName != null && !fieldName.equals("")) {
                    try {
                        outsideMap = BaseHttpModule.addDecodingJson(null, jsonObject);
                        jsonList = jsonObject.getJSONArray(fieldName);
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                        dataList.add(BaseHttpModule.addDecodingJson(null, jsonObject));
                    }
                }
                if (jsonList != null) {
                    try {
                        for (int i = 0; i < jsonList.length(); ++i) {
                            jsonObject = new JSONObject(jsonList.getString(i));
                            Map<String, String> insideMap = BaseHttpModule.addDecodingJson(outsideMap, jsonObject);
                            insideMap.remove(fieldName);
                            dataList.add(insideMap);
                        }
                        continue;
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                        continue;
                    }
                }
                dataList.add(BaseHttpModule.addDecodingJson(null, jsonObject));
            }
        } else {
            dataList.add(BaseHttpModule.addDecodingJson(null, jsonObject));
        }
        return dataList.size() == 0 ? null : dataList;
    }

    protected static Map<String, String> addDecodingJson(Map<String, String> map, JSONObject jsonObject) {
        Iterator keyIter = jsonObject.keys();
        HashMap<String, String> lastMap = new HashMap<String, String>();
        if (map != null) {
            lastMap.putAll(map);
        }
        try {
            while (keyIter.hasNext()) {
                String key = (String)keyIter.next();
                String value = jsonObject.get(key).toString();
                if (map != null && lastMap.containsKey(key)) {
                    key = key + "1";
                }
                lastMap.put(key, value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return lastMap;
    }

    protected StringBuffer getRequestData(List<NameValuePair> params, String encode) {
        StringBuffer stringBuffer = new StringBuffer();
        for (NameValuePair param : params) {
            String name = param.getName();
            String value = param.getValue();
            if (name == null || value == null || name.length() == 0 || value.length() == 0) continue;
            try {
                stringBuffer.append(name).append("=").append(URLEncoder.encode(value, encode)).append("&");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        BaseHttpModule.deleteEndWord(stringBuffer, "&");
        return stringBuffer;
    }

    public static void deleteEndWord(StringBuffer jsonBuffer, @NonNull String word) {
        int length = jsonBuffer.length();
        if (length == 0) {
            return;
        }
        if (word.equals(jsonBuffer.substring(length - 1, length))) {
            jsonBuffer.delete(length - 1, length);
        }
    }
}

