/*
 * Decompiled with CFR 0.152.
 */
package com.ideabus.ideabuslibrary.cloud;

import com.ideabus.ideabuslibrary.BaseGlobal;
import com.ideabus.ideabuslibrary.cloud.BaseHttpModule;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import org.apache.http.NameValuePair;

public abstract class BaseHttpGet
extends BaseHttpModule {
    private static final String TAG = BaseHttpGet.class.getSimpleName();

    @Override
    protected void apiPostArchivesSucceeded(String apiUrl, String result) {
    }

    @Override
    protected void apiPostArchivesFailed(String apiUrl, int errorCode, String errorMessage) {
    }

    @Override
    protected void apiPostSucceeded(String apiUrl, String result) {
    }

    @Override
    protected void apiPostFailed(String apiUrl, int errorCode, String errorMessage) {
    }

    protected void httpGetMethod(String url, String apiUrl, ArrayList<NameValuePair> params) {
        final String api = apiUrl;
        final String postUrl = url + api;
        final ArrayList<NameValuePair> headers = params;
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                HttpURLConnection urlConnection = null;
                ByteArrayOutputStream byteArrayOutputStream = null;
                try {
                    urlConnection = (HttpURLConnection)new URL(postUrl).openConnection();
                    urlConnection.setRequestMethod("GET");
                    urlConnection.setConnectTimeout(10000);
                    for (NameValuePair valuePair : headers) {
                        urlConnection.setRequestProperty(valuePair.getName(), valuePair.getValue());
                    }
                    final int statusCode = urlConnection.getResponseCode();
                    BaseGlobal.printLog("d", TAG, "httpGetMethod --- statusCode = " + statusCode);
                    if (statusCode == 200) {
                        int len;
                        InputStream inputStream = urlConnection.getInputStream();
                        byteArrayOutputStream = new ByteArrayOutputStream();
                        byte[] bytes = new byte[1024];
                        while ((len = inputStream.read(bytes)) != -1) {
                            byteArrayOutputStream.write(bytes, 0, len);
                        }
                        final String result = new String(byteArrayOutputStream.toByteArray());
                        BaseHttpGet.this.handler.post(new Runnable(){

                            @Override
                            public void run() {
                                BaseHttpGet.this.apiGetSucceeded(api, result);
                            }
                        });
                    } else {
                        BaseHttpGet.this.handler.post(new Runnable(){

                            @Override
                            public void run() {
                                BaseHttpGet.this.apiGetFailed(api, 2, "status code:" + statusCode);
                            }
                        });
                    }
                }
                catch (UnknownHostException e) {
                    e.printStackTrace();
                    BaseHttpGet.this.handler.post(new Runnable(){

                        @Override
                        public void run() {
                            BaseHttpGet.this.apiGetFailed(api, 1, "No internet");
                        }
                    });
                }
                catch (Exception e) {
                    e.printStackTrace();
                    BaseHttpGet.this.handler.post(new Runnable(){

                        @Override
                        public void run() {
                            BaseHttpGet.this.apiGetFailed(api, 3, e.toString());
                        }
                    });
                }
                finally {
                    if (urlConnection != null) {
                        urlConnection.disconnect();
                    }
                    if (byteArrayOutputStream != null) {
                        try {
                            byteArrayOutputStream.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }.start();
    }
}

