/*
 * Decompiled with CFR 0.152.
 */
package com.ideabus.ideabuslibrary.bluetooth;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.os.Message;
import android.util.Log;
import com.ideabus.ideabuslibrary.bluetooth.BluetoothLEHandler;
import com.ideabus.ideabuslibrary.bluetooth.BluetoothLEUtils;
import java.util.List;

public class ConnectionThread
extends Thread {
    private static final String TAG = ConnectionThread.class.getSimpleName();
    private BluetoothLEUtils myBluetooth;
    private BluetoothAdapter mBluetoothAdapter;
    private BluetoothLEHandler mHandler;
    private List<String> address;

    public ConnectionThread(BluetoothLEUtils bt, BluetoothAdapter adapter, BluetoothLEHandler handler, List<String> addr) {
        this.myBluetooth = bt;
        this.mBluetoothAdapter = adapter;
        this.mHandler = handler;
        this.address = addr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.mHandler.removeMessages(20);
        this.mHandler.sendEmptyMessageDelayed(20, 15000L);
        ConnectionThread connectionThread = this;
        synchronized (connectionThread) {
            for (int i = 0; i < this.myBluetooth.connGattCount; ++i) {
                BluetoothDevice device;
                try {
                    device = this.mBluetoothAdapter.getRemoteDevice(this.address.get(i));
                }
                catch (IllegalArgumentException e) {
                    Log.e((String)TAG, (String)("\u9023\u63a5 \u7b2c " + i + " \u9846\u85cd\u7259\u51fa\u73fe\u932f\u8aa4  " + e.toString()));
                    this.myBluetooth.disconnect(18);
                    return;
                }
                if (device == null) {
                    Log.e((String)TAG, (String)("\u7b2c " + i + " \u9846\u85cd\u7259\u672a\u627e\u5230"));
                    this.myBluetooth.disconnect(18);
                    return;
                }
                Message msg = new Message();
                msg.what = 21;
                msg.arg1 = i;
                msg.obj = device;
                this.mHandler.sendMessage(msg);
                if (i >= this.myBluetooth.connGattCount - 1) continue;
                try {
                    this.wait();
                    Thread.sleep(600L);
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    this.myBluetooth.disconnect(18);
                    return;
                }
            }
        }
    }
}

