/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.service.impl;

import com.icthh.xm.commons.domain.FunctionResult;
import com.icthh.xm.commons.domain.enums.FunctionTxTypes;
import com.icthh.xm.commons.domain.spec.IFunctionSpec;
import com.icthh.xm.commons.service.FunctionExecutorService;
import com.icthh.xm.commons.service.FunctionResultProcessor;
import com.icthh.xm.commons.service.FunctionService;
import com.icthh.xm.commons.service.FunctionServiceFacade;
import com.icthh.xm.commons.service.FunctionTxControl;
import com.icthh.xm.commons.utils.Constants;
import com.icthh.xm.commons.utils.HttpRequestUtils;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.commons.lang3.time.StopWatch;
import org.springframework.security.access.AccessDeniedException;

public abstract class AbstractFunctionServiceFacade<FS extends IFunctionSpec>
implements FunctionServiceFacade {
    private final FunctionService<FS> functionService;
    private final FunctionTxControl functionTxControl;
    private final FunctionExecutorService functionExecutorService;
    private final FunctionResultProcessor<FS> functionResultProcessor;

    @Override
    public FunctionResult execute(String functionKey, Map<String, Object> functionInput, String httpMethod) {
        StopWatch stopWatch = StopWatch.createStarted();
        this.functionService.validateFunctionKey(functionKey);
        FS functionSpec = this.functionService.findFunctionSpec(functionKey, httpMethod);
        String functionSpecFromSpec = functionSpec.getKey();
        this.functionService.checkPermissions(Constants.FUNCTION_CALL_PRIVILEGE, functionSpecFromSpec);
        Map<String, Object> input = this.functionService.getValidFunctionInput(functionSpec, functionInput);
        this.functionService.enrichInputFromPathParams(functionKey, input, functionSpec);
        FunctionResult functionResult = this.callLepExecutor(functionSpec.getTxType(), () -> {
            String lepHttpMethod = HttpRequestUtils.convertToCanonicalHttpMethod(httpMethod);
            Object data = this.functionExecutorService.execute(functionSpecFromSpec, input, lepHttpMethod);
            return this.processFunctionResult(functionSpecFromSpec, data, functionSpec);
        });
        functionResult.setExecuteTime(stopWatch.getTime(TimeUnit.MILLISECONDS));
        return functionResult;
    }

    @Override
    public FunctionResult executeAnonymous(String functionKey, Map<String, Object> functionInput, String httpMethod) {
        StopWatch stopWatch = StopWatch.createStarted();
        FS functionSpec = this.functionService.findFunctionSpec(functionKey, httpMethod);
        if (!functionSpec.getAnonymous().booleanValue()) {
            throw new AccessDeniedException("Access denied");
        }
        this.functionService.validateFunctionKey(functionKey);
        Map<String, Object> input = this.functionService.getValidFunctionInput(functionSpec, functionInput);
        this.functionService.enrichInputFromPathParams(functionKey, input, functionSpec);
        FunctionResult functionResult = this.callLepExecutor(functionSpec.getTxType(), () -> {
            String lepHttpMethod = HttpRequestUtils.convertToCanonicalHttpMethod(httpMethod);
            Object data = this.functionExecutorService.executeAnonymousFunction(functionSpec.getKey(), input, lepHttpMethod);
            return this.processFunctionResult(functionKey, data, functionSpec);
        });
        functionResult.setExecuteTime(stopWatch.getTime(TimeUnit.MILLISECONDS));
        return functionResult;
    }

    public FunctionResult callLepExecutor(FunctionTxTypes txType, Supplier<FunctionResult> logic) {
        return switch (txType) {
            case FunctionTxTypes.READ_ONLY -> this.functionTxControl.executeInTransactionWithRoMode(logic);
            case FunctionTxTypes.NO_TX -> this.functionTxControl.executeWithNoTx(logic);
            default -> this.functionTxControl.executeInTransaction(logic);
        };
    }

    private FunctionResult processFunctionResult(String functionKey, Object data, FS functionSpec) {
        return this.functionResultProcessor.processFunctionResult(functionKey, data, functionSpec);
    }

    public AbstractFunctionServiceFacade(FunctionService<FS> functionService, FunctionTxControl functionTxControl, FunctionExecutorService functionExecutorService, FunctionResultProcessor<FS> functionResultProcessor) {
        this.functionService = functionService;
        this.functionTxControl = functionTxControl;
        this.functionExecutorService = functionExecutorService;
        this.functionResultProcessor = functionResultProcessor;
    }
}

