/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.web.rest;

import com.codahale.metrics.annotation.Timed;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.icthh.xm.commons.domain.FunctionSpecWithFileName;
import com.icthh.xm.commons.permission.annotation.PrivilegeDescription;
import com.icthh.xm.commons.service.FunctionManageService;
import com.icthh.xm.commons.service.FunctionSpecService;
import com.icthh.xm.commons.service.impl.AbstractFunctionService;
import com.icthh.xm.commons.web.rest.response.DataSchemaResponse;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
public class FunctionSpecResource {
    private static final Logger log = LoggerFactory.getLogger(FunctionSpecResource.class);
    public static final String XME_SPEC_API = "/spec/functions";
    private final FunctionSpecService functionSpecService;
    private final AbstractFunctionService<?> functionService;
    private final FunctionManageService<?, FunctionSpecWithFileName<?>> functionManageService;
    private final ObjectMapper objectMapper = new ObjectMapper();

    @GetMapping(value={"/functions/dataschemas"}, produces={"application/json"})
    @Timed
    @PostAuthorize(value="hasPermission({'returnObject': returnObject.body}, 'FUNCTION_SPEC.DATA_SCHEMA.GET')")
    @PrivilegeDescription(value="Privilege to get the function specification data schema")
    public ResponseEntity<List<DataSchemaResponse>> getDataSpecSchemas() {
        return ResponseEntity.ok().body(this.functionSpecService.getDataSpecSchemas());
    }

    @GetMapping(value={"/spec/functions/all"}, produces={"application/json"})
    @Timed
    @PostAuthorize(value="hasPermission({'returnObject': returnObject.body}, 'FUNCTION_SPEC.GET_LIST')")
    @PrivilegeDescription(value="Privilege to get the function specification data schema")
    public ResponseEntity<Collection<?>> getAllFunctions() {
        return ResponseEntity.ok().body(this.functionService.getAllFunctionSpecs());
    }

    @GetMapping(value={"/spec/functions/files"}, produces={"application/json"})
    @Timed
    @PostAuthorize(value="hasPermission({'returnObject': returnObject.body}, 'FUNCTION_SPEC.FILES.GET_LIST')")
    @PrivilegeDescription(value="Privilege to get the function specification data schema")
    public ResponseEntity<Collection<String>> getAllFiles() {
        return ResponseEntity.ok().body(this.functionService.getAllFileNames());
    }

    @PostMapping(value={"/spec/functions"}, consumes={"application/json"})
    @Timed
    @PreAuthorize(value="hasPermission({'body': #body}, 'FUNCTION_SPEC.ADD')")
    @PrivilegeDescription(value="Privilege to add a function specification")
    public ResponseEntity<Void> addFunction(@RequestBody Map<String, Object> body) {
        FunctionSpecWithFileName<?> dto = this.readBody(body);
        this.functionManageService.addFunction(dto);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).build();
    }

    @PutMapping(value={"/spec/functions"}, consumes={"application/json"})
    @Timed
    @PreAuthorize(value="hasPermission({'body': #body}, 'FUNCTION_SPEC.UPDATE')")
    @PrivilegeDescription(value="Privilege to add a function specification")
    public ResponseEntity<Void> updateFunction(@RequestBody Map<String, Object> body) {
        FunctionSpecWithFileName<?> dto = this.readBody(body);
        this.functionManageService.updateFunction(dto);
        return ResponseEntity.ok().build();
    }

    @DeleteMapping(value={"/spec/functions/{functionKey}"})
    @Timed
    @PreAuthorize(value="hasPermission({'fileKey': #fileKey, 'functionKey': #functionKey}, 'FUNCTION_SPEC.REMOVE')")
    @PrivilegeDescription(value="Privilege to remove a function specification")
    public ResponseEntity<Void> removeFunction(@PathVariable(value="functionKey") String functionKey) {
        this.functionManageService.removeFunction(functionKey);
        return ResponseEntity.ok().build();
    }

    private FunctionSpecWithFileName<?> readBody(Map<String, Object> body) {
        return (FunctionSpecWithFileName)this.objectMapper.convertValue(body, this.functionManageService.getFunctionSpecWrapperClass());
    }

    public FunctionSpecResource(FunctionSpecService functionSpecService, AbstractFunctionService<?> functionService, FunctionManageService<?, FunctionSpecWithFileName<?>> functionManageService) {
        this.functionSpecService = functionSpecService;
        this.functionService = functionService;
        this.functionManageService = functionManageService;
    }
}

