/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.swagger.impl;

import com.icthh.xm.commons.config.FunctionApiSpecConfiguration;
import com.icthh.xm.commons.config.swagger.DynamicSwaggerConfiguration;
import com.icthh.xm.commons.config.swagger.DynamicSwaggerRefreshableConfiguration;
import com.icthh.xm.commons.domain.spec.FunctionApiSpecs;
import com.icthh.xm.commons.domain.spec.FunctionSpec;
import com.icthh.xm.commons.swagger.impl.DefaultDynamicSwaggerFunctionGenerator;
import com.icthh.xm.commons.tenant.TenantContextHolder;
import com.icthh.xm.commons.tenant.TenantContextUtils;
import com.icthh.xm.commons.utils.CollectionsUtils;
import com.icthh.xm.commons.utils.FunctionSpecUtils;
import com.icthh.xm.commons.utils.SwaggerGeneratorUtils;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Component;

@Component(value="dynamicSwaggerFunctionGenerator")
public class DynamicSwaggerFunctionGeneratorImpl
extends DefaultDynamicSwaggerFunctionGenerator<FunctionSpec> {
    public static final List<String> DEFAULT_METHODS = List.of(HttpMethod.GET.name(), HttpMethod.POST.name());
    private final FunctionApiSpecConfiguration functionApiSpecConfiguration;
    private final TenantContextHolder tenantContextHolder;

    public DynamicSwaggerFunctionGeneratorImpl(@Value(value="${spring.application.name}") String appName, DynamicSwaggerRefreshableConfiguration dynamicSwaggerService, FunctionApiSpecConfiguration functionApiSpecConfiguration, TenantContextHolder tenantContextHolder) {
        super(appName, dynamicSwaggerService);
        this.functionApiSpecConfiguration = functionApiSpecConfiguration;
        this.tenantContextHolder = tenantContextHolder;
    }

    @Override
    public List<FunctionSpec> getFunctionSpecs(DynamicSwaggerConfiguration swaggerConfig) {
        Collection<FunctionApiSpecs> specs = this.getAllTenantSpecifications();
        return specs.stream().map(FunctionApiSpecs::getItems).filter(Objects::nonNull).flatMap(Collection::stream).filter(Objects::nonNull).filter(FunctionSpecUtils.byFilters(swaggerConfig)).collect(Collectors.toList());
    }

    @Override
    public List<String> getFunctionHttpMethods(FunctionSpec functionSpec) {
        List<String> httpMethods = CollectionUtils.isEmpty(functionSpec.getHttpMethods()) ? DEFAULT_METHODS : functionSpec.getHttpMethods();
        SwaggerGeneratorUtils.getSupportedHttpMethodFilters().stream().filter(f -> f.supported(functionSpec)).forEach(f -> f.filter(httpMethods));
        functionSpec.setHttpMethods(httpMethods);
        return httpMethods;
    }

    @Override
    public List<String> getFunctionTags(FunctionSpec functionSpec) {
        return CollectionsUtils.nullSafe(functionSpec.getTags());
    }

    @Override
    public String getFunctionName(FunctionSpec functionSpec) {
        Map<String, String> nameMap = CollectionsUtils.nullSafe(functionSpec.getName());
        return Optional.ofNullable(nameMap.get("en")).orElse(nameMap.values().stream().findFirst().orElse(functionSpec.getKey()));
    }

    @Override
    public String getFunctionDescription(FunctionSpec functionSpec) {
        return Optional.ofNullable(functionSpec.getDescription()).orElse(functionSpec.getKey());
    }

    @Override
    public String getFunctionInputJsonSchema(FunctionSpec functionSpec) {
        return functionSpec.getInputDataSpec();
    }

    @Override
    public String getFunctionOutputJsonSchema(FunctionSpec functionSpec) {
        return functionSpec.getOutputDataSpec();
    }

    private Collection<FunctionApiSpecs> getAllTenantSpecifications() {
        String tenantName = TenantContextUtils.getRequiredTenantKeyValue((TenantContextHolder)this.tenantContextHolder);
        return this.functionApiSpecConfiguration.getTenantSpecifications(tenantName).values();
    }
}

