/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.service.impl;

import com.icthh.xm.commons.config.FunctionApiSpecConfiguration;
import com.icthh.xm.commons.domain.FunctionSpecWithFileName;
import com.icthh.xm.commons.domain.spec.FunctionSpec;
import com.icthh.xm.commons.permission.service.DynamicPermissionCheckService;
import com.icthh.xm.commons.service.impl.AbstractFunctionService;
import com.icthh.xm.commons.tenant.TenantContextHolder;
import com.icthh.xm.commons.utils.CollectionsUtils;
import com.icthh.xm.commons.utils.FunctionSpecUtils;
import com.icthh.xm.commons.utils.JsonValidationUtils;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.util.AntPathMatcher;

@Service(value="functionService")
public class FunctionServiceImpl
extends AbstractFunctionService<FunctionSpec> {
    private final TenantContextHolder tenantContextHolder;
    private final FunctionApiSpecConfiguration functionApiSpecConfiguration;
    private final AntPathMatcher matcher;

    public FunctionServiceImpl(@Qualifier(value="dynamicPermissionCheckService") DynamicPermissionCheckService dynamicPermissionCheckService, TenantContextHolder tenantContextHolder, FunctionApiSpecConfiguration functionApiSpecConfiguration) {
        super(dynamicPermissionCheckService);
        this.tenantContextHolder = tenantContextHolder;
        this.functionApiSpecConfiguration = functionApiSpecConfiguration;
        this.matcher = new AntPathMatcher();
    }

    @Override
    public FunctionSpec findFunctionSpec(String functionKey, String httpMethod) {
        String tenantKey = this.tenantContextHolder.getTenantKey();
        return this.functionApiSpecConfiguration.getSpecByKeyAndTenant(functionKey, tenantKey).filter(fs -> FunctionSpecUtils.filterAndLogByHttpMethod(httpMethod, fs)).or(() -> this.filterByPathAsFunctionKey(tenantKey, functionKey, httpMethod)).orElseThrow(() -> new IllegalStateException(String.format("Function by key: %s and tenant: %s not found", functionKey, tenantKey)));
    }

    @Override
    public Collection<FunctionSpecWithFileName<FunctionSpec>> getAllFunctionSpecs() {
        String tenantKey = this.tenantContextHolder.getTenantKey();
        return this.functionApiSpecConfiguration.getFunctionSpecsWithFileName(tenantKey);
    }

    private Optional<FunctionSpec> filterByPathAsFunctionKey(String tenantKey, String functionKey, String httpMethod) {
        return this.functionApiSpecConfiguration.getOrderedSpecByTenant(tenantKey).stream().filter(fs -> fs.getPath() != null).filter(fs -> this.matcher.match(fs.getPath(), functionKey)).filter(fs -> FunctionSpecUtils.filterByHttpMethod(httpMethod, fs)).findFirst();
    }

    @Override
    public Map<String, Object> getValidFunctionInput(FunctionSpec functionSpec, Map<String, Object> functionInput) {
        Map<String, Object> input = CollectionsUtils.getOrEmpty(functionInput);
        if (Boolean.TRUE.equals(functionSpec.getValidateFunctionInput())) {
            JsonValidationUtils.assertJson(functionInput, functionSpec.getInputSpec());
        }
        return input;
    }

    @Override
    public Collection<String> getAllFileNames() {
        String tenantKey = this.tenantContextHolder.getTenantKey();
        return this.functionApiSpecConfiguration.getFileNames(tenantKey);
    }
}

