/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.icthh.xm.commons.domain.FunctionResult;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.springframework.web.servlet.ModelAndView;

public class DefaultFunctionResult
implements FunctionResult {
    private Instant startDate;
    private Instant endDate;
    private Map<String, Object> data = new HashMap<String, Object>();

    @Override
    public long getExecuteTime() {
        Instant startDate = Optional.ofNullable(this.startDate).orElse(Instant.now());
        Instant endDate = Optional.ofNullable(this.endDate).orElse(Instant.now());
        return startDate != null && endDate != null ? Duration.between(startDate, endDate).getSeconds() : 0L;
    }

    @Override
    @JsonIgnore
    public Object functionResult() {
        return this.data;
    }

    @Override
    @JsonIgnore
    public ModelAndView getModelAndView() {
        return Optional.ofNullable(this.getData()).map(d -> d.get("modelAndView")).orElse(null);
    }

    public Instant getStartDate() {
        return this.startDate;
    }

    public Instant getEndDate() {
        return this.endDate;
    }

    @Override
    public Map<String, Object> getData() {
        return this.data;
    }

    public void setStartDate(Instant startDate) {
        this.startDate = startDate;
    }

    public void setEndDate(Instant endDate) {
        this.endDate = endDate;
    }

    public void setData(Map<String, Object> data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultFunctionResult)) {
            return false;
        }
        DefaultFunctionResult other = (DefaultFunctionResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Instant this$startDate = this.getStartDate();
        Instant other$startDate = other.getStartDate();
        if (this$startDate == null ? other$startDate != null : !((Object)this$startDate).equals(other$startDate)) {
            return false;
        }
        Instant this$endDate = this.getEndDate();
        Instant other$endDate = other.getEndDate();
        if (this$endDate == null ? other$endDate != null : !((Object)this$endDate).equals(other$endDate)) {
            return false;
        }
        Object this$data = this.getData();
        Object other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DefaultFunctionResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Instant $startDate = this.getStartDate();
        result = result * 59 + ($startDate == null ? 43 : ((Object)$startDate).hashCode());
        Instant $endDate = this.getEndDate();
        result = result * 59 + ($endDate == null ? 43 : ((Object)$endDate).hashCode());
        Object $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }

    public String toString() {
        return "DefaultFunctionResult(startDate=" + String.valueOf(this.getStartDate()) + ", endDate=" + String.valueOf(this.getEndDate()) + ", data=" + String.valueOf(this.getData()) + ")";
    }

    public DefaultFunctionResult() {
    }

    public DefaultFunctionResult(Instant startDate, Instant endDate, Map<String, Object> data) {
        this.startDate = startDate;
        this.endDate = endDate;
        this.data = data;
    }
}

