/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.config;

import com.icthh.xm.commons.domain.FunctionResult;
import com.icthh.xm.commons.domain.spec.FunctionSpec;
import com.icthh.xm.commons.service.FunctionExecutorService;
import com.icthh.xm.commons.service.FunctionResultProcessor;
import com.icthh.xm.commons.service.FunctionService;
import com.icthh.xm.commons.service.FunctionServiceFacade;
import com.icthh.xm.commons.service.FunctionTxControl;
import com.icthh.xm.commons.service.impl.AbstractFunctionServiceFacade;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class FunctionApiConfiguration {
    private static final Logger log = LoggerFactory.getLogger(FunctionApiConfiguration.class);

    @Bean
    @ConditionalOnMissingBean(value={FunctionResultProcessor.class})
    public FunctionResultProcessor<FunctionSpec> functionResultProcessor() {
        return (functionKey, executorResult, functionSpec) -> {
            log.debug("Function result wrapping is not implemented for function: {}", (Object)functionKey);
            return (FunctionResult)executorResult;
        };
    }

    @Bean
    @ConditionalOnMissingBean(value={FunctionServiceFacade.class})
    public FunctionServiceFacade functionServiceFacade(FunctionService<FunctionSpec> functionService, FunctionTxControl functionTxControl, FunctionExecutorService functionExecutorService, FunctionResultProcessor<FunctionSpec> functionResultProcessor) {
        return new AbstractFunctionServiceFacade<FunctionSpec>(this, functionService, functionTxControl, functionExecutorService, functionResultProcessor){};
    }
}

