/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.utils;

import com.icthh.xm.commons.domain.spec.FunctionSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public final class FunctionSpecUtils {
    private static final Logger log = LoggerFactory.getLogger(FunctionSpecUtils.class);

    public static boolean filterAndLogByHttpMethod(String httpMethod, FunctionSpec functionSpec) {
        if (FunctionSpecUtils.filterByHttpMethod(httpMethod, functionSpec)) {
            return true;
        }
        log.error("Function {} not found for http method {}", (Object)functionSpec.getKey(), (Object)httpMethod);
        return false;
    }

    public static boolean filterByHttpMethod(String httpMethod, FunctionSpec functionSpec) {
        return CollectionUtils.isEmpty(functionSpec.getHttpMethods()) || functionSpec.getHttpMethods().contains(httpMethod);
    }

    private FunctionSpecUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

