/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.service;

import com.icthh.xm.commons.domain.spec.IFunctionSpec;
import com.icthh.xm.commons.service.FunctionExecutorWrapper;
import com.icthh.xm.commons.service.FunctionExportServiceFacade;
import com.icthh.xm.commons.service.FunctionService;
import com.icthh.xm.commons.service.FunctionTxControl;
import com.icthh.xm.commons.utils.Constants;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Service;

@Service
public class FunctionExportServiceFacadeImpl<FS extends IFunctionSpec>
implements FunctionExportServiceFacade {
    private static final Logger log = LoggerFactory.getLogger(FunctionExportServiceFacadeImpl.class);
    private final FunctionService<FS> functionService;
    private final FunctionTxControl functionTxControl;
    private final FunctionExecutorWrapper functionExecutorWrapper;

    @Override
    public void execute(String functionKey, String fileFormat, Map<String, Object> functionInput, HttpServletResponse response) {
        this.functionService.validateFunctionKey(functionKey);
        IFunctionSpec functionSpec = this.functionService.findFunctionSpec(functionKey, HttpMethod.GET.name());
        String functionSpecKey = functionSpec.getKey();
        this.functionService.checkPermissions(Constants.FUNCTION_CALL_PRIVILEGE, functionSpecKey);
        Map input = this.functionService.getValidFunctionInput(functionSpec, functionInput);
        this.functionService.enrichInputFromPathParams(functionKey, input, functionSpec);
        this.functionTxControl.executeInTransactionWithRoMode(() -> this.functionExecutorWrapper.execute(functionSpecKey, fileFormat, input, response));
    }

    public FunctionExportServiceFacadeImpl(FunctionService<FS> functionService, FunctionTxControl functionTxControl, FunctionExecutorWrapper functionExecutorWrapper) {
        this.functionService = functionService;
        this.functionTxControl = functionTxControl;
        this.functionExecutorWrapper = functionExecutorWrapper;
    }
}

