/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.rest.handler.helper;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ssl.SSLException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.collective.plugins.CollectivePlugin;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.rest.handler.RESTRequest;
import com.ibm.wsspi.rest.handler.RESTResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(service={DefaultRoutingHelper.class}, configurationPolicy=ConfigurationPolicy.IGNORE, immediate=true, property={"service.vendor=IBM"})
public class DefaultRoutingHelper {
    private static final TraceComponent tc = Tr.register(DefaultRoutingHelper.class);
    private static final String KEY_COLLECTIVE_PLUGIN = "collectivePlugin";
    private final AtomicServiceReference<CollectivePlugin> collectivePluginRef = new AtomicServiceReference("collectivePlugin");
    static final long serialVersionUID = 2864002268559162305L;

    @Activate
    protected void activate(ComponentContext cc, Map<String, Object> props) {
        this.collectivePluginRef.activate(cc);
    }

    @Deactivate
    protected void deactivate(ComponentContext cc) {
        this.collectivePluginRef.deactivate(cc);
    }

    @Reference(name="collectivePlugin", service=CollectivePlugin.class)
    protected void setCollectivePlugin(ServiceReference<CollectivePlugin> ref) {
        this.collectivePluginRef.setReference(ref);
    }

    protected void unsetCollectivePlugin(ServiceReference<CollectivePlugin> ref) {
        this.collectivePluginRef.unsetReference(ref);
    }

    private CollectivePlugin getCollectivePlugin() {
        CollectivePlugin plugin = (CollectivePlugin)this.collectivePluginRef.getService();
        if (plugin == null) {
            throw new RuntimeException(TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.rest.handler.internal.resources.RESTHandlerMessages", (String)"OSGI_SERVICE_ERROR", (Object[])new Object[]{"CollectivePlugin"}, (String)"CWWKO1001E: OSGi service {0} is not available."));
        }
        return plugin;
    }

    /*
     * WARNING - void declaration
     */
    public void routeRequest(RESTRequest request, RESTResponse response) throws IOException {
        List<RoutingContext> routingContexts = null;
        try {
            routingContexts = DefaultRoutingHelper.getRoutingContext(request);
            if (routingContexts == null) {
                routingContexts = Collections.singletonList(DefaultRoutingHelper.getLegacyRoutingContext(request));
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            void iae;
            FFDCFilter.processException((Throwable)illegalArgumentException, (String)"com.ibm.wsspi.rest.handler.helper.DefaultRoutingHelper", (String)"131", (Object)this, (Object[])new Object[]{request, response});
            response.sendError(400, iae.getMessage());
            return;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            for (RoutingContext context : routingContexts) {
                Tr.debug((Object)"routeRequest", (TraceComponent)tc, (String)("Host: " + context.hostName + " | ServerUsrDir: " + context.serverUserDir + " | ServerName: " + context.serverName), (Object[])new Object[0]);
            }
        }
        for (RoutingContext context : routingContexts) {
            if (context.serverUserDir == null || context.serverName == null) {
                throw new IllegalArgumentException("This RESTHandler endpoint does not support host-level routing!");
            }
            String[] hostPort = this.getHostPortTuple(context.hostName, context.serverUserDir, context.serverName);
            String uri = request.getURI();
            String queryString = request.getQueryString();
            if (queryString != null) {
                uri = uri + "?" + queryString;
            }
            URL url = new URL("https://" + hostPort[0] + ":" + hostPort[1] + uri);
            HttpsURLConnection connection = (HttpsURLConnection)url.openConnection();
            boolean doOutput = request.getMethod().equalsIgnoreCase("PUT") || request.getMethod().equalsIgnoreCase("POST");
            connection.setDoInput(true);
            connection.setDoOutput(doOutput);
            connection.setUseCaches(false);
            connection.setRequestMethod(request.getMethod());
            String originalContentType = request.getHeader("Content-Type");
            if (originalContentType != null) {
                connection.setRequestProperty("Content-Type", originalContentType);
            }
            try {
                connection.setSSLSocketFactory(this.getCollectivePlugin().getSSLContent("memberConnectionConfig").getSocketFactory());
            }
            catch (SSLException sSLException) {
                void e;
                FFDCFilter.processException((Throwable)sSLException, (String)"com.ibm.wsspi.rest.handler.helper.DefaultRoutingHelper", (String)"179", (Object)this, (Object[])new Object[]{request, response});
                throw new RuntimeException(TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.rest.handler.internal.resources.RESTHandlerMessages", (String)"SSL_CONTEXT_NOT_AVAILABLE", (Object[])new Object[]{e.getMessage()}, (String)"CWWKO1002E: Encountered the following exception while resolving a collective member's SSL context: {0}"));
            }
            if (doOutput) {
                this.copyStream(request.getInputStream(), connection.getOutputStream());
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((Object)"DefaultRoutingHelper", (TraceComponent)tc, (String)("Routing to target URL: " + url.toString()), (Object[])new Object[0]);
            }
            int responseCode = connection.getResponseCode();
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((Object)"DefaultRoutingHelper", (TraceComponent)tc, (String)("Received responseCode: " + responseCode), (Object[])new Object[0]);
            }
            response.setStatus(responseCode);
            this.copyResponseHeaders(connection, response);
            response.setContentType(connection.getContentType());
            if (connection.getErrorStream() == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((Object)"DefaultRoutingHelper", (TraceComponent)tc, (String)"Copying input stream", (Object[])new Object[0]);
                }
                this.copyStream(connection.getInputStream(), response.getOutputStream());
                continue;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((Object)"DefaultRoutingHelper", (TraceComponent)tc, (String)"Copying error stream", (Object[])new Object[0]);
            }
            this.copyStream(connection.getErrorStream(), response.getOutputStream());
        }
    }

    private void copyResponseHeaders(HttpsURLConnection connection, RESTResponse response) {
        boolean hasMoreFields = true;
        int i = 0;
        while (hasMoreFields) {
            String headerName = connection.getHeaderFieldKey(i);
            String headerValue = connection.getHeaderField(i);
            if (headerName == null) {
                hasMoreFields = false;
                continue;
            }
            response.setResponseHeader(headerName, headerValue);
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long copyStream(InputStream input, OutputStream output) throws IOException {
        if (input != null) {
            long l;
            ReadableByteChannel inputChannel;
            block15: {
                inputChannel = null;
                WritableByteChannel outputChannel = null;
                try {
                    inputChannel = Channels.newChannel(input);
                    outputChannel = Channels.newChannel(output);
                    ByteBuffer buffer = ByteBuffer.allocate(4096);
                    long size = 0L;
                    buffer.clear();
                    while (inputChannel.read(buffer) >= 0 || buffer.position() != 0) {
                        buffer.flip();
                        size += (long)outputChannel.write(buffer);
                        buffer.compact();
                    }
                    l = size;
                    if (outputChannel == null) break block15;
                }
                catch (Throwable throwable) {
                    if (outputChannel != null) {
                        try {
                            outputChannel.close();
                        }
                        catch (IOException iOException) {
                            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.wsspi.rest.handler.helper.DefaultRoutingHelper", (String)"263", (Object)this, (Object[])new Object[]{input, output});
                        }
                    }
                    if (inputChannel != null) {
                        try {
                            inputChannel.close();
                        }
                        catch (IOException e) {
                            FFDCFilter.processException((Throwable)e, (String)"com.ibm.wsspi.rest.handler.helper.DefaultRoutingHelper", (String)"269", (Object)this, (Object[])new Object[]{input, output});
                        }
                    }
                    throw throwable;
                }
                try {
                    outputChannel.close();
                }
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.wsspi.rest.handler.helper.DefaultRoutingHelper", (String)"263", (Object)this, (Object[])new Object[]{input, output});
                }
            }
            if (inputChannel != null) {
                try {
                    inputChannel.close();
                }
                catch (IOException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.wsspi.rest.handler.helper.DefaultRoutingHelper", (String)"269", (Object)this, (Object[])new Object[]{input, output});
                }
            }
            return l;
        }
        return 0L;
    }

    private String[] getHostPortTuple(String host, String userDir, String serverName) throws IllegalArgumentException, IOException {
        Map mapJMXAuth = (Map)this.getCollectivePlugin().getPrivateServerNode(host, userDir, serverName, "sys.jmx.auth.info");
        String[] hostPort = new String[2];
        Object o = mapJMXAuth.get("jmxHost");
        if (o != null) {
            hostPort[0] = (String)o;
        }
        if ((o = mapJMXAuth.get("jmxPort")) != null) {
            hostPort[1] = (String)o;
        }
        if (hostPort[0] == null || hostPort[1] == null) {
            throw new RuntimeException("Could not fetch the target host and port for server: {" + host + ", " + userDir + ", " + serverName + "}");
        }
        return hostPort;
    }

    public static boolean containsLegacyRoutingContext(RESTRequest request) {
        return request.getHeader("com.ibm.websphere.jmx.connector.rest.routing.hostName") != null;
    }

    public static boolean containsRoutingContext(RESTRequest request) {
        if (request.getHeader("collective.hostNames") != null) {
            return true;
        }
        return request.getParameter("collective.hostNames") != null;
    }

    public static RoutingContext getLegacyRoutingContext(RESTRequest request) {
        String targetHost = request.getHeader("com.ibm.websphere.jmx.connector.rest.routing.hostName");
        if (targetHost != null) {
            String targetUserDir = request.getHeader("com.ibm.websphere.jmx.connector.rest.routing.serverUserDir");
            String targetServer = request.getHeader("com.ibm.websphere.jmx.connector.rest.routing.serverName");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)"DefaultRoutingHelper", (TraceComponent)tc, (String)("Found routing context in headers.  Host:" + targetHost + " | UserDir:" + targetUserDir + " | Server:" + targetServer), (Object[])new Object[0]);
            }
            return new RoutingContext(targetHost, null, targetUserDir, targetServer);
        }
        return null;
    }

    public static List<RoutingContext> getRoutingContext(RESTRequest request) {
        String targetHosts = request.getHeader("collective.hostNames");
        if (targetHosts != null) {
            String targetInstallDirs = request.getHeader("collective.installDirs");
            String targetUserDirs = request.getHeader("collective.serverUserDirs");
            String targetServers = request.getHeader("collective.serverNames");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)"DefaultRoutingHelper", (TraceComponent)tc, (String)("Found routing context in headers.  Hosts:" + targetHosts + " | InstallDirs" + targetInstallDirs + " | UserDirs:" + targetUserDirs + " | Servers:" + targetServers), (Object[])new Object[0]);
            }
            String[] hosts = targetHosts.split(",");
            String[] installDirs = targetInstallDirs == null ? null : targetInstallDirs.split(",");
            String[] userDirs = targetUserDirs == null ? null : targetUserDirs.split(",");
            String[] servers = targetServers == null ? null : targetServers.split(",");
            return DefaultRoutingHelper.assembleRoutingContext(hosts, installDirs, userDirs, servers);
        }
        Map<String, String[]> parameters = request.getParameterMap();
        if (parameters.containsKey("collective.hostNames")) {
            return DefaultRoutingHelper.assembleRoutingContext(parameters.get("collective.hostNames"), parameters.get("collective.installDirs"), parameters.get("collective.serverUserDirs"), parameters.get("collective.serverNames"));
        }
        return null;
    }

    private static List<RoutingContext> assembleRoutingContext(String[] hosts, String[] installDirs, String[] userDirs, String[] servers) {
        int serversLength;
        int userDirsLength = userDirs == null ? 0 : userDirs.length;
        int n = serversLength = servers == null ? 0 : servers.length;
        if (userDirs != null && hosts.length != userDirsLength || userDirsLength != serversLength) {
            throw new IllegalArgumentException("The length of the routing context parameters did not match: Hosts:" + hosts.length + " | UserDirs:" + userDirsLength + " | Servers:" + serversLength);
        }
        ArrayList<RoutingContext> contexts = new ArrayList<RoutingContext>(hosts.length);
        for (int i = 0; i < hosts.length; ++i) {
            String installDir = installDirs == null ? null : installDirs[i].trim();
            String userDir = userDirs == null ? null : userDirs[i].trim();
            String serverName = servers == null ? null : servers[i].trim();
            contexts.add(new RoutingContext(hosts[i].trim(), installDir, userDir, serverName));
        }
        return contexts;
    }

    public static String URLDecoder(String name) throws UnsupportedEncodingException {
        return URLDecoder.decode(name, "UTF-8");
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    public static class RoutingContext {
        public final String hostName;
        public final String serverInstallDir;
        public final String serverUserDir;
        public final String serverName;
        static final long serialVersionUID = -1314477724594346763L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public RoutingContext(String hostName, String serverUserDir, String serverName) {
            this(hostName, null, serverUserDir, serverName);
        }

        public RoutingContext(String hostName, String serverInstallDir, String serverUserDir, String serverName) {
            this.hostName = hostName;
            this.serverInstallDir = serverInstallDir;
            this.serverUserDir = serverUserDir;
            this.serverName = serverName;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(RoutingContext.class);
        }
    }

    public static interface LegacyJMX {
        public static final String ROUTING_KEY_HOST_NAME = "com.ibm.websphere.jmx.connector.rest.routing.hostName";
        public static final String ROUTING_KEY_SERVER_NAME = "com.ibm.websphere.jmx.connector.rest.routing.serverName";
        public static final String ROUTING_KEY_SERVER_USER_DIR = "com.ibm.websphere.jmx.connector.rest.routing.serverUserDir";
    }
}

