/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.kernel.service.utils;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class MetatypeUtils {
    static final TraceComponent tc = Tr.register(MetatypeUtils.class);
    private static final Map<String, TimeUnit> UNIT_DESCRIPTORS;
    private static final Pattern INTERVAL_STRING;
    static final long serialVersionUID = 8087402808804967064L;

    public static boolean parseBoolean(Object configAlias, String propertyKey, Object obj, boolean defaultValue) {
        if (obj != null) {
            if (obj instanceof String) {
                String value = (String)obj;
                if (value.equalsIgnoreCase("true")) {
                    return true;
                }
                if (value.equalsIgnoreCase("false")) {
                    return false;
                }
                Tr.warning((TraceComponent)tc, (String)"invalidBoolean", (Object[])new Object[]{configAlias, propertyKey, obj});
                throw new IllegalArgumentException("Boolean value could not be parsed: key=" + propertyKey + ", value=" + obj);
            }
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            Tr.warning((TraceComponent)tc, (String)"invalidBoolean", (Object[])new Object[]{configAlias, propertyKey, obj});
            throw new IllegalArgumentException("Boolean value could not be parsed: key=" + propertyKey + ", value=" + obj);
        }
        return defaultValue;
    }

    @FFDCIgnore(value={Exception.class})
    public static String[] parseStringArray(Object configAlias, String propertyKey, Object obj, String[] defaultValue) {
        String[] emptyArray = new String[]{};
        if (obj != null) {
            try {
                if (obj instanceof String[]) {
                    return (String[])obj;
                }
                if (obj instanceof String) {
                    String commaList = (String)obj;
                    return commaList.split("\\s*,\\s*");
                }
                if (obj instanceof Collection) {
                    return ((Collection)obj).toArray(emptyArray);
                }
            }
            catch (Exception e) {
                Tr.warning((TraceComponent)tc, (String)"invalidStringArray", (Object[])new Object[]{configAlias, propertyKey, obj});
                throw new IllegalArgumentException("String array value could not be parsed: key=" + propertyKey + ", value=" + obj, e);
            }
            Tr.warning((TraceComponent)tc, (String)"invalidStringArray", (Object[])new Object[]{configAlias, propertyKey, obj});
            throw new IllegalArgumentException("String array value could not be parsed: key=" + propertyKey + ", value=" + obj);
        }
        return defaultValue;
    }

    @FFDCIgnore(value={Exception.class})
    public static Collection<String> parseStringCollection(Object configAlias, String propertyKey, Object obj, Collection<String> defaultValue) {
        if (obj != null) {
            try {
                if (obj instanceof Collection) {
                    return (Collection)obj;
                }
                if (obj instanceof String) {
                    String commaList = (String)obj;
                    return Arrays.asList(commaList.split("\\s*,\\s*"));
                }
                if (obj instanceof String[]) {
                    return Arrays.asList((String[])obj);
                }
            }
            catch (Exception e) {
                Tr.warning((TraceComponent)tc, (String)"invalidStringCollection", (Object[])new Object[]{configAlias, propertyKey, obj});
                throw new IllegalArgumentException("Collection of strings could not be parsed: key=" + propertyKey + ", value=" + obj, e);
            }
            Tr.warning((TraceComponent)tc, (String)"invalidStringCollection", (Object[])new Object[]{configAlias, propertyKey, obj});
            throw new IllegalArgumentException("Collection of strings could not be parsed: key=" + propertyKey + ", value=" + obj);
        }
        return defaultValue;
    }

    @FFDCIgnore(value={Exception.class})
    public static long parseLong(Object configAlias, String propertyKey, Object obj, long defaultValue) {
        if (obj != null) {
            try {
                if (obj instanceof String) {
                    return Long.parseLong((String)obj);
                }
                if (obj instanceof Short) {
                    return ((Short)obj).longValue();
                }
                if (obj instanceof Integer) {
                    return ((Integer)obj).longValue();
                }
                if (obj instanceof Long) {
                    return (Long)obj;
                }
            }
            catch (Exception e) {
                Tr.warning((TraceComponent)tc, (String)"invalidLong", (Object[])new Object[]{configAlias, propertyKey, obj});
                throw new IllegalArgumentException("Long value could not be parsed: key=" + propertyKey + ", value=" + obj, e);
            }
            Tr.warning((TraceComponent)tc, (String)"invalidLong", (Object[])new Object[]{configAlias, propertyKey, obj});
            throw new IllegalArgumentException("Long value could not be parsed: key=" + propertyKey + ", value=" + obj);
        }
        return defaultValue;
    }

    @FFDCIgnore(value={Exception.class})
    public static int parseInteger(Object configAlias, String propertyKey, Object obj, int defaultValue) {
        if (obj != null) {
            try {
                if (obj instanceof String) {
                    return Integer.parseInt((String)obj);
                }
                if (obj instanceof Short) {
                    return ((Short)obj).intValue();
                }
                if (obj instanceof Integer) {
                    return (Integer)obj;
                }
                if (obj instanceof Long) {
                    return ((Long)obj).intValue();
                }
            }
            catch (Exception e) {
                Tr.warning((TraceComponent)tc, (String)"invalidInteger", (Object[])new Object[]{configAlias, propertyKey, obj});
                throw new IllegalArgumentException("Integer value could not be parsed: key=" + propertyKey + ", value=" + obj, e);
            }
            Tr.warning((TraceComponent)tc, (String)"invalidInteger", (Object[])new Object[]{configAlias, propertyKey, obj});
            throw new IllegalArgumentException("Integer value could not be parsed: key=" + propertyKey + ", value=" + obj);
        }
        return defaultValue;
    }

    @FFDCIgnore(value={Exception.class})
    public static int[] parseIntegerArray(Object configAlias, String propertyKey, Object obj, int[] defaultValue) {
        if (obj != null) {
            try {
                if (obj instanceof int[]) {
                    return (int[])obj;
                }
                if (obj instanceof String) {
                    String commaList = (String)((Object)obj);
                    obj = Arrays.asList(commaList.split("\\s*,\\s*"));
                }
                if (obj instanceof Collection) {
                    Collection c = obj;
                    int[] newArray = new int[c.size()];
                    int i = 0;
                    for (Object o2 : c) {
                        if (o2 instanceof String) {
                            newArray[i] = Integer.parseInt((String)o2);
                        } else if (o2 instanceof Short) {
                            newArray[i] = ((Short)o2).intValue();
                        } else if (o2 instanceof Integer) {
                            newArray[i] = (Integer)o2;
                        } else if (o2 instanceof Long) {
                            newArray[i] = ((Long)o2).intValue();
                        }
                        ++i;
                    }
                    return newArray;
                }
            }
            catch (Exception e) {
                Tr.warning((TraceComponent)tc, (String)"invalidIntegerArray", (Object[])new Object[]{configAlias, propertyKey, obj});
                throw new IllegalArgumentException("Integer array value could not be parsed: key=" + propertyKey + ", value=" + obj, e);
            }
            Tr.warning((TraceComponent)tc, (String)"invalidIntegerArray", (Object[])new Object[]{configAlias, propertyKey, obj});
            throw new IllegalArgumentException("Integer array value could not be parsed: key=" + propertyKey + ", value=" + obj);
        }
        return defaultValue;
    }

    public static long parseDuration(Object configAlias, String propertyKey, Object obj, long defaultValue) {
        return MetatypeUtils.parseDuration(configAlias, propertyKey, obj, defaultValue, TimeUnit.MILLISECONDS);
    }

    @FFDCIgnore(value={Exception.class})
    public static long parseDuration(Object configAlias, String propertyKey, Object obj, long defaultValue, TimeUnit units) {
        if (obj != null) {
            try {
                if (obj instanceof String) {
                    return MetatypeUtils.evaluateDuration((String)obj, units);
                }
                if (obj instanceof Long) {
                    return (Long)obj;
                }
            }
            catch (Exception e) {
                Tr.warning((TraceComponent)tc, (String)"invalidDuration", (Object[])new Object[]{configAlias, propertyKey, obj});
                throw new IllegalArgumentException("Duration value could not be parsed: key=" + propertyKey + ", value=" + obj, e);
            }
            Tr.warning((TraceComponent)tc, (String)"invalidDuration", (Object[])new Object[]{configAlias, propertyKey, obj});
            throw new IllegalArgumentException("Duration value could not be parsed: key=" + propertyKey + ", value=" + obj);
        }
        return defaultValue;
    }

    @FFDCIgnore(value={NumberFormatException.class})
    public static Long evaluateDuration(String strVal, TimeUnit endUnit) {
        try {
            return Long.valueOf(strVal);
        }
        catch (NumberFormatException numberFormatException) {
            return MetatypeUtils.evaluateDuration(strVal, endUnit, UNIT_DESCRIPTORS);
        }
    }

    private static Long evaluateDuration(String strVal, TimeUnit endUnit, Map<String, TimeUnit> unitDescriptors) {
        Matcher m = INTERVAL_STRING.matcher(strVal);
        long retVal = 0L;
        boolean somethingParsed = false;
        while (m.find()) {
            somethingParsed = true;
            Long numberVal = Long.valueOf(m.group(1));
            String unitStr = m.group(2);
            if (unitStr == null) {
                throw new IllegalArgumentException("Could not parse configuration value as a duration: " + strVal);
            }
            TimeUnit sourceUnit = unitDescriptors.get(unitStr.trim().toLowerCase());
            if (sourceUnit == null) {
                throw new IllegalArgumentException("Could not parse configuration value as a duration: " + strVal);
            }
            retVal += endUnit.convert(numberVal, sourceUnit);
        }
        if (!somethingParsed) {
            throw new IllegalArgumentException("Could not parse configuration value as a duration: " + strVal);
        }
        return retVal;
    }

    public static String evaluateToken(String strVal) {
        return strVal == null ? null : MetatypeUtils.collapseWhitespace(strVal);
    }

    @Trivial
    private static boolean isSpace(char ch) {
        return ch == ' ' || ch == '\n' || ch == '\r' || ch == '\t';
    }

    @Trivial
    private static String collapseWhitespace(String value) {
        int length = value.length();
        for (int i = 0; i < length; ++i) {
            if (!MetatypeUtils.isSpace(value.charAt(i))) continue;
            return MetatypeUtils.collapse0(value, i, length);
        }
        return value;
    }

    @Trivial
    private static String collapse0(String value, int i, int length) {
        char c;
        StringBuilder sb = null;
        boolean needToWriteSpace = false;
        if (i > 0) {
            needToWriteSpace = true;
            sb = new StringBuilder();
            sb.append(value, 0, i);
        } else {
            while (++i < length) {
                c = value.charAt(i);
                if (MetatypeUtils.isSpace(c)) continue;
                sb = new StringBuilder();
                sb.append(c);
                break;
            }
            if (i == length) {
                return "";
            }
        }
        while (++i < length) {
            c = value.charAt(i);
            if (!MetatypeUtils.isSpace(c)) {
                if (needToWriteSpace) {
                    sb.append(' ');
                    needToWriteSpace = false;
                }
                sb.append(c);
                continue;
            }
            needToWriteSpace = true;
        }
        return sb.toString();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        HashMap<String, TimeUnit> units = new HashMap<String, TimeUnit>();
        units.put("d", TimeUnit.DAYS);
        units.put("dn\u016f", TimeUnit.DAYS);
        units.put("g", TimeUnit.DAYS);
        units.put("j", TimeUnit.DAYS);
        units.put("n", TimeUnit.DAYS);
        units.put("t", TimeUnit.DAYS);
        units.put("z", TimeUnit.DAYS);
        units.put("\u0434", TimeUnit.DAYS);
        units.put("\u5929", TimeUnit.DAYS);
        units.put("h", TimeUnit.HOURS);
        units.put("hod", TimeUnit.HOURS);
        units.put("\u00f3", TimeUnit.HOURS);
        units.put("\u0447", TimeUnit.HOURS);
        units.put("\u5c0f\u6642", TimeUnit.HOURS);
        units.put("m", TimeUnit.MINUTES);
        units.put("min", TimeUnit.MINUTES);
        units.put("\u043c", TimeUnit.MINUTES);
        units.put("\u5206", TimeUnit.MINUTES);
        units.put("e", TimeUnit.SECONDS);
        units.put("mp", TimeUnit.SECONDS);
        units.put("s", TimeUnit.SECONDS);
        units.put("\u0441", TimeUnit.SECONDS);
        units.put("\u79d2", TimeUnit.SECONDS);
        units.put("ms", TimeUnit.MILLISECONDS);
        units.put("\u043c\u0441", TimeUnit.MILLISECONDS);
        units.put("\u6beb\u79d2", TimeUnit.MILLISECONDS);
        UNIT_DESCRIPTORS = Collections.unmodifiableMap(units);
        INTERVAL_STRING = Pattern.compile("(\\d+)(\\D+)");
    }
}

