/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.logging.hpel.reader;

import com.ibm.websphere.logging.hpel.reader.HpelFormatter;
import com.ibm.websphere.logging.hpel.reader.HpelPlainFormatter;
import com.ibm.websphere.logging.hpel.reader.RepositoryLogRecord;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public class HpelJsonFormatter
extends HpelPlainFormatter {
    private long headerDatetime = 0L;
    private final AtomicLong seq = new AtomicLong();

    @Override
    public String formatRecord(RepositoryLogRecord record, Locale locale) {
        SimpleDateFormat dateFormatGmt = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        String loggerName = record.getLoggerName();
        String methodName = record.getSourceMethodName();
        String message = record.getFormattedMessage();
        if (record.getStackTrace() != null) {
            message = message.concat("\n");
            message = message.concat(record.getStackTrace());
        }
        String className = record.getSourceClassName();
        String logLevel = HpelJsonFormatter.mapLevelToType(record);
        long date = record.getMillis();
        String datetime = dateFormatGmt.format(date);
        String sequence = date + "_" + String.format("%013X", this.seq.incrementAndGet());
        String messageID = record.getMessageID();
        String logType = null;
        StringBuilder threadSB = new StringBuilder();
        Map<String, String> extensions = record.getExtensions();
        HpelJsonFormatter.formatThreadID(record, threadSB);
        String threadID = threadSB.toString();
        Object[] parms = record.getParameters();
        String rawMessage = record.getRawMessage();
        return HpelJsonFormatter.jsonify(loggerName, methodName, message, className, logLevel, datetime, messageID, threadID, sequence, extensions, logType, rawMessage, parms);
    }

    private static String jsonify(String loggerName, String methodName, String message, String className, String level, String datetime, String messageID, String threadID, String sequence, Map<String, String> extensions, String logType, String rawMessage, Object[] parms) {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        boolean isFirstField = true;
        isFirstField &= !HpelJsonFormatter.addToJSON(sb, "className", className, false, false, false, isFirstField &= !HpelJsonFormatter.addToJSON(sb, "methodName", methodName, false, false, false, isFirstField &= !HpelJsonFormatter.addToJSON(sb, "loggerName", loggerName, false, false, false, isFirstField &= !HpelJsonFormatter.addToJSON(sb, "sequence", sequence, false, false, false, isFirstField &= !HpelJsonFormatter.addToJSON(sb, "messageId", messageID, false, false, false, isFirstField &= !HpelJsonFormatter.addToJSON(sb, "severity", level, false, false, true, isFirstField &= !HpelJsonFormatter.addToJSON(sb, "message", message, false, true, false, isFirstField &= !HpelJsonFormatter.addToJSON(sb, "threadId", threadID, false, false, true, isFirstField &= !HpelJsonFormatter.addToJSON(sb, "datetime", datetime, false, false, false, isFirstField)))))))));
        if (rawMessage != null && rawMessage.equals(message) && parms != null) {
            isFirstField &= !HpelJsonFormatter.addListToJSON(sb, "unusedParms", parms, true, isFirstField);
        }
        if (extensions != null) {
            for (Map.Entry<String, String> entry : extensions.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (key == null || value == null) continue;
                isFirstField &= !HpelJsonFormatter.addToJSON(sb, key, value, true, true, true, isFirstField);
            }
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    protected String appendUnusedParms(String message, Object[] args) {
        return "";
    }

    @Override
    public String getFooter() {
        return "";
    }

    private static String jsonEscape2(String s) {
        String r = s;
        r = r.replace("\\", "\\\\");
        r = r.replace("\"", "\\\"");
        r = r.replace("/", "\\/");
        r = r.replace("\b", "\\b");
        r = r.replace("\f", "\\f");
        r = r.replace("\n", "\\n");
        r = r.replace("\r", "\\r");
        r = r.replace("\t", "\\t");
        r = r.replace("_", "\\u005f");
        return r;
    }

    static boolean addToJSON(StringBuilder sb, String name, String value, boolean jsonEscapeName, boolean jsonEscapeValue, boolean trim, boolean isFirstField) {
        if (name == null || value == null) {
            return false;
        }
        if (!isFirstField) {
            sb.append(",");
        }
        if (trim) {
            value = value.trim();
        }
        if (jsonEscapeValue) {
            value = HpelJsonFormatter.jsonEscape2(value);
        }
        if (jsonEscapeName) {
            name = HpelJsonFormatter.jsonEscape2(name);
        }
        sb.append("\"" + name + "\":\"").append(value).append("\"");
        return true;
    }

    static boolean addListToJSON(StringBuilder sb, String name, Object[] list, boolean jsonEscapeValues, boolean isFirstField) {
        if (name == null || list == null) {
            return false;
        }
        if (!isFirstField) {
            sb.append(",");
        }
        sb.append("\"" + name + "\":[");
        boolean firstParm = true;
        for (Object element : list) {
            if (firstParm) {
                sb.append("\"");
            } else {
                sb.append(",\"");
            }
            if (element != null) {
                if (jsonEscapeValues) {
                    sb.append(HpelJsonFormatter.jsonEscape2(element.toString()));
                } else {
                    sb.append(element.toString());
                }
            }
            sb.append("\"");
            firstParm = false;
        }
        sb.append("]");
        return true;
    }

    @Override
    public String[] getHeader() {
        StringBuilder result = new StringBuilder();
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        if (this.customHeader.length > 0) {
            for (HpelFormatter.CustomHeaderLine line : this.customHeader) {
                String formattedLine = line.formatLine(this.headerProps);
                if (!first && formattedLine != null) {
                    result.append("\n");
                }
                if (formattedLine != null) {
                    result.append(formattedLine);
                }
                first = false;
            }
        } else {
            for (String prop : this.headerProps.stringPropertyNames()) {
                if (!first) {
                    result.append("\n");
                }
                result.append(prop + " = " + this.headerProps.getProperty(prop));
                first = false;
            }
        }
        boolean isFirstField = true;
        SimpleDateFormat dateFormatGmt = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        String sequence = this.headerDatetime + "_" + String.format("%013X", this.seq.incrementAndGet());
        String headerDateTime = dateFormatGmt.format(this.headerDatetime);
        sb.append("{");
        isFirstField &= !HpelJsonFormatter.addToJSON(sb, "message", result.toString(), false, true, true, isFirstField &= !HpelJsonFormatter.addToJSON(sb, "sequence", sequence, false, false, false, isFirstField &= !HpelJsonFormatter.addToJSON(sb, "datetime", headerDateTime, false, false, true, isFirstField)));
        sb.append("}");
        String[] s = new String[]{sb.toString()};
        return s;
    }

    @Override
    public void setStartDatetime(long datetime) {
        this.headerDatetime = datetime;
    }
}

