/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ras.instrument.internal.model;

import com.ibm.ws.ras.instrument.internal.model.FieldInfo;
import com.ibm.ws.ras.instrument.internal.model.MethodInfo;
import com.ibm.ws.ras.instrument.internal.model.PackageInfo;
import com.ibm.ws.ras.instrument.internal.model.TraceOptionsData;
import java.util.LinkedHashSet;
import java.util.Set;
import org.objectweb.asm.Type;

public class ClassInfo {
    private final String className;
    private final String internalClassName;
    private final String baseName;
    private final String packageName;
    private final String internalPackageName;
    private boolean sensitive;
    private boolean trivial;
    private TraceOptionsData traceOptionsData;
    private Set<FieldInfo> fields = new LinkedHashSet<FieldInfo>();
    private Set<MethodInfo> methods = new LinkedHashSet<MethodInfo>();

    public ClassInfo(String className) {
        this.className = className.replaceAll("/", "\\.");
        this.internalClassName = className.replaceAll("\\.", "/");
        this.baseName = this.internalClassName.replaceAll("^.*/", "");
        this.packageName = this.className.replaceAll("\\.[^\\.]+$", "");
        this.internalPackageName = this.internalClassName.replaceAll("/[^/]+$", "");
    }

    public boolean isSensitive() {
        return this.sensitive;
    }

    public void setSensitive(boolean sensitive) {
        this.sensitive = sensitive;
    }

    public boolean isTrivial() {
        return this.trivial;
    }

    public void setTrivial(boolean trivial) {
        this.trivial = trivial;
    }

    public TraceOptionsData getTraceOptionsData() {
        return this.traceOptionsData;
    }

    public void setTraceOptionsData(TraceOptionsData traceOptionsData) {
        this.traceOptionsData = traceOptionsData;
    }

    public String getBaseName() {
        return this.baseName;
    }

    public String getClassName() {
        return this.className;
    }

    public String getInternalClassName() {
        return this.internalClassName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getInternalPackageName() {
        return this.internalPackageName;
    }

    public Set<FieldInfo> getFieldInfoSet() {
        return this.fields;
    }

    public void addFieldInfo(FieldInfo fieldInfo) {
        this.fields.add(fieldInfo);
    }

    public FieldInfo getDeclaredLoggerField() {
        for (FieldInfo fi : this.fields) {
            if (!fi.isLoggerField()) continue;
            return fi;
        }
        return null;
    }

    public FieldInfo getDeclaredFieldByName(String name) {
        for (FieldInfo fi : this.fields) {
            if (!fi.getFieldName().equals(name)) continue;
            return fi;
        }
        return null;
    }

    public Set<FieldInfo> getDeclaredFieldsByType(Type fieldType) {
        LinkedHashSet<FieldInfo> fieldSet = new LinkedHashSet<FieldInfo>();
        for (FieldInfo fi : this.fields) {
            if (!fi.getFieldDescriptor().equals(fieldType.getDescriptor())) continue;
            fieldSet.add(fi);
        }
        return fieldSet;
    }

    public Set<MethodInfo> getMethodInfoSet() {
        return this.methods;
    }

    public void addMethodInfo(MethodInfo methodInfo) {
        this.methods.add(methodInfo);
    }

    public Set<MethodInfo> getDeclaredMethodsByName(String name) {
        LinkedHashSet<MethodInfo> methodSet = new LinkedHashSet<MethodInfo>();
        for (MethodInfo mi : this.methods) {
            if (!mi.getMethodName().equals(name)) continue;
            methodSet.add(mi);
        }
        return methodSet;
    }

    public MethodInfo getDeclaredMethod(String name, String descriptor) {
        for (MethodInfo mi : this.getDeclaredMethodsByName(name)) {
            if (!mi.getMethodDescriptor().equals(descriptor)) continue;
            return mi;
        }
        return null;
    }

    public void updateDefaultValuesFromPackageInfo(PackageInfo packageInfo) {
        if (!this.trivial && packageInfo != null) {
            this.trivial = packageInfo.isTrivial();
        }
        if (this.traceOptionsData == null) {
            this.traceOptionsData = packageInfo != null ? packageInfo.getTraceOptionsData() : new TraceOptionsData();
        }
        for (FieldInfo fi : this.fields) {
            fi.updateDefaultValuesFromClassInfo(this);
        }
        for (MethodInfo mi : this.methods) {
            mi.updateDefaultValuesFromClassInfo(this);
        }
    }

    public void overrideValuesFromExplicitClassInfo(ClassInfo ci) {
        TraceOptionsData optionsData;
        if (ci.isSensitive()) {
            this.setSensitive(true);
        }
        if (ci.isTrivial()) {
            this.setTrivial(true);
        }
        if ((optionsData = ci.getTraceOptionsData()) != null) {
            this.setTraceOptionsData(optionsData);
        }
        for (FieldInfo fi : ci.fields) {
            FieldInfo field = this.getDeclaredFieldByName(fi.getFieldName());
            if (field == null || !field.getFieldDescriptor().equals(fi.getFieldDescriptor())) continue;
            this.fields.remove(field);
            this.fields.add(fi);
        }
        for (MethodInfo mi : ci.methods) {
            MethodInfo method = this.getDeclaredMethod(mi.getMethodName(), mi.getMethodDescriptor());
            if (method == null) continue;
            this.methods.remove(method);
            this.methods.add(mi);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append(";className=").append(this.className);
        sb.append(",internalClassName=").append(this.internalClassName);
        sb.append(",baseName=").append(this.baseName);
        sb.append(",sensitive=").append(this.sensitive);
        sb.append(",trivial=").append(this.trivial);
        sb.append(",traceOptionsData=").append(this.traceOptionsData);
        sb.append(",fields=").append(this.fields);
        sb.append(",methods=").append(this.methods);
        return sb.toString();
    }
}

