/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache.web.command;

import com.ibm.websphere.command.CacheableCommand;
import com.ibm.websphere.command.CacheableCommandImpl;
import com.ibm.ws.cache.EntryInfo;
import com.ibm.ws.cache.command.CommandStoragePolicy;
import com.ibm.ws.cache.intf.DCache;
import com.ibm.ws.cache.util.ObjectSizer;
import com.ibm.ws.cache.util.SerializationUtility;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.Serializable;

public class SerializedCommandStorage
implements CommandStoragePolicy {
    private static final long serialVersionUID = 3990461887543683654L;

    @Override
    public Serializable prepareForCache(CacheableCommand command) {
        try {
            byte[] b = SerializationUtility.serialize((Serializable)command);
            this.setObjectSize(command, b);
            return b;
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.cache.command.SerializedCommandStorage.prepareForCache", (String)"42", (Object)this);
            throw new IllegalStateException("serialization exception");
        }
    }

    @Override
    public CacheableCommand prepareForCacheAccess(Serializable inputObject, DCache cache, EntryInfo ei) {
        if (inputObject == null) {
            return null;
        }
        if (!(inputObject instanceof byte[])) {
            throw new IllegalStateException("inputObject is of type: " + inputObject.getClass());
        }
        byte[] array = (byte[])inputObject;
        Serializable outputObject = null;
        try {
            outputObject = SerializationUtility.deserialize((byte[])array, (String)cache.getCacheName());
            CacheableCommand cc = (CacheableCommand)outputObject;
            this.setObjectSize(cc, array);
            return cc;
        }
        catch (ClassCastException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.cache.command.SerializedCommandStorage.prepareForCacheAccess", (String)"80", (Object)this);
            throw new IllegalStateException("deserialized object is of type " + outputObject.getClass());
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.cache.command.SerializedCommandStorage.prepareForCacheAccess", (String)"84", (Object)this);
            if (cache.getCacheConfig().isIgnoreCacheableCommandDeserializationException()) {
                return null;
            }
            throw new IllegalStateException("deserialization exception");
        }
    }

    private void setObjectSize(CacheableCommand command, byte[] b) {
        if (command instanceof CacheableCommandImpl) {
            ((CacheableCommandImpl)command).setObjectSize(ObjectSizer.getSize((Object)b));
        }
    }
}

