/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.internal.classloader;

import com.ibm.ws.kernel.internal.classloader.DirectoryResourceEntry;
import com.ibm.ws.kernel.internal.classloader.JarFileClassLoader;
import com.ibm.ws.kernel.internal.classloader.ResourceEntry;
import com.ibm.ws.kernel.internal.classloader.ResourceHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.jar.Manifest;

public class DirectoryResourceHandler
implements ResourceHandler {
    private final File directory;
    private final String directoryPath;
    private URL url;
    private boolean manifestLoaded;
    private Manifest manifest;

    public DirectoryResourceHandler(File directory) {
        this.directory = directory;
        this.directoryPath = DirectoryResourceHandler.getCanonicalPath(directory);
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public ResourceEntry getEntry(String name) {
        File file = new File(this.directory, name);
        if (file.exists() && DirectoryResourceHandler.getCanonicalPath(file).startsWith(this.directoryPath)) {
            return new DirectoryResourceEntry(this, file);
        }
        return null;
    }

    @Override
    public URL toURL() {
        if (this.url == null) {
            this.url = JarFileClassLoader.toURL(this.directory);
        }
        return this.url;
    }

    @Override
    public Manifest getManifest() throws IOException {
        if (!this.manifestLoaded) {
            File file = new File(this.directory, "META-INF/MANIFEST.MF");
            if (file.exists()) {
                FileInputStream in = null;
                try {
                    in = new FileInputStream(file);
                    this.manifest = new Manifest(in);
                }
                catch (Throwable throwable) {
                    JarFileClassLoader.close(in);
                    throw throwable;
                }
                JarFileClassLoader.close(in);
            }
            this.manifestLoaded = true;
        }
        return this.manifest;
    }

    private static String getCanonicalPath(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }
}

