/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.collective.routing.member.internal;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.collective.routing.member.key.WebModuleKey;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.webcontainer.webapp.WebAppConfiguration;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.webcontainer.metadata.WebModuleMetaData;
import com.ibm.wsspi.webcontainer.webapp.WebAppConfig;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.SessionCookieConfig;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class WebModuleRoutingInfo {
    private static final TraceComponent tc = Tr.register(WebModuleRoutingInfo.class, (String)"Collective", (String)"com.ibm.ws.collective.routing.member.internal.resources.RoutingMemberMessages");
    public static final String DIGESTVERSION_KEY = "version";
    public static final String MODULEDIGEST_KEY = "digest";
    public static final String MODULENAME_KEY = "moduleName";
    public static final String MODULEATTRIBUTES_KEY = "attributes";
    public static final String CONTEXTROOT_KEY = "ContextRoot";
    public static final String FILESERVINGENABLED_KEY = "FileServingEnabled";
    public static final String SESSIONAFFINITYCOOKIE_KEY = "SessionAffinityCookie";
    public static final String SERVLETMAPPINGS_KEY = "ServletMappings";
    public static final String VIRTUALHOST_KEY = "vhost";
    public static final String TYPE_KEY = "type";
    public static final String PROPS_KEY = "props";
    public static final String URI_TYPE_VALUE = "uri";
    public static final String URI_NAME_KEY = "name";
    public static final String URI_PREFIX = "/uri/";
    public static final String VHOST_HOST_KEY = "host";
    public static final String VHOST_PORT_KEY = "port";
    public static final String VHOST_NAME_KEY = "name";
    public static final String VHOST_TYPE_VALUE = "vHost";
    public static final String VHOST_PREFIX = "/vHost/";
    J2EEName j2eeName;
    private String contextRoot = null;
    private Boolean fileServingEnabled = true;
    private Boolean serveServletsByClassname = false;
    private String sessionAffinityCookie = null;
    private Map<String, List<String>> servletMappings = null;
    private String virtualHostName = null;
    private JSONArray jsonRepresentation;
    static final long serialVersionUID = 6870224412756025865L;

    public String toString() {
        return this.getJsonRepresentation().toString();
    }

    @Trivial
    public String getContextRoot() {
        return this.contextRoot;
    }

    @Trivial
    public Boolean getFileServingEnabled() {
        return this.fileServingEnabled;
    }

    @Trivial
    public String getSessionAffinityCookie() {
        return this.sessionAffinityCookie;
    }

    @Trivial
    public Map<String, List<String>> getServletMappings() {
        return this.servletMappings;
    }

    @Trivial
    public String getVirtualHostName() {
        return this.virtualHostName;
    }

    @Trivial
    public JSONArray getJsonRepresentation() {
        return this.jsonRepresentation;
    }

    public WebModuleRoutingInfo(WebModuleMetaData wmmd, Container container, Map<String, Collection<String>> virtualHosts) {
        this.j2eeName = wmmd.getJ2EEName();
        this.fillAttributes(wmmd, container, virtualHosts);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Created  WebModuleRoutingInfo for " + this.j2eeName), (Object[])new Object[0]);
        }
    }

    protected void update(WebModuleMetaData wmmd, Container container, Map<String, Collection<String>> virtualHosts) {
        this.fillAttributes(wmmd, container, virtualHosts);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Updated WebModuleRoutingInfo for " + this.j2eeName), (Object[])new Object[0]);
        }
    }

    protected void updateVhosts(Map<String, Collection<String>> virtualHosts) {
        this.createJSON(virtualHosts);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Updated WebModuleRoutingInfo Virtual hosts for " + this.j2eeName), (Object[])new Object[0]);
        }
    }

    private void fillAttributes(WebModuleMetaData wmmd, Container container, Map<String, Collection<String>> virtualHosts) {
        WebAppConfig wac = wmmd.getConfiguration();
        if (null != wac) {
            this.contextRoot = wac.getContextRoot();
            this.virtualHostName = wac.getVirtualHostName();
            this.servletMappings = wac.getServletMappings();
            if (wac instanceof WebAppConfiguration) {
                SessionCookieConfig scc = ((WebAppConfiguration)wac).getSessionCookieConfig();
                if (scc != null) {
                    this.sessionAffinityCookie = scc.getName();
                } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"sessonAffinityCookie is null.", (Object[])new Object[0]);
                }
                this.fileServingEnabled = ((WebAppConfiguration)wac).isFileServingEnabled();
                this.serveServletsByClassname = ((WebAppConfiguration)wac).isServeServletsByClassnameEnabled();
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"The WebAppConfig (wac) is not an instanceof WebAppConfiguration", (Object[])new Object[0]);
                }
                this.fileServingEnabled = true;
                this.serveServletsByClassname = false;
                this.sessionAffinityCookie = null;
            }
        }
        this.createJSON(virtualHosts);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("WebModuleRoutingInfo attributes are: " + this.getAttributesAsString()), (Object[])new Object[0]);
        }
    }

    private String getAttributesAsString() {
        String attributes = "Context Root: " + this.contextRoot;
        attributes = attributes.concat("; Virtual Host Name: " + this.virtualHostName);
        attributes = attributes.concat("; ServletMappings: " + this.servletMappings.toString());
        attributes = attributes.concat("; Session Affinity Cookie: " + this.sessionAffinityCookie);
        attributes = attributes.concat("; File Serving Enabled: " + this.fileServingEnabled.toString());
        attributes = attributes.concat("; Serve Servelets By Classname: " + this.serveServletsByClassname.toString());
        return attributes;
    }

    private void createJSON(Map<String, Collection<String>> virtualHosts) {
        this.jsonRepresentation = new JSONArray();
        JSONArray vhosts = this.getVirtualHosts(virtualHosts);
        if (null != vhosts) {
            JSONArray objects = this.getServletMappings(this.servletMappings);
            for (int i = 0; i < vhosts.size(); ++i) {
                JSONObject vhost = (JSONObject)vhosts.get(i);
                JSONObject moduleAttributes = new JSONObject();
                moduleAttributes.put((Object)VIRTUALHOST_KEY, (Object)vhost);
                moduleAttributes.put((Object)CONTEXTROOT_KEY, (Object)this.contextRoot);
                moduleAttributes.put((Object)SERVLETMAPPINGS_KEY, (Object)objects);
                moduleAttributes.put((Object)FILESERVINGENABLED_KEY, (Object)this.fileServingEnabled);
                moduleAttributes.put((Object)SESSIONAFFINITYCOOKIE_KEY, (Object)this.sessionAffinityCookie);
                String attribDigest = WebModuleKey.calculateDigest(this.j2eeName.getModule().toString(), moduleAttributes);
                JSONObject webModuleObject = new JSONObject();
                webModuleObject.put((Object)MODULENAME_KEY, (Object)this.j2eeName.getModule().toString());
                webModuleObject.put((Object)MODULEDIGEST_KEY, (Object)attribDigest);
                webModuleObject.put((Object)MODULEATTRIBUTES_KEY, (Object)moduleAttributes);
                webModuleObject.put((Object)DIGESTVERSION_KEY, (Object)">=8.5.5.9");
                this.jsonRepresentation.add((Object)webModuleObject);
            }
        }
    }

    private JSONArray getServletMappings(Map<String, List<String>> servletMappings) {
        JSONObject uri;
        JSONArray objects = new JSONArray();
        boolean hasFullWildcard = false;
        boolean hasServletByClassname = false;
        for (List<String> values : servletMappings.values()) {
            for (String value : values) {
                JSONObject uri2 = new JSONObject();
                String normalizedURI = this.normalizeURI(value);
                uri2.put((Object)"name", (Object)(URI_PREFIX + normalizedURI.replaceAll("/", "\\\\/")));
                uri2.put((Object)TYPE_KEY, (Object)URI_TYPE_VALUE);
                objects.add((Object)uri2);
                if ("/*".equals(normalizedURI)) {
                    hasFullWildcard = true;
                }
                if (!"/servlet/*".equals(normalizedURI)) continue;
                hasServletByClassname = true;
            }
        }
        if (this.fileServingEnabled.booleanValue() && !hasFullWildcard) {
            uri = new JSONObject();
            uri.put((Object)"name", (Object)"/uri/\\/*");
            uri.put((Object)TYPE_KEY, (Object)URI_TYPE_VALUE);
            objects.add((Object)uri);
        }
        if (this.serveServletsByClassname.booleanValue() && !hasServletByClassname) {
            uri = new JSONObject();
            uri.put((Object)"name", (Object)"/uri/\\/servlet\\/*");
            uri.put((Object)TYPE_KEY, (Object)URI_TYPE_VALUE);
            objects.add((Object)uri);
        }
        return objects;
    }

    private String normalizeURI(String uri) {
        if (uri == null) {
            uri = "/";
        }
        if (!uri.startsWith("*") && !uri.startsWith("/")) {
            uri = "/" + uri;
        }
        return uri;
    }

    private JSONArray getVirtualHosts(Map<String, Collection<String>> virtualHosts) {
        Collection<String> aliases = virtualHosts.get(this.getVirtualHostName());
        JSONArray vHosts = null;
        if (aliases != null) {
            vHosts = new JSONArray();
            for (String hostport : aliases) {
                JSONObject vhost = this.buildVHostJSON(hostport);
                if (hostport.equals("*:-1")) {
                    vHosts.clear();
                    vHosts.add((Object)vhost);
                    break;
                }
                vHosts.add((Object)vhost);
            }
        }
        return vHosts;
    }

    private JSONObject buildVHostJSON(String hostport) {
        JSONObject vhost = new JSONObject();
        String host = hostport.substring(0, hostport.lastIndexOf(":"));
        String port = hostport.substring(hostport.lastIndexOf(":") + 1);
        JSONObject props = new JSONObject();
        if (!"*".equals(host)) {
            props.put((Object)VHOST_HOST_KEY, (Object)host);
        }
        props.put((Object)VHOST_PORT_KEY, (Object)Long.valueOf(port));
        vhost.put((Object)"name", (Object)(VHOST_PREFIX + hostport));
        vhost.put((Object)PROPS_KEY, (Object)props);
        vhost.put((Object)TYPE_KEY, (Object)VHOST_TYPE_VALUE);
        return vhost;
    }
}

