/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.wim;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.wim.PropertyManager;
import com.ibm.ws.security.wim.RepositoryPropertyMap;
import com.ibm.ws.security.wim.xpath.util.MetadataMapper;
import com.ibm.wsspi.security.wim.exception.WIMException;
import com.ibm.wsspi.security.wim.model.Entity;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ProfileManagerMetadataMapper
implements MetadataMapper {
    private List<String> entityTypes = null;
    RepositoryPropertyMap laPropertyNames = null;
    RepositoryPropertyMap reposPropertyNames = null;
    static final long serialVersionUID = 3493071404385935673L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public ProfileManagerMetadataMapper(String reposId, List<String> entityTypes) throws WIMException {
        this.entityTypes = entityTypes;
        PropertyManager propMgr = PropertyManager.singleton();
        this.laPropertyNames = propMgr.getLookAsidePropertyNameMap();
        this.reposPropertyNames = propMgr.getPropertyMapByRepositoryId(reposId);
    }

    @Override
    public boolean isPropertyInLookAside(String propertyName, String entityType) {
        boolean inRepository = false;
        if (this.laPropertyNames != null && propertyName != null) {
            Set<String> propertyNames = this.laPropertyNames.getRepositoryPropertySetByEntityType(entityType);
            if (propertyNames != null) {
                inRepository = propertyNames.contains(propertyName);
            } else {
                try {
                    HashSet subEntTypes = Entity.getSubEntityTypes((String)entityType);
                    if (subEntTypes != null) {
                        Iterator iter = subEntTypes.iterator();
                        while (iter.hasNext() && !inRepository) {
                            propertyNames = this.laPropertyNames.getRepositoryPropertySetByEntityType((String)iter.next());
                            if (propertyNames == null) continue;
                            inRepository = propertyNames.contains(propertyName);
                        }
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.wim.ProfileManagerMetadataMapper", (String)"56", (Object)this, (Object[])new Object[]{propertyName, entityType});
                }
            }
        }
        return inRepository;
    }

    @Override
    public boolean isPropertyInRepository(String propertyName, String entityType) {
        boolean inRepository = false;
        if (this.reposPropertyNames != null && propertyName != null) {
            Set<String> propertyNames = this.reposPropertyNames.getRepositoryPropertySetByEntityType(entityType);
            if (propertyNames != null) {
                inRepository = propertyNames.contains(propertyName);
            } else {
                try {
                    HashSet subEntTypes = Entity.getSubEntityTypes((String)entityType);
                    if (subEntTypes != null) {
                        Iterator iter = subEntTypes.iterator();
                        while (iter.hasNext() && !inRepository) {
                            propertyNames = this.reposPropertyNames.getRepositoryPropertySetByEntityType((String)iter.next());
                            if (propertyNames == null) continue;
                            inRepository = propertyNames.contains(propertyName);
                        }
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.wim.ProfileManagerMetadataMapper", (String)"82", (Object)this, (Object[])new Object[]{propertyName, entityType});
                }
            }
        }
        return inRepository;
    }

    @Override
    public boolean isValidEntityType(String entityType) {
        boolean valid = false;
        if (this.entityTypes != null && entityType != null && entityType.length() != 0) {
            valid = this.entityTypes.contains(entityType);
        }
        return valid;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.wim.ProfileManagerMetadataMapper", ProfileManagerMetadataMapper.class, (String)"wimUtil", (String)"com.ibm.ws.security.wim.util.resources.WimUtilMessages");
    }
}

