/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.crmf;

import com.ibm.security.cmputil.CMPDerObject;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.GeneralName;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;

public final class SinglePubInfo
extends CMPDerObject {
    private int pubMethod;
    private GeneralName pubLocation;
    private static final String DONT_CARE_STRING = "dontCare";
    private static final String X500_STRING = "x500";
    private static final String WEB_STRING = "web";
    private static final String LDAP_STRING = "ldap";
    private static final String[] PubMethods = new String[]{"dontCare", "x500", "web", "ldap"};
    public static final int DONT_CARE = 0;
    public static final int X500 = 1;
    public static final int WEB = 2;
    public static final int LDAP = 3;

    public SinglePubInfo() {
        this.pubMethod = 0;
    }

    public SinglePubInfo(int n2, GeneralName generalName) {
        if (n2 < 0 || n2 > 3) {
            throw new IllegalArgumentException("SinglePubInfo error: invalid publication method " + n2);
        }
        this.pubMethod = n2;
        this.pubLocation = generalName;
    }

    public SinglePubInfo(byte[] byArray) throws IOException {
        super(byArray);
    }

    public Object clone() {
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            this.encode(derOutputStream);
            return new SinglePubInfo(derOutputStream.toByteArray());
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void decode(DerValue derValue) throws IOException {
        if (derValue.getTag() != 48) {
            throw new IOException("SinglePubInfo parsing error");
        }
        if (derValue.getData().available() == 0) throw new IOException("SinglePubInfo parsing error, missing data");
        BigInteger bigInteger = derValue.getData().getInteger();
        if (bigInteger.compareTo(BigInteger.valueOf(0L)) == 0) {
            this.pubMethod = 0;
        } else if (bigInteger.compareTo(BigInteger.valueOf(1L)) == 0) {
            this.pubMethod = 1;
        } else if (bigInteger.compareTo(BigInteger.valueOf(2L)) == 0) {
            this.pubMethod = 2;
        } else {
            if (bigInteger.compareTo(BigInteger.valueOf(3L)) != 0) throw new IOException("SinglePubInfo parsing error, invalid publication method");
            this.pubMethod = 3;
        }
        this.pubLocation = null;
        if (derValue.getData().available() == 0) return;
        this.pubLocation = new GeneralName(derValue.getData().getDerValue());
        if (derValue.getData().available() == 0) return;
        throw new IOException("SinglePubInfo parsing error, data overrun");
    }

    public void encode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream.putInteger(BigInteger.valueOf(this.pubMethod));
        if (this.pubLocation != null) {
            this.pubLocation.encode(derOutputStream);
        }
        derOutputStream2.write((byte)48, derOutputStream);
        outputStream.write(derOutputStream2.toByteArray());
    }

    public boolean equals(SinglePubInfo singlePubInfo) {
        DerValue derValue;
        DerValue derValue2;
        if (singlePubInfo == this) {
            return true;
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            this.encode(derOutputStream);
            derValue2 = new DerValue(derOutputStream.toByteArray());
            singlePubInfo.encode(derOutputStream2);
            derValue = new DerValue(derOutputStream2.toByteArray());
        }
        catch (Exception exception) {
            return false;
        }
        return derValue2.equals(derValue);
    }

    public boolean equals(Object object) {
        if (object instanceof SinglePubInfo) {
            return this.equals((SinglePubInfo)object);
        }
        return false;
    }

    public GeneralName getPubLocation() {
        if (this.pubLocation == null) {
            return null;
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            this.pubLocation.encode(derOutputStream);
            return new GeneralName(new DerValue(derOutputStream.toByteArray()));
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public int getPubMethod() {
        return this.pubMethod;
    }

    public String toString() {
        String string = "";
        string = String.valueOf(string) + "SinglePubInfo:";
        string = String.valueOf(string) + "\r\n\tpubMethod: ";
        string = String.valueOf(string) + PubMethods[this.pubMethod];
        if (this.pubLocation != null) {
            string = String.valueOf(string) + "\r\n\tpubLocation: " + this.pubLocation.toString();
        }
        return string;
    }
}

