/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.provider;

import com.ibm.crypto.provider.DHParameterGenerator;
import com.ibm.crypto.provider.DHPrivateKey;
import com.ibm.crypto.provider.DHPublicKey;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.DHGenParameterSpec;
import javax.crypto.spec.DHParameterSpec;

public final class DHKeyPairGenerator
extends KeyPairGeneratorSpi {
    private BigInteger a;
    private BigInteger b;
    private BigInteger c;
    private BigInteger d;
    private int e = 1024;
    private int f;
    private SecureRandom g;
    private static String[] z;

    public void initialize(int n2, SecureRandom secureRandom) {
        if (n2 < 256 || n2 > 2048 || n2 % 64 != 0) {
            throw new InvalidParameterException(z[0]);
        }
        this.e = n2;
        this.f = 0;
        this.g = secureRandom;
    }

    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (!(algorithmParameterSpec instanceof DHParameterSpec)) {
            throw new InvalidAlgorithmParameterException(z[5]);
        }
        this.c = ((DHParameterSpec)algorithmParameterSpec).getP();
        this.e = this.c.bitLength();
        if (this.e < 256 || this.e > 2048 || this.e % 64 != 0) {
            throw new InvalidAlgorithmParameterException(z[4]);
        }
        this.d = ((DHParameterSpec)algorithmParameterSpec).getG();
        this.f = ((DHParameterSpec)algorithmParameterSpec).getL();
        this.g = secureRandom;
        if (this.f != 0 && this.f > this.e) {
            throw new InvalidAlgorithmParameterException(z[3]);
        }
    }

    public KeyPair generateKeyPair() {
        KeyPair keyPair = null;
        if (this.g == null) {
            try {
                this.g = SecureRandom.getInstance(z[2], z[1]);
            }
            catch (NoSuchProviderException noSuchProviderException) {
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
        }
        if (this.f <= 0) {
            this.f = Math.max(384, this.e >> 1);
            this.f = Math.min(this.f, this.e);
        }
        try {
            Object object;
            Object object2;
            Object object3;
            if (this.c == null || this.d == null) {
                object3 = new DHGenParameterSpec(this.e, this.f);
                DHParameterGenerator dHParameterGenerator = new DHParameterGenerator();
                dHParameterGenerator.engineInit((AlgorithmParameterSpec)object3, null);
                object2 = dHParameterGenerator.engineGenerateParameters();
                object = ((AlgorithmParameters)object2).getParameterSpec(DHParameterSpec.class);
                this.c = ((DHParameterSpec)object).getP();
                this.d = ((DHParameterSpec)object).getG();
            }
            object3 = this.c.subtract(BigInteger.valueOf(2L));
            do {
                this.b = new BigInteger(this.f, this.g);
            } while (this.b.compareTo(BigInteger.ONE) < 0 || this.b.compareTo((BigInteger)object3) > 0);
            this.a = this.d.modPow(this.b, this.c);
            object = new DHPublicKey(this.a, this.c, this.d, this.f);
            object2 = new DHPrivateKey(this.b, this.c, this.d, this.f);
            keyPair = new KeyPair((PublicKey)object, (PrivateKey)object2);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new RuntimeException(invalidAlgorithmParameterException.getMessage());
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new RuntimeException(invalidParameterSpecException.getMessage());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new RuntimeException(invalidKeyException.getMessage());
        }
        return keyPair;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        String[] stringArray;
        block59: {
            int n2;
            int n3;
            block58: {
                char[] cArray2;
                Object var0;
                block57: {
                    int n4;
                    block56: {
                        char[] cArray3;
                        block55: {
                            int n5;
                            block54: {
                                char[] cArray4;
                                block53: {
                                    int n6;
                                    block52: {
                                        char[] cArray5;
                                        block51: {
                                            int n7;
                                            block50: {
                                                char[] cArray6;
                                                block49: {
                                                    int n8;
                                                    block48: {
                                                        stringArray = new String[6];
                                                        var0 = null;
                                                        char[] cArray7 = "\\\u0013\u0019\u0010jm\u0013@\u000evd\u0002@\u0001f7\u001b\u0015\u000fw~\u0006\f\u0006#x\u0010@U7;V\u0001\rg7\u0015\u0001\r#x\u0018\f\u001a#e\u0017\u000e\u0004f7\u0010\u0012\fn7DUU#c\u0019@Q3#N@Kjy\u0015\f\u0016p~\u0000\u0005J".toCharArray();
                                                        cArray6 = cArray7;
                                                        n8 = cArray7.length;
                                                        n3 = 0;
                                                        if (!true) break block48;
                                                        n8 = n8;
                                                        if (n8 <= n3) break block49;
                                                    }
                                                    do {
                                                        int n9;
                                                        cArray6 = cArray6;
                                                        int n10 = n3;
                                                        char c2 = cArray6[n10];
                                                        switch (n3 % 5) {
                                                            case 0: {
                                                                n9 = 23;
                                                                break;
                                                            }
                                                            case 1: {
                                                                n9 = 118;
                                                                break;
                                                            }
                                                            case 2: {
                                                                n9 = 96;
                                                                break;
                                                            }
                                                            case 3: {
                                                                n9 = 99;
                                                                break;
                                                            }
                                                            default: {
                                                                n9 = 3;
                                                            }
                                                        }
                                                        cArray6[n10] = (char)(c2 ^ n9);
                                                        ++n3;
                                                        n8 = n8;
                                                    } while (n8 > n3);
                                                }
                                                stringArray[0] = new String(cArray6).intern();
                                                var0 = null;
                                                char[] cArray8 = "^4-)@R".toCharArray();
                                                cArray5 = cArray8;
                                                n7 = cArray8.length;
                                                n3 = 0;
                                                if (!true) break block50;
                                                n7 = n7;
                                                if (n7 <= n3) break block51;
                                            }
                                            do {
                                                int n11;
                                                cArray5 = cArray5;
                                                int n12 = n3;
                                                char c3 = cArray5[n12];
                                                switch (n3 % 5) {
                                                    case 0: {
                                                        n11 = 23;
                                                        break;
                                                    }
                                                    case 1: {
                                                        n11 = 118;
                                                        break;
                                                    }
                                                    case 2: {
                                                        n11 = 96;
                                                        break;
                                                    }
                                                    case 3: {
                                                        n11 = 99;
                                                        break;
                                                    }
                                                    default: {
                                                        n11 = 3;
                                                    }
                                                }
                                                cArray5[n12] = (char)(c3 ^ n11);
                                                ++n3;
                                                n7 = n7;
                                            } while (n7 > n3);
                                        }
                                        stringArray[1] = new String(cArray5).intern();
                                        var0 = null;
                                        char[] cArray9 = "^4-0ft\u0003\u0012\u0006Qv\u0018\u0004\fn".toCharArray();
                                        cArray4 = cArray9;
                                        n6 = cArray9.length;
                                        n3 = 0;
                                        if (!true) break block52;
                                        n6 = n6;
                                        if (n6 <= n3) break block53;
                                    }
                                    do {
                                        int n13;
                                        cArray4 = cArray4;
                                        int n14 = n3;
                                        char c4 = cArray4[n14];
                                        switch (n3 % 5) {
                                            case 0: {
                                                n13 = 23;
                                                break;
                                            }
                                            case 1: {
                                                n13 = 118;
                                                break;
                                            }
                                            case 2: {
                                                n13 = 96;
                                                break;
                                            }
                                            case 3: {
                                                n13 = 99;
                                                break;
                                            }
                                            default: {
                                                n13 = 3;
                                            }
                                        }
                                        cArray4[n14] = (char)(c4 ^ n13);
                                        ++n3;
                                        n6 = n6;
                                    } while (n6 > n3);
                                }
                                stringArray[2] = new String(cArray4).intern();
                                var0 = null;
                                char[] cArray10 = "R\u000e\u0010\fmr\u0018\u0014Cp~\f\u0005Cnb\u0005\u0014Cmx\u0002@\u0001f7\u001a\u0001\u0011dr\u0004@\u0017kv\u0018@\u000els\u0003\f\u0016p7\u0005\t\u0019f".toCharArray();
                                cArray3 = cArray10;
                                n5 = cArray10.length;
                                n3 = 0;
                                if (!true) break block54;
                                n5 = n5;
                                if (n5 <= n3) break block55;
                            }
                            do {
                                int n15;
                                cArray3 = cArray3;
                                int n16 = n3;
                                char c5 = cArray3[n16];
                                switch (n3 % 5) {
                                    case 0: {
                                        n15 = 23;
                                        break;
                                    }
                                    case 1: {
                                        n15 = 118;
                                        break;
                                    }
                                    case 2: {
                                        n15 = 96;
                                        break;
                                    }
                                    case 3: {
                                        n15 = 99;
                                        break;
                                    }
                                    default: {
                                        n15 = 3;
                                    }
                                }
                                cArray3[n16] = (char)(c5 ^ n15);
                                ++n3;
                                n5 = n5;
                            } while (n5 > n3);
                        }
                        stringArray[3] = new String(cArray3).intern();
                        var0 = null;
                        char[] cArray11 = "G\u0004\t\u000ef7\u0005\t\u0019f7\u001b\u0015\u0010w7\u0014\u0005Cnb\u001a\u0014\ns{\u0013@\fe7@TO#v\u0018\u0004C`v\u0018@\fm{\u000f@\u0011by\u0011\u0005Cee\u0019\rC1\"@@\u0017l7DPW;7^\t\r`{\u0003\u0013\nur_".toCharArray();
                        cArray2 = cArray11;
                        n4 = cArray11.length;
                        n3 = 0;
                        if (!true) break block56;
                        n4 = n4;
                        if (n4 <= n3) break block57;
                    }
                    do {
                        int n17;
                        cArray2 = cArray2;
                        int n18 = n3;
                        char c6 = cArray2[n18];
                        switch (n3 % 5) {
                            case 0: {
                                n17 = 23;
                                break;
                            }
                            case 1: {
                                n17 = 118;
                                break;
                            }
                            case 2: {
                                n17 = 96;
                                break;
                            }
                            case 3: {
                                n17 = 99;
                                break;
                            }
                            default: {
                                n17 = 3;
                            }
                        }
                        cArray2[n18] = (char)(c6 ^ n17);
                        ++n3;
                        n4 = n4;
                    } while (n4 > n3);
                }
                stringArray[4] = new String(cArray2).intern();
                var0 = null;
                char[] cArray12 = "^\u0018\u0001\u0013se\u0019\u0010\u0011jv\u0002\u0005Csv\u0004\u0001\u000efc\u0013\u0012Cwn\u0006\u0005".toCharArray();
                cArray = cArray12;
                n2 = cArray12.length;
                n3 = 0;
                if (!true) break block58;
                n2 = n2;
                if (n2 <= n3) break block59;
            }
            do {
                int n19;
                cArray = cArray;
                int n20 = n3;
                char c7 = cArray[n20];
                switch (n3 % 5) {
                    case 0: {
                        n19 = 23;
                        break;
                    }
                    case 1: {
                        n19 = 118;
                        break;
                    }
                    case 2: {
                        n19 = 96;
                        break;
                    }
                    case 3: {
                        n19 = 99;
                        break;
                    }
                    default: {
                        n19 = 3;
                    }
                }
                cArray[n20] = (char)(c7 ^ n19);
                ++n3;
                n2 = n2;
            } while (n2 > n3);
        }
        stringArray[5] = new String(cArray).intern();
        z = stringArray;
    }
}

