/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.ras;

import com.ibm.websphere.ras.TrConfigurator;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.logging.internal.TraceNLSResolver;
import com.ibm.ws.logging.internal.TraceSpecification;
import com.ibm.wsspi.logprovider.TrService;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Queue;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class Tr {
    static final TraceSpecification defaultTraceSpec = new TraceSpecification("", null, false);
    static volatile TraceSpecification activeTraceSpec;
    static final Set<TraceComponent> allTraceComponents;
    private static final Queue<TraceComponent> newTracecomponents;
    private static final Lock allTraceComponentsLock;

    public static TraceComponent register(Class<?> aClass) {
        TraceComponent tc;
        TraceOptions options = aClass.getAnnotation(TraceOptions.class);
        if (options == null) {
            options = aClass.getPackage().getAnnotation(TraceOptions.class);
        }
        String name = aClass.getName();
        if (options == null) {
            tc = new TraceComponent(name, aClass, (String)null, null);
        } else {
            String[] traceGroups = options.traceGroups();
            if (traceGroups.length == 0) {
                String traceGroup = options.traceGroup();
                traceGroups = traceGroup.trim().isEmpty() ? TraceComponent.EMPTY_STRING_ARRAY : new String[]{traceGroup};
            }
            tc = new TraceComponent(name, aClass, traceGroups, false, options.messageBundle());
        }
        Tr.registerTraceComponent(tc);
        return tc;
    }

    public static TraceComponent register(String name, Class<?> aClass, String group) {
        return Tr.register(name, aClass, group, null);
    }

    public static TraceComponent register(String name, Class<?> aClass, String[] groups) {
        return Tr.register(name, aClass, groups, null);
    }

    public static TraceComponent register(Class<?> aClass, String group) {
        return Tr.register(aClass, group, null);
    }

    public static TraceComponent register(Class<?> aClass, String group, String bundle) {
        TraceComponent tc = new TraceComponent(aClass.getName(), aClass, group, bundle);
        Tr.registerTraceComponent(tc);
        return tc;
    }

    public static TraceComponent register(Class<?> aClass, String[] groups, String bundle, String name) {
        TraceComponent tc = new TraceComponent(name, aClass, groups, bundle);
        Tr.registerTraceComponent(tc);
        return tc;
    }

    public static TraceComponent register(String name, Class<?> aClass, String group, String bundle) {
        TraceComponent tc = new TraceComponent(name, aClass, group, bundle);
        Tr.registerTraceComponent(tc);
        return tc;
    }

    public static TraceComponent register(String name, Class<?> aClass, String[] groups, String bundle) {
        TraceComponent tc = new TraceComponent(name, aClass, groups, bundle);
        Tr.registerTraceComponent(tc);
        return tc;
    }

    public static final void audit(TraceComponent tc, String msgKey, Object ... objs) {
        TrConfigurator.getDelegate().audit(tc, msgKey, objs);
    }

    public static final void debug(TraceComponent tc, String msg, Object ... objs) {
        TrConfigurator.getDelegate().debug(tc, msg, objs);
    }

    public static final void debug(Object id, TraceComponent tc, String msg, Object ... objs) {
        TrConfigurator.getDelegate().debug(tc, id, msg, objs);
    }

    public static final void dump(TraceComponent tc, String msg, Object ... objs) {
        TrConfigurator.getDelegate().dump(tc, msg, objs);
    }

    public static final void entry(TraceComponent tc, String methodName, Object ... objs) {
        TrConfigurator.getDelegate().entry(tc, methodName, objs);
    }

    public static final void entry(Object id, TraceComponent tc, String methodName, Object ... objs) {
        TrConfigurator.getDelegate().entry(tc, id, methodName, objs);
    }

    public static final void error(TraceComponent tc, String msgKey, Object ... objs) {
        TrConfigurator.getDelegate().error(tc, msgKey, objs);
    }

    public static final void event(TraceComponent tc, String msg, Object ... objs) {
        TrConfigurator.getDelegate().event(tc, msg, objs);
    }

    public static final void event(Object id, TraceComponent tc, String msg, Object ... objs) {
        TrConfigurator.getDelegate().event(tc, id, msg, objs);
    }

    public static final void exit(TraceComponent tc, String methodName) {
        TrConfigurator.getDelegate().exit(tc, methodName);
    }

    public static final void exit(Object id, TraceComponent tc, String methodName) {
        TrConfigurator.getDelegate().exit(tc, id, methodName);
    }

    public static final void exit(TraceComponent tc, String methodName, Object o) {
        TrConfigurator.getDelegate().exit(tc, methodName, o);
    }

    public static final void exit(Object id, TraceComponent tc, String methodName, Object o) {
        TrConfigurator.getDelegate().exit(tc, id, methodName, o);
    }

    public static final void fatal(TraceComponent tc, String msgKey, Object ... objs) {
        TrConfigurator.getDelegate().fatal(tc, msgKey, objs);
    }

    public static final void info(TraceComponent tc, String msgKey, Object ... objs) {
        TrConfigurator.getDelegate().info(tc, msgKey, objs);
    }

    public static final void warning(TraceComponent tc, String msgKey, Object ... objs) {
        TrConfigurator.getDelegate().warning(tc, msgKey, objs);
    }

    public static final String formatMessage(TraceComponent tc, String msgKey, Object ... objs) {
        return Tr.formatMessage(tc, Locale.getDefault(), msgKey, objs);
    }

    public static String formatMessage(TraceComponent tc, Locale locale, String msgKey, Object ... objs) {
        return Tr.formatMessage(tc, locale == null ? null : Collections.singletonList(locale), msgKey, objs);
    }

    public static String formatMessage(TraceComponent tc, Enumeration<Locale> locales, String msgKey, Object ... objs) {
        return Tr.formatMessage(tc, locales == null ? null : Collections.list(locales), msgKey, objs);
    }

    public static final String formatMessage(TraceComponent tc, List<Locale> locales, String msgKey, Object ... objs) {
        String msg;
        try {
            ResourceBundle rb = TraceNLSResolver.getInstance().getResourceBundle(tc.getTraceClass(), tc.getResourceBundleName(), locales);
            msg = rb.getString(msgKey);
        }
        catch (Exception ex) {
            msg = msgKey;
        }
        if (msg.contains("{0")) {
            return MessageFormat.format(msg, objs);
        }
        return msg;
    }

    static void registerTraceComponent(TraceComponent tc) {
        tc.setTraceSpec(activeTraceSpec);
        TrService activeDelegate = TrConfigurator.getDelegate();
        activeDelegate.register(tc);
        TrConfigurator.traceComponentRegistered(tc);
        newTracecomponents.add(tc);
        Tr.processNewTraceComponents();
    }

    static void setTraceSpec(TraceSpecification spec) {
        if (spec == null) {
            return;
        }
        allTraceComponentsLock.lock();
        try {
            Tr.processNewTraceComponents();
            if (activeTraceSpec != null && activeTraceSpec.equals(spec)) {
                return;
            }
            activeTraceSpec = spec;
            if (activeTraceSpec != defaultTraceSpec && activeTraceSpec.equals(defaultTraceSpec)) {
                activeTraceSpec = defaultTraceSpec;
            }
            for (TraceComponent t : allTraceComponents) {
                t.setTraceSpec(activeTraceSpec);
            }
            TraceComponent.setAnyTracingEnabled(activeTraceSpec.isAnyTraceEnabled());
            Tr.info(TraceSpecification.getTc(), "MSG_TRACE_STATE_CHANGED", activeTraceSpec.toDisplayString());
            Tr.processNewTraceComponents();
        }
        finally {
            allTraceComponentsLock.unlock();
        }
    }

    private static void processNewTraceComponents() {
        if (allTraceComponentsLock.tryLock()) {
            try {
                TraceComponent tc = newTracecomponents.poll();
                while (tc != null) {
                    allTraceComponents.add(tc);
                    tc = newTracecomponents.poll();
                }
            }
            finally {
                allTraceComponentsLock.unlock();
            }
        }
    }

    protected Tr() {
    }

    static {
        List<TraceSpecification.TraceElement> elements = defaultTraceSpec.getSpecs();
        if (elements.size() == 1) {
            elements.get(0).setMatched(true);
        }
        activeTraceSpec = defaultTraceSpec;
        allTraceComponents = Collections.newSetFromMap(new WeakHashMap());
        newTracecomponents = new ConcurrentLinkedQueue<TraceComponent>();
        allTraceComponentsLock = new ReentrantLock();
    }
}

