/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.injectionengine;

import com.ibm.ws.javaee.dd.common.JNDIEnvironmentRef;
import com.ibm.wsspi.injectionengine.InjectionProcessor;
import com.ibm.wsspi.injectionengine.InjectionProcessorContextImpl;
import com.ibm.wsspi.injectionengine.InjectionProcessorProvider;
import com.ibm.wsspi.injectionengine.InjectionSimpleProcessor;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;

public final class InjectionProcessorProviderImpl<A extends Annotation, AS extends Annotation>
extends InjectionProcessorProvider<A, AS> {
    private final Class<A> ivAnnotationClass;
    private final Class<? extends InjectionProcessor<A, AS>> ivInjectionProcessorClass;
    private final boolean ivSimple;
    private volatile boolean ivAnnotationsClassChecked;
    private Class<AS> ivAnnotationsClass;

    InjectionProcessorProviderImpl(Class<A> annotationClass, Class<? extends InjectionProcessor<A, AS>> injectionProcessorClass) {
        this.ivAnnotationClass = annotationClass;
        this.ivInjectionProcessorClass = injectionProcessorClass;
        this.ivAnnotationsClassChecked = this.ivSimple = InjectionSimpleProcessor.class.isAssignableFrom(injectionProcessorClass);
    }

    public String toString() {
        return this.getClass().getSimpleName() + '[' + this.ivInjectionProcessorClass.getName() + ']';
    }

    @Override
    public Class<A> getAnnotationClass() {
        return this.ivAnnotationClass;
    }

    @Override
    public Class<AS> getAnnotationsClass() {
        if (!this.ivAnnotationsClassChecked) {
            this.ivAnnotationsClass = InjectionProcessorContextImpl.getAnnotationsClass(this.createInjectionProcessor());
            this.ivAnnotationsClassChecked = true;
        }
        return this.ivAnnotationsClass;
    }

    @Override
    public List<Class<? extends JNDIEnvironmentRef>> getJNDIEnvironmentRefClasses() {
        return this.ivSimple ? Collections.emptyList() : null;
    }

    @Override
    public InjectionProcessor<A, AS> createInjectionProcessor() {
        try {
            return this.ivInjectionProcessorClass.newInstance();
        }
        catch (IllegalAccessException ex) {
            throw new IllegalStateException(ex);
        }
        catch (InstantiationException ex) {
            throw new IllegalStateException(ex);
        }
    }
}

