/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.internal.cmdline;

import com.ibm.ws.install.InstallException;
import com.ibm.ws.install.InstallKernel;
import com.ibm.ws.install.InstallKernelFactory;
import com.ibm.ws.install.RepositoryConfigUtils;
import com.ibm.ws.install.internal.InstallKernelImpl;
import com.ibm.ws.install.internal.InstallLogUtils;
import com.ibm.ws.install.internal.InstallUtils;
import com.ibm.ws.install.internal.cmdline.InstallExecutor;
import com.ibm.ws.kernel.boot.cmdline.ActionHandler;
import com.ibm.ws.kernel.boot.cmdline.Arguments;
import com.ibm.ws.kernel.boot.cmdline.ExitCode;
import com.ibm.ws.kernel.feature.internal.cmdline.NLS;
import com.ibm.ws.kernel.feature.internal.cmdline.ReturnCode;
import com.ibm.ws.repository.resources.EsaResource;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.StringReader;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ExeFindAction
implements ActionHandler {
    protected static final Logger logger = InstallLogUtils.getInstallLogger();

    public ExitCode handleTask(PrintStream stdout, PrintStream stderr, Arguments args) {
        logger.log(Level.INFO, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("MSG_STABILIZING_FEATUREMANAGER", "find") + "\n");
        InstallKernel installKernel = InstallKernelFactory.getInstance();
        installKernel.setUserAgent("featureManager");
        try {
            Properties repoProperties = RepositoryConfigUtils.loadRepoProperties();
            if (repoProperties != null) {
                installKernel.setRepositoryProperties(repoProperties);
            }
        }
        catch (InstallException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            return InstallExecutor.returnCode(e.getRc());
        }
        String searchStr = (String)args.getPositionalArguments().get(0);
        boolean viewInfo = args.getOption("viewinfo") != null;
        try {
            logger.log(Level.INFO, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("MSG_SEARCHING", new Object[0]));
            logger.log(Level.INFO, "");
            List<EsaResource> esas = ((InstallKernelImpl)installKernel).queryFeatures(searchStr);
            if (esas.isEmpty()) {
                logger.log(Level.INFO, NLS.getMessage((String)"find.no.feature", (Object[])new Object[0]));
            } else {
                Collections.sort(esas, new Comparator<EsaResource>(){

                    @Override
                    public int compare(EsaResource er1, EsaResource er2) {
                        return ExeFindAction.this.getName(er1).compareTo(ExeFindAction.this.getName(er2));
                    }
                });
                InstallUtils.log(esas);
                for (EsaResource esa : esas) {
                    this.showESA(esa, viewInfo);
                }
            }
        }
        catch (InstallException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            return InstallExecutor.returnCode(e.getRc());
        }
        return ReturnCode.OK;
    }

    private String getName(EsaResource esa) {
        String shortName = esa.getShortName();
        if (shortName != null && !shortName.isEmpty()) {
            return shortName;
        }
        return esa.getProvideFeature();
    }

    private void showESA(EsaResource esa, boolean viewInfo) {
        Collection requiredFeatures;
        if (!viewInfo) {
            logger.log(Level.INFO, this.getName(esa) + " : " + esa.getName());
            return;
        }
        logger.log(Level.INFO, this.getName(esa));
        logger.log(Level.INFO, NLS.getMessage((String)"find.view.info.name", (Object[])new Object[]{esa.getName()}));
        logger.log(Level.INFO, NLS.getMessage((String)"find.view.info.symbolic.name", (Object[])new Object[]{esa.getProvideFeature()}));
        String description = esa.getShortDescription();
        if (description != null && !description.isEmpty()) {
            description = NLS.getMessage((String)"find.view.info.description", (Object[])new Object[]{description});
            StringBuffer sb = new StringBuffer();
            BufferedReader reader = new BufferedReader(new StringReader(description));
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    InstallUtils.wordWrap(sb, line, "        ");
                }
                logger.log(Level.INFO, sb.toString());
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, description);
            }
        }
        if ((requiredFeatures = esa.getRequireFeature()) != null && !requiredFeatures.isEmpty()) {
            logger.log(Level.INFO, NLS.getMessage((String)"find.view.info.enabled.by", (Object[])new Object[0]));
            for (String requiredFeature : requiredFeatures) {
                logger.log(Level.INFO, "        " + requiredFeature);
            }
        }
        logger.log(Level.INFO, "");
    }
}

