/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jndi.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.jndi.internal.AutoBindNode;
import com.ibm.ws.jndi.internal.ContextNode;
import com.ibm.ws.jndi.internal.JNDIServiceBinderManager;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.logging.Introspector;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import java.util.TreeMap;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Component;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(property={"service.vendor=IBM"})
public class JNDIIntrospector
implements Introspector {
    static final long serialVersionUID = -1098567854156847914L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public String getIntrospectorName() {
        return "JNDIDefaultNamespace";
    }

    public String getIntrospectorDescription() {
        return "JNDI default namespace";
    }

    public void introspect(PrintWriter writer) throws IOException {
        writer.println();
        writer.println("======================================================================================");
        writer.println("Beginning of Dump");
        writer.println("======================================================================================");
        writer.println();
        writer.printf("%-15s %-45s %s", "Service.id", "Service.name", "ObjectClass").println();
        ContextNode root = JNDIServiceBinderManager.JNDIServiceBinderHolder.HELPER.root;
        writer.println("Total number of items: " + this.outputEntries(writer, root, ""));
        writer.println();
        writer.println("======================================================================================");
        writer.println("End of Dump");
        writer.println("======================================================================================");
    }

    private int outputEntries(PrintWriter pw, ContextNode node, String parentNamePrefix) {
        int numberOfEntries = 0;
        for (Map.Entry<String, Object> entry : new TreeMap<String, Object>(node.children).entrySet()) {
            Object lastEntry;
            String key = parentNamePrefix + entry.getKey();
            Object value = entry.getValue();
            if (value instanceof ContextNode) {
                key = key.concat("/");
                numberOfEntries += this.outputEntries(pw, (ContextNode)value, key);
                continue;
            }
            ++numberOfEntries;
            Object serviceID = null;
            Object objectClass = null;
            Object object = lastEntry = value instanceof AutoBindNode ? ((AutoBindNode)value).getLastEntry() : null;
            if (lastEntry instanceof ServiceReference) {
                serviceID = ((ServiceReference)lastEntry).getProperty("service.id");
                objectClass = ((ServiceReference)lastEntry).getProperty("objectClass");
                if (objectClass instanceof Object[]) {
                    objectClass = ((Object[])objectClass)[0];
                }
            } else {
                serviceID = null;
                objectClass = lastEntry != null ? lastEntry : value;
            }
            pw.printf("%-15s %-45s %s", serviceID, key, objectClass).println();
        }
        return numberOfEntries;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.jndi.internal.JNDIIntrospector", JNDIIntrospector.class, (String)"Naming", (String)"com.ibm.ws.jndi.internal.resources.JNDIMessages");
    }
}

