/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.crypto.util;

import com.ibm.wsspi.security.crypto.KeyStringResolver;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

public class AESKeyManager {
    private static final AtomicReference<KeyHolder> _key = new AtomicReference();
    private static final AtomicReference<KeyStringResolver> _resolver = new AtomicReference();

    public static Key getKey(String key) {
        KeyHolder holder = AESKeyManager.getHolder(key);
        return holder.getKey();
    }

    private static KeyHolder getHolder(String key) {
        char[] keyChars = _resolver.get().getKey(key == null ? "${wlp.password.encryption.key}" : key);
        KeyHolder holder = _key.get();
        if (holder == null || !holder.matches(keyChars)) {
            try {
                SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
                PBEKeySpec aesKey = new PBEKeySpec(keyChars, new byte[]{-89, -94, -125, 57, 76, 90, -77, 79, 50, 21, 10, -98, 47, 23, 17, 56, -61, 46, 125, -128}, 84756, 128);
                byte[] data = keyFactory.generateSecret(aesKey).getEncoded();
                KeyHolder holder2 = new KeyHolder(keyChars, new SecretKeySpec(data, "AES"), new IvParameterSpec(data));
                _key.compareAndSet(holder, holder2);
                holder = holder2;
            }
            catch (InvalidKeySpecException e) {
                return null;
            }
            catch (NoSuchAlgorithmException e) {
                return null;
            }
        }
        return holder;
    }

    public static void setKeyStringResolver(KeyStringResolver resolver) {
        if (resolver == null) {
            resolver = new KeyStringResolver(){

                @Override
                public char[] getKey(String key) {
                    return key.toCharArray();
                }
            };
        }
        _resolver.set(resolver);
    }

    public static IvParameterSpec getIV(String cryptoKey) {
        return AESKeyManager.getHolder(cryptoKey).getIv();
    }

    static {
        AESKeyManager.setKeyStringResolver(null);
    }

    private static class KeyHolder {
        private final char[] keyChars;
        private final Key key;
        private final IvParameterSpec iv;

        public KeyHolder(char[] kc, Key k, IvParameterSpec ivParameterSpec) {
            this.keyChars = kc;
            this.key = k;
            this.iv = ivParameterSpec;
        }

        public boolean matches(char[] k) {
            if (k == this.keyChars) {
                return true;
            }
            return Arrays.equals(k, this.keyChars);
        }

        public Key getKey() {
            return this.key;
        }

        public IvParameterSpec getIv() {
            return this.iv;
        }
    }
}

