/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cdi.jndi.liberty;

import com.ibm.ejs.util.Util;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.cdi.CDIService;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.injectionengine.ObjectFactoryInfo;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import java.lang.annotation.Annotation;
import java.util.Hashtable;
import javax.annotation.Resource;
import javax.enterprise.inject.spi.BeanManager;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(name="com.ibm.ws.cdi.jndi.liberty.BeanManagerObjectFactoryInfo", service={ObjectFactoryInfo.class, ObjectFactory.class, BeanManagerObjectFactoryInfo.class}, property={"service.vendor=IBM"})
public class BeanManagerObjectFactoryInfo
extends ObjectFactoryInfo
implements ObjectFactory {
    private static final TraceComponent tc = Tr.register(BeanManagerObjectFactoryInfo.class, (String)"JCDI", null);
    private final AtomicServiceReference<CDIService> cdiServiceRef = new AtomicServiceReference("cdiService");
    static final long serialVersionUID = 2896785963679611338L;

    public Class<? extends Annotation> getAnnotationClass() {
        return Resource.class;
    }

    public Class<?> getType() {
        return BeanManager.class;
    }

    public boolean isOverrideAllowed() {
        return false;
    }

    public Class<? extends ObjectFactory> getObjectFactoryClass() {
        return BeanManagerObjectFactoryInfo.class;
    }

    @Override
    @ManualTrace
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getObjectInstance" + Util.identity((Object)obj)), (Object[])new Object[0]);
        }
        BeanManager bm = null;
        if (obj instanceof Reference) {
            Reference objRef = (Reference)obj;
            String factoryClassName = objRef.getFactoryClassName();
            if (this.getClass().getName().equals(factoryClassName)) {
                CDIService cdiService = this.getCDIService();
                bm = cdiService.getCurrentBeanManager();
            }
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getObjectInstance", bm);
        }
        return bm;
    }

    public void activate(ComponentContext context) {
        this.cdiServiceRef.activate(context);
    }

    public void deactivate(ComponentContext context) {
        this.cdiServiceRef.deactivate(context);
    }

    CDIService getCDIService() {
        return (CDIService)this.cdiServiceRef.getServiceWithException();
    }

    @org.osgi.service.component.annotations.Reference(name="cdiService", service=CDIService.class)
    protected void setCdiService(ServiceReference<CDIService> ref) {
        this.cdiServiceRef.setReference(ref);
    }

    protected void unsetCdiService(ServiceReference<CDIService> ref) {
        this.cdiServiceRef.unsetReference(ref);
    }
}

