/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.product.utility.extension;

import com.ibm.ws.kernel.feature.FeatureDefinition;
import com.ibm.ws.kernel.feature.Visibility;
import com.ibm.ws.kernel.feature.internal.generator.ManifestFileProcessor;
import com.ibm.ws.product.utility.BaseCommandTask;
import com.ibm.ws.product.utility.CommandConsole;
import com.ibm.ws.product.utility.ExecutionContext;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class FeatureInfoCommandTask
extends BaseCommandTask {
    public static final String FEATURE_INFO_TASK_NAME = "featureInfo";

    @Override
    public Set<String> getSupportedOptions() {
        return new HashSet<String>();
    }

    @Override
    public String getTaskName() {
        return FEATURE_INFO_TASK_NAME;
    }

    @Override
    public String getTaskDescription() {
        return this.getOption("featureInfo.desc", new Object[0]);
    }

    @Override
    public String getTaskHelp() {
        return super.getTaskHelp("featureInfo.desc", "featureInfo.usage.options", "featureInfo.option-key.", "featureInfo.option-desc.", null);
    }

    @Override
    protected void doExecute(ExecutionContext context) {
        CommandConsole commandConsole = context.getCommandConsole();
        ManifestFileProcessor processor = new ManifestFileProcessor();
        for (Map.Entry prodFeatureEntries : processor.getFeatureDefinitionsByProduct().entrySet()) {
            String productName = (String)prodFeatureEntries.getKey();
            boolean headingPrinted = false;
            for (Map.Entry entry : ((Map)prodFeatureEntries.getValue()).entrySet()) {
                FeatureDefinition featureDefintion = (FeatureDefinition)entry.getValue();
                String featureName = featureDefintion.getFeatureName();
                if (featureDefintion.getVisibility() != Visibility.PUBLIC) continue;
                if (productName.equals("core")) {
                    commandConsole.printInfoMessage(featureName);
                } else {
                    if (!headingPrinted) {
                        commandConsole.printlnInfoMessage("");
                        commandConsole.printInfoMessage("Product Extension: ");
                        commandConsole.printlnInfoMessage(productName);
                        headingPrinted = true;
                    }
                    int colonIndex = featureName.indexOf(":");
                    commandConsole.printInfoMessage(featureName.substring(colonIndex + 1));
                }
                commandConsole.printlnInfoMessage("");
            }
        }
    }
}

