/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.bluemix.utility.utils;

import com.ibm.websphere.ras.DataFormatHelper;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public class ConsoleHandler
extends Handler {
    private static final String format = "%1$s%2$s%3$s";
    private final PrintStream stream = System.err;

    public ConsoleHandler() {
        this.setFormatter(new SimpleFormatter());
    }

    @Override
    public void publish(LogRecord record) {
        if (this.isLoggable(record)) {
            this.logToErrStream(record);
        }
    }

    private String formatMessage(LogRecord record) {
        String message = this.getFormatter().formatMessage(record);
        String throwable = "";
        if (record.getThrown() != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            pw.println();
            record.getThrown().printStackTrace(pw);
            pw.close();
            throwable = sw.toString();
        }
        String date = DataFormatHelper.formatCurrentTime();
        return String.format(format, date, message, throwable);
    }

    private void logToErrStream(LogRecord record) {
        String message = this.formatMessage(record);
        this.stream.println(message);
        this.stream.flush();
    }

    @Override
    public void close() {
        this.flush();
    }

    @Override
    public void flush() {
        this.stream.flush();
    }

    public static void enableConsoleLogging(Level logLevel) {
        Handler[] handlers;
        Logger logger = ConsoleHandler.getUtilityLogger();
        for (Handler handler : handlers = logger.getHandlers()) {
            if (!(handler instanceof ConsoleHandler) || handler.getLevel().equals(logLevel)) continue;
            logger.removeHandler(handler);
            break;
        }
        ConsoleHandler ch = new ConsoleHandler();
        ch.setLevel(logLevel);
        logger.setUseParentHandlers(false);
        logger.setLevel(Level.FINEST);
        logger.addHandler(ch);
    }

    public static Logger getUtilityLogger() {
        return Logger.getLogger("com.ibm.ws.bluemix.utility");
    }
}

