/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.security.token;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.auth.WSSubject;
import com.ibm.websphere.security.auth.callback.WSCallbackHandlerImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.kerberos.auth.Krb5LoginModuleWrapper;
import com.ibm.ws.security.krb5.Krb5Common;
import com.ibm.ws.security.token.krb5.Krb5Helper;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.Oid;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class SpnegoTokenHelper {
    private static final TraceComponent tc = Tr.register(SpnegoTokenHelper.class, (String)"Token", (String)"com.ibm.ws.security.token.internal.resources.TokenMessages");
    static final long serialVersionUID = 249773837765582850L;

    public static String buildSpnegoAuthorizationFromCallerSubject(String spn, int lifetime, boolean delegate) throws WSSecurityException, GSSException, PrivilegedActionException {
        Subject subject = WSSubject.getCallerSubject();
        if (subject == null) {
            subject = WSSubject.getRunAsSubject();
        }
        return SpnegoTokenHelper.buildSpnegoAuthorizationFromSubject(spn, subject, lifetime, delegate);
    }

    public static String buildSpnegoAuthorizationFromSubject(String spn, Subject subject, int lifetime, boolean delegate) throws GSSException, PrivilegedActionException {
        Krb5Helper.checkSpn((String)spn);
        return Krb5Helper.buildSpnegoAuthorizationFromSubjectCommon((String)spn, (Subject)subject, (int)lifetime, (boolean)delegate);
    }

    /*
     * WARNING - void declaration
     */
    public static String buildSpnegoAuthorizationFromNativeCreds(final String spn, final int lifetime, final boolean delegate) throws GSSException, PrivilegedActionException {
        String token;
        Krb5Helper.checkSpn((String)spn);
        try {
            token = (String)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){
                static final long serialVersionUID = -6063323207179772536L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object run() throws PrivilegedActionException, GSSException {
                    String token = null;
                    String savedProperty = Krb5Helper.setPropertyAsNeeded((String)"javax.security.auth.useSubjectCredsOnly", (String)"false");
                    try {
                        GSSCredential gssCred = Krb5Helper.getGSSCred(null, null, (Oid)Krb5Common.SPNEGO_MECH_OID, (int)1, (int)Integer.MAX_VALUE, (int)Integer.MAX_VALUE);
                        token = Krb5Helper.buildSpnegoAuthorization((GSSCredential)gssCred, (String)spn, (int)lifetime, (boolean)delegate);
                    }
                    finally {
                        Krb5Common.restorePropertyAsNeeded((String)"javax.security.auth.useSubjectCredsOnly", (String)savedProperty, (String)"false");
                    }
                    return token;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.wsspi.security.token.SpnegoTokenHelper$1", 1.class, (String)"Token", (String)"com.ibm.ws.security.token.internal.resources.TokenMessages");
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            void e;
            FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.wsspi.security.token.SpnegoTokenHelper", (String)"132", null, (Object[])new Object[]{spn, lifetime, delegate});
            Throwable general = Krb5Helper.getGeneralCause((PrivilegedActionException)e);
            if (general instanceof GSSException) {
                throw (GSSException)general;
            }
            throw e;
        }
        return token;
    }

    /*
     * WARNING - void declaration
     */
    public static String buildSpnegoAuthorizationFromUpn(final String spn, final String upn, final String jaasLoginContextEntry, final int lifetime, final boolean delegate) throws GSSException, LoginException, PrivilegedActionException {
        String token;
        Krb5Helper.checkSpn((String)spn);
        Krb5Helper.checkUpn((String)upn);
        try {
            token = (String)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){
                static final long serialVersionUID = -8771378281528230433L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object run() throws LoginException, PrivilegedActionException, GSSException {
                    String token = null;
                    String savedProperty = Krb5Helper.setPropertyAsNeeded((String)"javax.security.auth.useSubjectCredsOnly", (String)"false");
                    try {
                        Subject subject = SpnegoTokenHelper.doKerberosLogin(jaasLoginContextEntry, upn, null);
                        GSSCredential gssCred = (GSSCredential)Subject.doAs(subject, new PrivilegedExceptionAction<Object>(){
                            static final long serialVersionUID = -3876628782473623535L;
                            private static final /* synthetic */ TraceComponent $$$tc$$$;

                            @Override
                            public Object run() throws GSSException, Exception {
                                GSSCredential innerCred = Krb5Helper.getGSSCred(null, (String)upn, (Oid)Krb5Common.SPNEGO_MECH_OID, (int)1, (int)Integer.MAX_VALUE, (int)Integer.MAX_VALUE);
                                return innerCred;
                            }

                            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                            static {
                                $$$tc$$$ = Tr.register((String)"com.ibm.wsspi.security.token.SpnegoTokenHelper$2$1", 1.class, (String)"Token", (String)"com.ibm.ws.security.token.internal.resources.TokenMessages");
                            }
                        });
                        token = Krb5Helper.buildSpnegoAuthorization((GSSCredential)gssCred, (String)spn, (int)lifetime, (boolean)delegate);
                    }
                    finally {
                        Krb5Common.restorePropertyAsNeeded((String)"javax.security.auth.useSubjectCredsOnly", (String)savedProperty, (String)"false");
                    }
                    return token;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.wsspi.security.token.SpnegoTokenHelper$2", 2.class, (String)"Token", (String)"com.ibm.ws.security.token.internal.resources.TokenMessages");
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            void e;
            FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.wsspi.security.token.SpnegoTokenHelper", (String)"197", null, (Object[])new Object[]{spn, upn, jaasLoginContextEntry, lifetime, delegate});
            Throwable general = Krb5Helper.getGeneralCause((PrivilegedActionException)e);
            if (general instanceof LoginException) {
                throw (LoginException)general;
            }
            if (general instanceof GSSException) {
                throw (GSSException)general;
            }
            throw e;
        }
        return token;
    }

    public static String buildSpnegoAuthorizationFromUseridPassword(String spn, String userid, @Sensitive String password, int lifetime, boolean delegate) throws GSSException, LoginException, PrivilegedActionException {
        return SpnegoTokenHelper.buildSpnegoAuthorizationFromUseridPassword(spn, userid, password, "JAASClient", lifetime, delegate);
    }

    /*
     * WARNING - void declaration
     */
    public static String buildSpnegoAuthorizationFromUseridPassword(final String spn, final String userid, final @Sensitive String password, final String jaasLoginContextEntry, final int lifetime, final boolean delegate) throws GSSException, LoginException, PrivilegedActionException {
        String token;
        Krb5Helper.checkSpn((String)spn);
        Krb5Helper.checkUpn((String)userid);
        Krb5Helper.checkPassword((String)password);
        try {
            token = (String)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){
                static final long serialVersionUID = 5246391761545194704L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Object run() throws LoginException, GSSException, PrivilegedActionException {
                    String innerToken = null;
                    Subject useSubject = SpnegoTokenHelper.doKerberosLogin(jaasLoginContextEntry, userid, password);
                    GSSCredential gssCred = (GSSCredential)Subject.doAs(useSubject, new PrivilegedExceptionAction<Object>(){
                        static final long serialVersionUID = 2903546241992746685L;
                        private static final /* synthetic */ TraceComponent $$$tc$$$;

                        @Override
                        public Object run() throws GSSException, Exception {
                            GSSCredential innerCred = Krb5Helper.getGSSCred(null, (String)userid, (Oid)Krb5Common.SPNEGO_MECH_OID, (int)1, (int)Integer.MAX_VALUE, (int)Integer.MAX_VALUE);
                            return innerCred;
                        }

                        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                        static {
                            $$$tc$$$ = Tr.register((String)"com.ibm.wsspi.security.token.SpnegoTokenHelper$3$1", 1.class, (String)"Token", (String)"com.ibm.ws.security.token.internal.resources.TokenMessages");
                        }
                    });
                    innerToken = Krb5Helper.buildSpnegoAuthorization((GSSCredential)gssCred, (String)spn, (int)lifetime, (boolean)delegate);
                    return innerToken;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.wsspi.security.token.SpnegoTokenHelper$3", 3.class, (String)"Token", (String)"com.ibm.ws.security.token.internal.resources.TokenMessages");
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            void e;
            Object[] objectArray = new Object[6];
            objectArray[0] = spn;
            objectArray[1] = userid;
            objectArray[2] = "<sensitive java.lang.String>";
            objectArray[3] = jaasLoginContextEntry;
            objectArray[4] = lifetime;
            objectArray[5] = delegate;
            FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.wsspi.security.token.SpnegoTokenHelper", (String)"279", null, (Object[])objectArray);
            Throwable general = Krb5Helper.getGeneralCause((PrivilegedActionException)e);
            if (general instanceof LoginException) {
                throw (LoginException)general;
            }
            if (general instanceof GSSException) {
                throw (GSSException)general;
            }
            throw e;
        }
        return token;
    }

    private static Subject doKerberosLogin(String jaasLoginContextEntry, String upn, @Sensitive String password) throws LoginException {
        if (Krb5Common.IBM_KRB5_LOGIN_MODULE_AVAILABLE) {
            return SpnegoTokenHelper.doIBMKerberosLogin(jaasLoginContextEntry, upn, password);
        }
        if (Krb5Common.OTHER_KRB5_LOGIN_MODULE_AVAILABLE) {
            return SpnegoTokenHelper.doOtherKerberosLogin(jaasLoginContextEntry, upn, password);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static Subject doIBMKerberosLogin(String jaasLoginContextEntry, final String upn, final @Sensitive String password) throws LoginException {
        Subject subject;
        block4: {
            subject = null;
            if (jaasLoginContextEntry == null) {
                jaasLoginContextEntry = "JAASClient";
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("jaasLoginContextEntry: " + jaasLoginContextEntry), (Object[])new Object[0]);
                }
            }
            final String inJaasLoginContextEntry = jaasLoginContextEntry;
            try {
                subject = AccessController.doPrivileged(new PrivilegedExceptionAction<Subject>(){
                    static final long serialVersionUID = 5228473330192668780L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    @Override
                    public Subject run() throws LoginException {
                        WSCallbackHandlerImpl callbackHandler = new WSCallbackHandlerImpl(upn, password);
                        LoginContext lc = new LoginContext(inJaasLoginContextEntry, (CallbackHandler)callbackHandler);
                        lc.login();
                        return lc.getSubject();
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register((String)"com.ibm.wsspi.security.token.SpnegoTokenHelper$4", 4.class, (String)"Token", (String)"com.ibm.ws.security.token.internal.resources.TokenMessages");
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                void e;
                Object[] objectArray = new Object[3];
                objectArray[0] = jaasLoginContextEntry;
                objectArray[1] = upn;
                objectArray[2] = "<sensitive java.lang.String>";
                FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.wsspi.security.token.SpnegoTokenHelper", (String)"329", null, (Object[])objectArray);
                Throwable general = Krb5Helper.getGeneralCause((PrivilegedActionException)e);
                if (!(general instanceof LoginException)) break block4;
                throw (LoginException)general;
            }
        }
        return subject;
    }

    static Subject doOtherKerberosLogin(String jaasLoginContextEntry, String upn, @Sensitive String password) throws LoginException {
        Subject subject = new Subject();
        Krb5LoginModuleWrapper krb5 = new Krb5LoginModuleWrapper();
        HashMap<String, String> options = new HashMap<String, String>();
        HashMap<String, Object> sharedState = new HashMap<String, Object>();
        options.put("isInitiator", "true");
        options.put("refreshKrb5Config", "true");
        options.put("doNotPrompt", "false");
        options.put("clearPass", "true");
        options.put("storeKey", "true");
        if (password != null) {
            options.put("useFirstPass", "true");
            sharedState.put("javax.security.auth.login.password", password.toCharArray());
        } else {
            options.put("tryFirstPass", "true");
            options.put("useTicketCache", "true");
        }
        if (tc.isDebugEnabled()) {
            options.put("debug", "true");
        }
        options.put("principal", upn);
        sharedState.put("javax.security.auth.login.name", upn);
        WSCallbackHandlerImpl wscbh = new WSCallbackHandlerImpl(upn, password);
        String oldValue = Krb5Common.setPropertyAsNeeded((String)Krb5Common.KRB5_PRINCIPAL, (String)upn);
        krb5.initialize(subject, (CallbackHandler)wscbh, sharedState, options);
        Krb5Common.debugKrb5LoginModule((Subject)subject, (CallbackHandler)wscbh, sharedState, options);
        krb5.login();
        krb5.commit();
        Krb5Common.setPropertyAsNeeded((String)Krb5Common.KRB5_PRINCIPAL, (String)oldValue);
        return subject;
    }
}

