/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.rest.client.cdi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.cdi.extension.WebSphereCDIExtension;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.security.AccessController;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.ProcessBean;
import javax.enterprise.inject.spi.ProcessInjectionPoint;
import javax.enterprise.inject.spi.WithAnnotations;
import org.apache.cxf.microprofile.client.cdi.RestClientBean;
import org.eclipse.microprofile.rest.client.inject.RegisterRestClient;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(configurationPolicy=ConfigurationPolicy.IGNORE, immediate=true, property={"api.classes=org.eclipse.microprofile.rest.client.inject.RegisterRestClient;org.eclipse.microprofile.rest.client.inject.RestClient", "bean.defining.annotations=org.eclipse.microprofile.rest.client.inject.RegisterRestClient", "service.vendor=IBM"})
public class LibertyRestClientExtension
implements WebSphereCDIExtension,
Extension {
    private static final TraceComponent tc = Tr.register(LibertyRestClientExtension.class, null, (String)"com.ibm.ws.microprofile.rest.client.cdi.nls.MPRestClientMessages");
    private final Map<ClassLoader, Set<Class<?>>> restClientClasses = new WeakHashMap();
    private final Set<Throwable> errors = new LinkedHashSet<Throwable>();
    private final Set<String> requestScopedInterfaces = new LinkedHashSet<String>();
    private final Set<InjectionPoint> requestScopedClientInjectionPoints = new LinkedHashSet<InjectionPoint>();
    private final Set<RestClientBean> allClientBeans = new LinkedHashSet<RestClientBean>();
    static final long serialVersionUID = -4415070261442667485L;

    private static ClassLoader getContextClassLoader() {
        return AccessController.doPrivileged(() -> Thread.currentThread().getContextClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void findClients(@Observes @WithAnnotations(value={RegisterRestClient.class}) ProcessAnnotatedType<?> pat) {
        Class restClient = pat.getAnnotatedType().getJavaClass();
        if (restClient.isInterface()) {
            ClassLoader tccl = LibertyRestClientExtension.getContextClassLoader();
            Map<ClassLoader, Set<Class<?>>> map = this.restClientClasses;
            synchronized (map) {
                Set<Class<?>> classes = this.restClientClasses.get(tccl);
                if (classes == null) {
                    classes = new LinkedHashSet();
                    this.restClientClasses.put(tccl, classes);
                }
                classes.add(restClient);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Found RestClient: " + restClient.getName() + " from classloader: " + tccl), (Object[])new Object[0]);
            }
            pat.veto();
        } else {
            this.errors.add(new IllegalArgumentException("The class " + restClient + " is not an interface"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerClientBeans(@Observes AfterBeanDiscovery afterBeanDiscovery, BeanManager beanManager) {
        ClassLoader tccl = LibertyRestClientExtension.getContextClassLoader();
        Set<Class<?>> classes = null;
        Map<ClassLoader, Set<Class<?>>> map = this.restClientClasses;
        synchronized (map) {
            classes = this.restClientClasses.get(tccl);
        }
        if (classes != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Registering RestClients from classloader: " + tccl), (Object[])new Object[]{classes});
            }
            classes.stream().map(c -> new RestClientBean(c, beanManager)).forEach(bean -> {
                afterBeanDiscovery.addBean((Bean)bean);
                this.allClientBeans.add((RestClientBean)bean);
            });
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Attempting to register RestClient for unknown app classloader: " + tccl), (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerErrors(@Observes AfterDeploymentValidation afterDeploymentValidation, BeanManager beanManager) {
        this.errors.forEach(arg_0 -> ((AfterDeploymentValidation)afterDeploymentValidation).addDeploymentProblem(arg_0));
        try {
            for (InjectionPoint point : this.requestScopedClientInjectionPoints) {
                for (Bean bean : this.allClientBeans) {
                    if (!bean.getBeanClass().equals(point.getType()) || !Dependent.class.isAssignableFrom(bean.getScope())) continue;
                    Class clientClass = bean.getBeanClass();
                    this.requestScopedInterfaces.add(clientClass.getName() + "(" + point.getBean().getBeanClass().getName() + ")");
                }
            }
            if (!this.requestScopedInterfaces.isEmpty() || !this.requestScopedClientInjectionPoints.isEmpty()) {
                Tr.info((TraceComponent)tc, (String)"rest.client.interface.using.request.scope", (Object[])new Object[]{this.requestScopedInterfaces.stream().collect(Collectors.joining(" "))});
            }
        }
        finally {
            this.allClientBeans.clear();
            this.requestScopedClientInjectionPoints.clear();
            this.requestScopedInterfaces.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logRequestScopedClientInterfaces(@Observes ProcessBean<?> processBean) {
        Class beanScope;
        Set classes;
        Bean bean = processBean.getBean();
        ClassLoader tccl = LibertyRestClientExtension.getContextClassLoader();
        Map<ClassLoader, Set<Class<?>>> map = this.restClientClasses;
        synchronized (map) {
            classes = this.restClientClasses.getOrDefault(tccl, Collections.EMPTY_SET);
        }
        Class beanClass = bean.getBeanClass();
        if (classes.contains(beanClass) && RequestScoped.class.isAssignableFrom(beanScope = bean.getScope())) {
            this.requestScopedInterfaces.add(beanClass.getName());
        }
    }

    public void logDependentScopedInterfacesInjectedIntoRequestScopedBeans(@Observes ProcessInjectionPoint<?, ?> pip) {
        InjectionPoint point = pip.getInjectionPoint();
        Bean bean = point.getBean();
        if (bean != null && RequestScoped.class.isAssignableFrom(bean.getScope())) {
            this.requestScopedClientInjectionPoints.add(point);
        }
    }
}

