/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.udpchannel.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.udpchannel.internal.UDPBufferImpl;
import com.ibm.wsspi.bytebuffer.WsByteBuffer;
import com.ibm.wsspi.channelfw.objectpool.CircularObjectPool;
import com.ibm.wsspi.channelfw.objectpool.ObjectPool;
import java.net.SocketAddress;

public class UDPBufferFactory {
    private static TraceComponent tc = Tr.register(UDPBufferFactory.class, (String)"UDPChannel", (String)"com.ibm.ws.udpchannel.internal.resources.UDPMessages");
    private static UDPBufferFactory ofInstance = null;
    private static final int OBJ_SIZE = 100;
    private static final ObjectPool udpBufferObjectPool = new CircularObjectPool(100);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static UDPBufferFactory getRef() {
        if (null != ofInstance) return ofInstance;
        Class<UDPBufferFactory> clazz = UDPBufferFactory.class;
        synchronized (UDPBufferFactory.class) {
            if (null != ofInstance) return ofInstance;
            ofInstance = new UDPBufferFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return ofInstance;
        }
    }

    public static UDPBufferImpl getUDPBuffer() {
        return UDPBufferFactory.getRef().getUDPBufferImpl();
    }

    public static UDPBufferImpl getUDPBuffer(WsByteBuffer buffer, SocketAddress address) {
        UDPBufferImpl udpBuffer = UDPBufferFactory.getRef().getUDPBufferImpl();
        udpBuffer.set(buffer, address);
        return udpBuffer;
    }

    private UDPBufferFactory() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Created UDPBuffer factory; " + this), (Object[])new Object[0]);
        }
    }

    protected UDPBufferImpl getUDPBufferImpl() {
        UDPBufferImpl ret = (UDPBufferImpl)udpBufferObjectPool.get();
        if (ret == null) {
            ret = new UDPBufferImpl(this);
        }
        return ret;
    }

    protected void release(UDPBufferImpl buffer) {
        buffer.clear();
        udpBufferObjectPool.put(buffer);
    }
}

