/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.translator.compiler;

import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.jsp.JspOptions;
import com.ibm.ws.jsp.translator.compiler.JikesJspCompiler;
import com.ibm.ws.jsp.translator.compiler.StandardJspCompiler;
import com.ibm.wsspi.jsp.compiler.JspCompiler;
import com.ibm.wsspi.jsp.compiler.JspCompilerFactory;
import com.ibm.wsspi.jsp.context.JspClassloaderContext;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
public class JspCompilerFactoryImpl
implements JspCompilerFactory {
    protected static Logger logger = Logger.getLogger("com.ibm.ws.jsp");
    private static final String CLASS_NAME = "com.ibm.ws.jsp.translator.compiler.JspCompilerFactoryImpl";
    private static final String WAS_ROOT_BASE = System.getProperty("was.install.root");
    private String absouluteContextRoot;
    private JspClassloaderContext classloaderContext;
    private JspOptions options;
    private String classpath;
    boolean useOptimizedClasspath;
    static final long serialVersionUID = 1699482507997011825L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JspCompilerFactoryImpl(String absouluteContextRoot, JspClassloaderContext classloaderContext, JspOptions options) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "<init>", new Object[]{absouluteContextRoot, classloaderContext, options});
        }
        this.classpath = null;
        this.useOptimizedClasspath = false;
        this.absouluteContextRoot = absouluteContextRoot;
        this.classloaderContext = classloaderContext;
        this.options = options;
        logger.logp(Level.FINE, CLASS_NAME, "JspCompilerFactoryImpl", "jspCompileClasspath: " + options.getJspCompileClasspath());
        if (WAS_ROOT_BASE != null) {
            this.classpath = classloaderContext.getOptimizedClassPath();
            if (options.getJspCompileClasspath() != null) {
                this.useOptimizedClasspath = true;
            }
        } else {
            this.classpath = classloaderContext.getClassPath() + File.pathSeparatorChar + options.getOutputDir().getPath();
            this.useOptimizedClasspath = true;
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "<init>", this);
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JspCompiler createJspCompiler() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "createJspCompiler", new Object[0]);
        }
        if (this.options.isUseJikes()) {
            JikesJspCompiler jikesJspCompiler = new JikesJspCompiler(this.absouluteContextRoot, this.classloaderContext, this.options, this.classpath, this.useOptimizedClasspath);
            if (logger != null && logger.isLoggable(Level.FINER)) {
                jikesJspCompiler = jikesJspCompiler;
                logger.exiting(CLASS_NAME, "createJspCompiler", jikesJspCompiler);
            }
            return jikesJspCompiler;
        }
        StandardJspCompiler standardJspCompiler = new StandardJspCompiler(this.classloaderContext, this.options, this.classpath, this.useOptimizedClasspath);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            standardJspCompiler = standardJspCompiler;
            logger.exiting(CLASS_NAME, "createJspCompiler", standardJspCompiler);
        }
        return standardJspCompiler;
    }
}

