/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.security.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.webcontainer.internalRuntimeExport.srt.IPrivateRequestAttributes;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class SRTServletRequestUtils {
    private static final TraceComponent tc = Tr.register(SRTServletRequestUtils.class, (String)"WebAppSecurity", (String)"com.ibm.ws.webcontainer.security.resources.WebAppSecurityMessages");
    static final long serialVersionUID = -5512437609588298775L;

    public static Object getPrivateAttribute(HttpServletRequest req, String key) {
        HttpServletRequest sr = SRTServletRequestUtils.getWrappedServletRequestObject(req);
        if (sr instanceof IPrivateRequestAttributes) {
            return ((IPrivateRequestAttributes)sr).getPrivateAttribute(key);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getPrivateAttribute called for non-IPrivateRequestAttributes object", (Object[])new Object[]{req});
        }
        return null;
    }

    public static void setPrivateAttribute(HttpServletRequest req, String key, Object object) {
        HttpServletRequest sr = SRTServletRequestUtils.getWrappedServletRequestObject(req);
        if (sr instanceof IPrivateRequestAttributes) {
            ((IPrivateRequestAttributes)sr).setPrivateAttribute(key, object);
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getPrivateAttribute called for non-IPrivateRequestAttributes object", (Object[])new Object[]{req});
        }
    }

    public static void removePrivateAttribute(HttpServletRequest req, String key) {
        HttpServletRequest sr = SRTServletRequestUtils.getWrappedServletRequestObject(req);
        if (sr instanceof IPrivateRequestAttributes) {
            ((IPrivateRequestAttributes)sr).removePrivateAttribute(key);
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getPrivateAttribute called for non-IPrivateRequestAttributes object", (Object[])new Object[]{req});
        }
    }

    @Sensitive
    public static String getHeader(HttpServletRequest req, String key) {
        HttpServletRequest sr = SRTServletRequestUtils.getWrappedServletRequestObject(req);
        return sr.getHeader(key);
    }

    private static HttpServletRequest getWrappedServletRequestObject(HttpServletRequest sr) {
        if (sr instanceof HttpServletRequestWrapper) {
            HttpServletRequestWrapper w = (HttpServletRequestWrapper)sr;
            sr = (HttpServletRequest)w.getRequest();
            while (sr instanceof HttpServletRequestWrapper) {
                sr = (HttpServletRequest)((HttpServletRequestWrapper)sr).getRequest();
            }
        }
        return sr;
    }
}

